﻿using System;
using System.Collections.Generic;
using System.Text;
using Editor.Parser;
using NUnit.Framework;
using IronPython.Hosting;
using Editor;
using NUnit.Framework.SyntaxHelpers;

namespace EditorTest.Parser
{
    [TestFixture]
    public class PythonDictionaryTest
    {
        PythonEngine _engine = new PythonEngine();
        PythonDictionary _dictionary;

        [SetUp]
        public void SetUp()
        {
            _dictionary = new PythonDictionary(_engine);
        }
        [TearDown]
        public void TearDown()
        {
            
        }
        [Test]
        public void ドットネットのインスタンスの子供取得()
        {
            TestClass test = new TestClass();
            _engine.Execute("import System");
            _engine.Globals["test"] = test;

            PythonParser parser = new PythonParser();
            IParseResult result = parser.Parse("test.", 5);

            string[] children = _dictionary.GetChild(result);
            Assert.That(children, Has.Some.EqualTo("Method"));

            HelpContentCollection help = _dictionary.GetHelp(result);
            Assert.That(help.Count, Is.EqualTo(0));
        }
        [Test]
        public void ドットネットのメソッドのヘルプ取得()
        {
            TestClass test = new TestClass();
            _engine.Execute("import System");
            _engine.Globals["test"] = test;

            PythonParser parser = new PythonParser();
            string text = "test.Method(test.";
            IParseResult result = parser.Parse(text, text.Length);

            string[] children = _dictionary.GetChild(result);
            Assert.That(children, Has.Some.EqualTo("Method"));

            HelpContentCollection help = _dictionary.GetHelp(result);
            Assert.That(help.Count, Is.Not.EqualTo(0));
        }
    }

    /// <summary>
    /// テストクラスです
    /// </summary>
    class TestClass
    {
        /// <summary>
        /// テストメソッドです
        /// </summary>
        /// <param name="param">テストパラメータです</param>
        /// <returns>テスト戻り値です</returns>
        public string Method(string param)
        {
            return "";
        }
        /// <summary>
        /// オーバーライドテストメソッドです
        /// </summary>
        /// <param name="param">テストパラメータです</param>
        /// <param name="param2">テストパラメータ２です</param>
        /// <returns>テスト戻り値です</returns>
        public string Method(string param,string param2)
        {
            return "";
        }
    }
}
