﻿using System;
using System.Collections.Generic;
using System.Text;
using IrrlichtNetSwig;

namespace HelloWorld
{
    class Program
    {
        static void Main(string[] args)
        {
            IrrlichtDevice device = IrrlichtNet.createDevice(E_DRIVER_TYPE.EDT_DIRECT3D9, new dimension2di(640, 480),16, false, false, true);
            device.setWindowCaption("Hello World! - Irrlicht Engine Demo");
            ISceneManager sceneManager = device.getSceneManager();
            IVideoDriver videoDriver = device.getVideoDriver();
            IGUIEnvironment guiEnvironment = device.getGUIEnvironment();

            guiEnvironment.addStaticText("Hello World! This is the Irrlicht Software renderer!",new recti(10,10,260,22), true);
            IAnimatedMesh mesh = sceneManager.getMesh("../../media/sydney.md2");
            IAnimatedMeshSceneNode node = sceneManager.addAnimatedMeshSceneNode(mesh);
    		node.setMaterialFlag(E_MATERIAL_FLAG.EMF_LIGHTING, false);
            node.setMD2Animation(EMD2_ANIMATION_TYPE.EMAT_STAND);
		    node.setMaterialTexture( 0, videoDriver.getTexture("../../media/sydney.bmp") );

            sceneManager.addCameraSceneNode(null, new vector3df(0, 30, -40), new vector3df(0, 5, 0));

            while (device.run())
            {
                videoDriver.beginScene(true, true, new SColor(255, 0, 0, 255));
                sceneManager.drawAll();
                guiEnvironment.drawAll();
                videoDriver.endScene();
            }
                
        }
    }
}
