#include "irrArray.h"
#include "IBoneSceneNode.h"
#include "IAnimatedMesh.h"
#include "SSkinMeshBuffer.h"

using namespace irr;
using namespace irr::core;
using namespace irr::scene;

//! A vertex weight
struct MyWeight
{
	struct ISkinnedMesh::SWeight* origin;
public:
	MyWeight(ISkinnedMesh::SWeight* p)
	{
		origin = p;
	}
	u16 getBuffer_id()
	{
		return origin->buffer_id;
	}
	void setBuffer_id(u16 val)
	{
		origin->buffer_id = val;
	}

	u32 getVertex_id()
	{
		return origin->vertex_id;
	}
	void setVertex_id(u32 val)
	{
		origin->vertex_id = val;
	}

	f32 getStrength()
	{
		return origin->strength;
	}
	void setStrength(f32 val)
	{
		origin->strength = val;
	}
};
class MyPositionKey
{
	struct ISkinnedMesh::SPositionKey* origin;
public:
	MyPositionKey(ISkinnedMesh::SPositionKey* p)
	{
		origin = p;
	}
	f32 getFrame()
	{
		return origin->frame;
	}
	void setFrame(f32 val)
	{
		origin->frame = val;
	}
	vector3df getPosition()
	{
		return origin->position;
	}
	void setPosition(vector3df val)
	{
		origin->position = val;
	}

};
class MyScaleKey
{
	struct ISkinnedMesh::SScaleKey* origin;
public:
	MyScaleKey(ISkinnedMesh::SScaleKey* p)
	{
		origin = p;
	}
	f32 getFrame()
	{
		return origin->frame;
	}
	void setFrame(f32 val)
	{
		origin->frame = val;
	}
	vector3df getScale()
	{
		return origin->scale;
	}
	void setScale(vector3df val)
	{
		origin->scale = val;
	}

};
class MyRotationKey
{
	struct ISkinnedMesh::SRotationKey* origin;
public:
	MyRotationKey(ISkinnedMesh::SRotationKey* p)
	{
		origin = p;
	}
	f32 getFrame()
	{
		return origin->frame;
	}
	void setFrame(f32 val)
	{
		origin->frame = val;
	}
	quaternion getRotation()
	{
		return origin->rotation;
	}
	void setRotation(quaternion val)
	{
		origin->rotation = val;
	}
};
class MyJoint
{
public:
	MyJoint(ISkinnedMesh::SJoint* p)
	{
		origin = p;
	}
	struct ISkinnedMesh::SJoint* origin;

	const c8* getName()
	{
		return origin->Name.c_str();
	}
	void setName(c8* val)
	{
		origin->Name = val;
	}
	matrix4 getLocalMatrix()
	{
		return origin->LocalMatrix;
	}
	void setLocalMatrix(matrix4 val)
	{
		origin->LocalMatrix = val;
	}
	array<u32> getAttachedMeshes()
	{
		return origin->AttachedMeshes;
	}
	void setAttachedMeshes(array<u32> val)
	{
		origin->AttachedMeshes = val;
	}
	array<MyPositionKey> getPositionKeys()
	{
		array<MyPositionKey> list;
		for(int i = 0; i < origin->PositionKeys.size(); i++)
		{
			list.push_back(MyPositionKey(&origin->PositionKeys[i]));
		}
		return list;
	}
	array<MyScaleKey> getScaleKeys()
	{
		array<MyScaleKey> list;
		for(int i = 0; i < origin->ScaleKeys.size(); i++)
		{
			list.push_back(MyScaleKey(&origin->ScaleKeys[i]));
		}
		return list;
	}
	array<MyRotationKey> getRotationKeys()
	{
		array<MyRotationKey> list;
		for(int i = 0; i < origin->RotationKeys.size(); i++)
		{
			list.push_back(MyRotationKey(&origin->RotationKeys[i]));
		}
		return list;
	}
	array<MyWeight> getWeights()
	{
		array<MyWeight> list;
		for(int i = 0; i < origin->Weights.size(); i++)
		{
			list.push_back(MyWeight(&origin->Weights[i]));
		}
		return list;
	}
	matrix4 getGlobalMatrix()
	{
		return origin->GlobalMatrix;
	}
	void setGlobalMatrix(matrix4 val)
	{
		origin->GlobalMatrix = val;
	}
	matrix4 getGlobalAnimatedMatrix()
	{
		return origin->GlobalAnimatedMatrix;
	}
	void setGlobalAnimatedMatrix(matrix4 val)
	{
		origin->GlobalAnimatedMatrix = val;
	}
	matrix4 getLocalAnimatedMatrix()
	{
		return origin->LocalAnimatedMatrix;
	}
	void setLocalAnimatedMatrix(matrix4 val)
	{
		origin->LocalAnimatedMatrix = val;
	}
	vector3df getAnimatedposition()
	{
		return origin->Animatedposition;
	}
	void setAnimatedposition(vector3df val)
	{
		origin->Animatedposition = val;
	}
	vector3df getAnimatedscale()
	{
		return origin->Animatedscale;
	}
	void setAnimatedscale(vector3df val)
	{
		origin->Animatedscale = val;
	}
	quaternion getAnimatedrotation()
	{
		return origin->Animatedrotation;
	}
	void setAnimatedrotation(quaternion val)
	{
		origin->Animatedrotation = val;
	}
	matrix4 getGlobalInversedMatrix()
	{
		return origin->GlobalInversedMatrix;
	}
	void setGlobalInversedMatrix(matrix4 val)
	{
		origin->GlobalInversedMatrix = val;
	}


};



