﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace CreateCSProj
{
    class Program
    {
        static void Main(string[] args)
        {
            string template = "    <Compile Include=\"..\\{0}\">\r\n      <Link>{0}</Link>\r\n    </Compile>\r\n";
            string template2 = "    <Compile Include=\"{0}\" />\r\n";
            if(args.Length<3)
            {
                Console.WriteLine("Error:Excepted CreateCSProj <searchDir> <searchDir> <createFileName>");
                Environment.Exit(1);
                return;
            }
            string searchDir = args[0];
            string searchDir2 = args[1];
            string createFileName = args[2];

            string[] files = System.IO.Directory.GetFiles(searchDir, "*.cs", SearchOption.TopDirectoryOnly);

            StringBuilder stringBuilder = new StringBuilder();
            foreach (var file in files)
            {
                stringBuilder.Append(string.Format(template, file));
            }

            files = System.IO.Directory.GetFiles(searchDir2, "*.cs", SearchOption.TopDirectoryOnly);
            StringBuilder stringBuilder2 = new StringBuilder();
            foreach (var file in files)
            {
                stringBuilder2.Append(string.Format(template2, Path.GetFileName(file)));
            }

            var regex = new System.Text.RegularExpressions.Regex(@"<!-- InsertPoint -->");
            var regex2 = new System.Text.RegularExpressions.Regex(@"<!-- InsertPoint2 -->");

            string dir = Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location);
            var sr = new StreamReader(Path.Combine(dir, "IrrlichtNETSwig.csproj.template"), Encoding.UTF8);
            string line= sr.ReadToEnd();
            sr.Close();

            line = regex.Replace(line, stringBuilder.ToString());
            line = regex2.Replace(line, stringBuilder2.ToString());

            var sw = new StreamWriter(createFileName, false, Encoding.UTF8);
            sw.Write(line);
            sw.Close();
        }
    }
}
