/*
 * Decompiled with CFR 0.152.
 */
package org.lightdi.container.config.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lightdi.container.config.ComponentConfig;
import org.lightdi.container.config.ContainerConfig;
import org.lightdi.container.config.parser.ConfigLoadUtil;
import org.lightdi.util.ObjectUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigLoadHandler
extends DefaultHandler {
    private Map<String, ContainerConfig> containerConfigs = new HashMap<String, ContainerConfig>();
    private Map<String, ContainerConfig> includedConfigXMLs = new ConcurrentHashMap<String, ContainerConfig>();
    private ContainerConfig currentContainer;
    private ComponentConfig currentComponent;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (name.equals("container")) {
            if (attributes.getValue("path") != null) {
                ContainerConfig containerConfig = new ContainerConfig();
                containerConfig = ConfigLoadUtil.readContainerConfig(containerConfig, attributes);
                this.includedConfigXMLs.put(containerConfig.getPath(), containerConfig);
                this.containerConfigs.put(containerConfig.getName(), containerConfig);
            } else {
                String containerName = attributes.getValue("name");
                if (containerName == null) {
                    containerName = "lightdi-container";
                }
                ContainerConfig containerConfig = ConfigLoadUtil.getRegisteredOrNewContainerConfig(this.containerConfigs, containerName);
                containerConfig = ConfigLoadUtil.readContainerConfig(containerConfig, attributes);
                this.containerConfigs.put(containerConfig.getName(), containerConfig);
                this.currentContainer = containerConfig;
            }
        } else if (name.equals("component")) {
            String componentName = attributes.getValue("name");
            ComponentConfig config = ConfigLoadUtil.getRegisteredOrNewComponentConfig(this.currentContainer.getComponents(), componentName);
            config = ConfigLoadUtil.readComponentConfig(config, attributes);
            this.currentContainer.getComponents().put(componentName, config);
            this.currentComponent = config;
        } else if (name.equals("constructorArg")) {
            ComponentConfig.ConstructorArg config = new ComponentConfig.ConstructorArg();
            config = ConfigLoadUtil.readConstructorArgConfig(config, attributes);
            this.currentComponent.getConstructorArgs().add(config);
        } else if (name.equals("setterArg")) {
            ComponentConfig.SetterArg config = new ComponentConfig.SetterArg();
            config = ConfigLoadUtil.readSetterArgConfig(config, attributes);
            this.currentComponent.getSetterArgs().add(config);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("container")) {
            if (this.currentContainer != null) {
                ContainerConfig config = ObjectUtil.deepCopy(this.currentContainer);
                this.containerConfigs.put(config.getName(), config);
            }
        } else if (name.equals("component")) {
            ComponentConfig config = ObjectUtil.deepCopy(this.currentComponent);
            this.currentContainer.getComponents().put(config.getName(), config);
        }
    }

    public Map<String, ContainerConfig> getContainerConfigs() {
        return this.containerConfigs;
    }

    public void setContainerConfigs(Map<String, ContainerConfig> containerConfigs) {
        this.containerConfigs = containerConfigs;
    }

    public Map<String, ContainerConfig> getIncludedConfigXMLs() {
        return this.includedConfigXMLs;
    }

    public void setCurrentContainer(ContainerConfig currentContainer) {
        this.currentContainer = currentContainer;
    }

    public ContainerConfig getCurrentContainer() {
        return this.currentContainer;
    }
}

