/*
 * Decompiled with CFR 0.152.
 */
package org.lightdi.container.factory;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lightdi.container.DIContainer;
import org.lightdi.container.config.ComponentConfig;
import org.lightdi.container.config.ConfigXML;
import org.lightdi.container.config.ContainerConfig;
import org.lightdi.container.config.parser.ConfigLoadUtil;
import org.lightdi.container.factory.DIContainerManager;
import org.lightdi.container.impl.DIContainerImpl;
import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.meta.MetaComponentRef;
import org.lightdi.util.ArrayUtil;
import org.lightdi.util.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DIContainerFactory {
    private static final DIContainerManager containerManager = new DIContainerManager();
    private static Logger logger = Logger.getLogger("lightdi");
    private static final String LIGHT_DI_CONFIG_PATH = "lightdi-config.xml";

    private static void infoLogging(String msg) {
        String className = DIContainerFactory.class.getCanonicalName();
        String methodName = "staticLoading";
        logger.logp(Level.INFO, className, methodName, msg);
    }

    private DIContainerFactory() {
    }

    public static DIContainer getContainer() {
        return containerManager.getContainers().get("lightdi-container");
    }

    public static DIContainer getContainer(String containerName) {
        return containerManager.getContainers().get(containerName);
    }

    public static Map<String, DIContainer> getAllContainers() {
        return containerManager.getContainers();
    }

    public static void addConfigXML(String path) {
        containerManager.getRegisterdConfigXMLList().put(path, new ConfigXML());
    }

    public static void removeCofingXML(String path) {
        containerManager.getRegisterdConfigXMLList().get(path);
        containerManager.getRegisterdConfigXMLList().remove(path);
    }

    public static void clearAllContainers() {
        containerManager.setRegisterdConfigXMLList(new ConcurrentHashMap<String, ConfigXML>());
        containerManager.setContainers(new ConcurrentHashMap<String, DIContainer>());
    }

    public static void reloadContainers() {
        DIContainerFactory.parseConfigXML();
    }

    private static void parseConfigXML() {
        Map<String, ConfigXML> configXMLMapping = containerManager.getRegisterdConfigXMLList();
        ConcurrentHashMap<String, ContainerConfig> containerMapping = new ConcurrentHashMap<String, ContainerConfig>();
        Set<String> configXMLSet = configXMLMapping.keySet();
        Map<String, ContainerConfig> configMap = null;
        for (String configXML : configXMLSet) {
            configMap = ConfigLoadUtil.readConfigXML(configXML);
            Set<String> containerNameSet = configMap.keySet();
            for (String containerName : containerNameSet) {
                containerMapping.put(containerName, configMap.get(containerName));
            }
            ConfigXML element = new ConfigXML();
            element.setContainers(configMap);
            configXMLMapping.put(configXML, element);
        }
        try {
            Map<String, DIContainer> containers = DIContainerFactory.createContainerConfigMapping(containerMapping);
            containerManager.setContainers(containers);
        }
        catch (Exception e) {
            e.printStackTrace();
            DIContainerFactory.infoLogging(e.getMessage());
        }
    }

    private static Map<String, DIContainer> createContainerConfigMapping(Map<String, ContainerConfig> containerMapping) throws Exception {
        ConcurrentHashMap<String, DIContainer> ret = new ConcurrentHashMap<String, DIContainer>();
        Set<String> nameSet = containerMapping.keySet();
        for (String name : nameSet) {
            ContainerConfig config = containerMapping.get(name);
            DIContainer container = DIContainerFactory.createContainer(config);
            container = DIContainerFactory.createSingletonComponents(container);
            ret.put(container.getName(), container);
        }
        return ret;
    }

    private static DIContainer createSingletonComponents(DIContainer container) {
        for (MetaComponent component : container.getMetaComponents()) {
            MetaComponentRef ref;
            for (Object constArg : component.getConstructorArgValues()) {
                if (!(constArg instanceof MetaComponentRef)) continue;
                ref = (MetaComponentRef)constArg;
                constArg = container.getComponent(ref.getName());
            }
            for (Object setArg : component.getSetterArgValues()) {
                if (!(setArg instanceof MetaComponentRef)) continue;
                ref = (MetaComponentRef)setArg;
                setArg = container.getComponent(ref.getName());
            }
            if (!component.getInstanceType().equals("singleton")) continue;
            container.getSingletonComponents().put(component.getName(), container.getComponent(component.getName()));
        }
        return container;
    }

    private static DIContainer createContainer(ContainerConfig config) throws Exception {
        DIContainerImpl container = new DIContainerImpl();
        container.setName(config.getName());
        ArrayList<MetaComponent> metaComponents = new ArrayList<MetaComponent>();
        ConcurrentHashMap<String, Object> singletonComponents = new ConcurrentHashMap<String, Object>();
        container.setMetaComponents(metaComponents);
        container.setSingletonComponents(singletonComponents);
        Map<String, ComponentConfig> componentConfigs = config.getComponents();
        Set<String> configNameSet = componentConfigs.keySet();
        for (String configName : configNameSet) {
            String instanceType;
            MetaComponent meta = new MetaComponent();
            ComponentConfig componentConfig = componentConfigs.get(configName);
            String name = componentConfig.getName();
            meta.setName(name);
            String className = componentConfig.getClassName();
            meta.setClassName(className);
            Object value = componentConfig.getValue();
            meta.setValue(value);
            List<ComponentConfig.ConstructorArg> constructorArgList = componentConfig.getConstructorArgs();
            for (ComponentConfig.ConstructorArg arg : constructorArgList) {
                if (arg == null) break;
                Class<Object> conClass = null;
                Object conValue = null;
                if (arg.getRef() != null) {
                    ComponentConfig referred = componentConfigs.get(arg.getRef().getName());
                    instanceType = referred.getInstanceType();
                    if ("singleton".equals(instanceType)) {
                        throw new IllegalStateException("Instance type of the referred component must be 'prototype' : " + arg.getRef().getName());
                    }
                    conClass = MetaComponentRef.class;
                    conValue = arg.getRef();
                } else {
                    String conClassName = arg.getClassName();
                    conClass = Class.forName(conClassName);
                    conValue = arg.getValue();
                }
                meta.getConstructorArgTypes().add(conClass);
                meta.getConstructorArgValues().add(conValue);
            }
            Class<?> clazz = Class.forName(className);
            List<Class<?>> conTypes = meta.getConstructorArgTypes();
            List<Object> conValues = meta.getConstructorArgValues();
            int conLen = conTypes.size();
            for (int i = 0; i < conLen; ++i) {
                if (conTypes.get(i) != MetaComponentRef.class) continue;
                MetaComponentRef ref = (MetaComponentRef)conValues.get(i);
                ComponentConfig refConfig = componentConfigs.get(ref.getName());
                conTypes.set(i, Class.forName(refConfig.getClassName()));
            }
            Constructor<?> constructor = clazz.getConstructor(ArrayUtil.toArray(conTypes));
            meta.setConstructor(constructor);
            instanceType = componentConfig.getInstanceType();
            meta.setInstanceType(instanceType);
            List<ComponentConfig.SetterArg> setterArgList = componentConfig.getSetterArgs();
            for (ComponentConfig.SetterArg arg : setterArgList) {
                if (arg == null) continue;
                String setName = arg.getName();
                meta.getSetterNames().add(setName);
                Class<Object> setClass = null;
                Object setValue = null;
                if (arg.getRef() != null) {
                    ComponentConfig referred = componentConfigs.get(arg.getRef().getName());
                    String setInstanceType = referred.getInstanceType();
                    if ("singleton".equals(setInstanceType)) {
                        throw new IllegalStateException("Instance type of the referred component must be 'prototype' : " + arg.getRef().getName());
                    }
                    setClass = MetaComponentRef.class;
                    setValue = arg.getRef();
                } else {
                    String conClassName = arg.getClassName();
                    setClass = Class.forName(conClassName);
                    setValue = arg.getValue();
                }
                meta.getSetterArgTypes().add(setClass);
                meta.getSetterArgValues().add(setValue);
            }
            List<Class<?>> setTypes = meta.getSetterArgTypes();
            List<Object> setValues = meta.getSetterArgValues();
            int setLen = setTypes.size();
            for (int i = 0; i < setLen; ++i) {
                if (setTypes.get(i) != MetaComponentRef.class) continue;
                MetaComponentRef ref = (MetaComponentRef)setValues.get(i);
                ComponentConfig refConfig = componentConfigs.get(ref.getName());
                setTypes.set(i, Class.forName(refConfig.getClassName()));
            }
            metaComponents.add(meta);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = ResourceUtil.getResourceStream(LIGHT_DI_CONFIG_PATH);
        try {
            if (is != null) {
                DIContainerFactory.infoLogging("LightDI static load start.");
                DIContainerFactory.addConfigXML(LIGHT_DI_CONFIG_PATH);
                DIContainerFactory.reloadContainers();
                Map<String, DIContainer> containers = DIContainerFactory.getAllContainers();
                Set<String> nameSet = containers.keySet();
                for (String name : nameSet) {
                    DIContainerFactory.infoLogging("Loaded DIContainer : " + name);
                }
                DIContainerFactory.infoLogging("LightDI static load end. (" + containers.size() + " containers)");
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
        }
        ClassLoader classLoader = DIContainer.class.getClassLoader();
        Field classes = null;
        try {
            classes = ClassLoader.class.getDeclaredField("classes");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        classes.setAccessible(true);
        Vector loadedClasses = null;
        try {
            loadedClasses = (Vector)classes.get(classLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Class clazz : loadedClasses) {
        }
    }
}

