/*
 * Decompiled with CFR 0.152.
 */
package org.lightdi.container.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lightdi.container.DIContainer;
import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.meta.MetaComponentRef;
import org.lightdi.container.security.ContainerLockKey;
import org.lightdi.container.util.MetaComponentUtil;
import org.lightdi.util.ArrayUtil;
import org.lightdi.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DIContainerImpl
implements DIContainer {
    private String name;
    private List<MetaComponent> metaComponents = new ArrayList<MetaComponent>();
    private Map<String, Object> singletonComponents = new ConcurrentHashMap<String, Object>();
    private ContainerLockKey key;

    @Override
    public List<MetaComponent> getMetaComponents() {
        return this.metaComponents;
    }

    @Override
    public void setMetaComponents(List<MetaComponent> metaComponents) {
        this.metaComponents = metaComponents;
    }

    @Override
    public Map<String, Object> getSingletonComponents() {
        return this.singletonComponents;
    }

    @Override
    public void setSingletonComponents(Map<String, Object> singletonComponents) {
        this.singletonComponents = singletonComponents;
    }

    @Override
    public ContainerLockKey getKey() {
        return this.key;
    }

    @Override
    public void setKey(ContainerLockKey key) {
        this.key = key;
    }

    @Override
    public Object getComponent(String componentName) {
        if (this.singletonComponents.get(componentName) != null) {
            return this.singletonComponents.get(componentName);
        }
        Object returnObj = null;
        MetaComponent meta = MetaComponentUtil.getMetaComponent(this.metaComponents, componentName);
        Object[] initArgs = null;
        List<Object> args = meta.getConstructorArgValues();
        List<Class<?>> types = meta.getConstructorArgTypes();
        if (meta.getValue() != null) {
            Class<?> retClass = null;
            try {
                retClass = Class.forName(meta.getClassName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return ReflectionUtil.instantiate(retClass, meta.getValue());
        }
        initArgs = new Object[args.size()];
        int conLen = initArgs.length;
        for (int i = 0; i < conLen; ++i) {
            if (args.get(i) instanceof MetaComponentRef) {
                MetaComponentRef ref = (MetaComponentRef)args.get(i);
                initArgs[i] = this.getComponent(ref.getName());
                continue;
            }
            Class<?> clazz = types.get(i);
            initArgs[i] = ReflectionUtil.instantiate(clazz, args.get(i));
        }
        try {
            returnObj = meta.getConstructor().newInstance(initArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<String> setterNames = meta.getSetterNames();
        int setLen = setterNames.size();
        List<Class<?>> setterTypes = meta.getSetterArgTypes();
        List<Object> setterValues = meta.getSetterArgValues();
        for (int i = 0; i < setLen; ++i) {
            if (!(setterValues.get(i) instanceof MetaComponentRef)) continue;
            MetaComponentRef ref = (MetaComponentRef)setterValues.get(i);
            setterValues.set(i, this.getComponent(ref.getName()));
        }
        try {
            String className = meta.getClassName();
            Class<?> clazz = Class.forName(className);
            for (int i = 0; i < setLen; ++i) {
                String setterName = ReflectionUtil.getSetterMethodName(setterNames.get(i));
                Class<?>[] argTypes = ArrayUtil.toArray(setterTypes);
                Method setter = clazz.getMethod(setterName, argTypes);
                setter.invoke(returnObj, ArrayUtil.toArray(setterValues));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnObj;
    }

    @Override
    public List<Object> getComponents() {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (MetaComponent meta : this.metaComponents) {
            Object value = this.getComponent(meta.getName());
            ret.add(value);
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void lock(ContainerLockKey key) {
        this.key = key;
    }

    @Override
    public void unlock(ContainerLockKey key) {
        if (!this.key.equals(key)) {
            throw new SecurityException("Cannot unlock the container : " + this.name);
        }
        this.key = null;
    }

    @Override
    public boolean isLocked() {
        return this.key != null;
    }
}

