/*
 * Decompiled with CFR 0.152.
 */
package org.lightdi.container.config.parser;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.lightdi.container.config.ComponentConfig;
import org.lightdi.container.config.ContainerConfig;
import org.lightdi.container.config.parser.ConfigLoadHandler;
import org.lightdi.container.meta.MetaComponentRef;
import org.lightdi.util.ObjectUtil;
import org.lightdi.util.ResourceUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigLoadUtil {
    public static Map<String, ContainerConfig> readConfigXML(String configXML) {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        XMLReader reader = null;
        try {
            SAXParser parser = parserFactory.newSAXParser();
            reader = parser.getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException("LightDIContainer load error! (at parser instantiation) : " + e.getMessage());
        }
        ConfigLoadHandler handler = new ConfigLoadHandler();
        reader.setContentHandler(handler);
        reader.setDTDHandler(new DefaultHandler());
        reader.setEntityResolver(new DefaultHandler());
        reader.setErrorHandler(new DefaultHandler());
        InputStream is = null;
        try {
            is = ResourceUtil.getResourceStream(configXML);
            reader.parse(new InputSource(is));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("LightDIContainer load error! (at config file read) : " + configXML);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
        }
        Map<String, ContainerConfig> containers = handler.getContainerConfigs();
        Map<String, ContainerConfig> toRead = handler.getIncludedConfigXMLs();
        Set<String> pathes = toRead.keySet();
        for (String path : pathes) {
            parserFactory = SAXParserFactory.newInstance();
            reader = null;
            try {
                SAXParser parser = parserFactory.newSAXParser();
                reader = parser.getXMLReader();
            }
            catch (Exception e) {
                throw new RuntimeException("LightDIContainer load error! (at parser instantiation) : " + e.getMessage());
            }
            ContainerConfig currentContainer = toRead.get(path);
            String containerName = currentContainer.getName();
            try {
                handler = new ConfigLoadHandler();
                handler.setCurrentContainer(currentContainer);
                reader.setContentHandler(handler);
                reader.setDTDHandler(new DefaultHandler());
                reader.setEntityResolver(new DefaultHandler());
                reader.setErrorHandler(new DefaultHandler());
                is = ResourceUtil.getResourceStream(path);
                reader.parse(new InputSource(is));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("LightDIContainer load error! (at config file read) : " + configXML);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ignore) {}
                }
            }
            ContainerConfig result = handler.getCurrentContainer();
            containers.put(containerName, result);
        }
        return containers;
    }

    public static ContainerConfig readContainerConfig(ContainerConfig src, Attributes attributes) {
        ContainerConfig ret = ObjectUtil.deepCopy(src);
        String containerName = attributes.getValue("name");
        if (containerName == null) {
            containerName = "lightdi-container";
        }
        ret.setName(containerName);
        ret.setLocked(attributes.getValue("locked"));
        ret.setPath(attributes.getValue("path"));
        return ret;
    }

    public static ComponentConfig readComponentConfig(ComponentConfig src, Attributes attributes) {
        ComponentConfig ret = ObjectUtil.deepCopy(src);
        ret.setName(attributes.getValue("name"));
        ret.setValue(attributes.getValue("value"));
        ret.setClassName(attributes.getValue("class"));
        String instanceType = attributes.getValue("instanceType");
        if (instanceType == null) {
            instanceType = "singleton";
        }
        ret.setInstanceType(instanceType);
        return ret;
    }

    public static ComponentConfig.ConstructorArg readConstructorArgConfig(ComponentConfig.ConstructorArg src, Attributes attributes) {
        ComponentConfig.ConstructorArg ret = ObjectUtil.deepCopy(src);
        String refName = attributes.getValue("ref");
        if (refName != null) {
            ret.setRef(new MetaComponentRef(refName));
        }
        ret.setClassName(attributes.getValue("class"));
        ret.setValue(attributes.getValue("value"));
        return ret;
    }

    public static ComponentConfig.SetterArg readSetterArgConfig(ComponentConfig.SetterArg src, Attributes attributes) {
        ComponentConfig.SetterArg ret = ObjectUtil.deepCopy(src);
        String refName = attributes.getValue("ref");
        if (refName != null) {
            ret.setRef(new MetaComponentRef(refName));
        }
        ret.setName(attributes.getValue("name"));
        ret.setClassName(attributes.getValue("class"));
        ret.setValue(attributes.getValue("value"));
        return ret;
    }

    public static ContainerConfig getRegisteredOrNewContainerConfig(Map<String, ContainerConfig> containers, String name) {
        ContainerConfig registerd = containers.get(name);
        return registerd != null ? registerd : new ContainerConfig();
    }

    public static ComponentConfig getRegisteredOrNewComponentConfig(Map<String, ComponentConfig> components, String name) {
        ComponentConfig registerd = components.get(name);
        return registerd != null ? registerd : new ComponentConfig();
    }
}

