package org.lightdi.container.config.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.lightdi.container.DIContainer;
import org.lightdi.container.config.ComponentConfig;
import org.lightdi.container.config.ContainerConfig;
import org.lightdi.container.config.ComponentConfig.ConstructorArg;
import org.lightdi.container.config.ComponentConfig.SetterArg;
import org.lightdi.container.config.tag.ComponentTag;
import org.lightdi.container.config.tag.ContainerTag;
import org.lightdi.util.ObjectUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigLoadHandler extends DefaultHandler
{
	private Map<String, ContainerConfig> containerConfigs = new HashMap<String, ContainerConfig>();
	private Map<String, ContainerConfig> includedConfigXMLs = new ConcurrentHashMap<String, ContainerConfig>();
	private ContainerConfig currentContainer;
	private ComponentConfig currentComponent;

	@Override
	public void startElement(String uri, String localName, String name,
			Attributes attributes) throws SAXException
	{
		// read container
		if (name.equals(ContainerTag.ROOT))
		{
			// path setting container
			if (attributes.getValue(ContainerTag.Attributes.PATH) != null)
			{
				// read new file
				ContainerConfig containerConfig = new ContainerConfig();
				containerConfig = ConfigLoadUtil.readContainerConfig(containerConfig,
						attributes);
				includedConfigXMLs.put(containerConfig.getPath(), containerConfig);
				containerConfigs.put(containerConfig.getName(), containerConfig);

			} else
			{
				// new container or not
				String containerName = attributes.getValue(ContainerTag.Attributes.NAME);
				if (containerName == null)
					containerName = DIContainer.DEFAULT_CONTAINER_NAME;
				ContainerConfig containerConfig = ConfigLoadUtil
						.getRegisteredOrNewContainerConfig(containerConfigs,
								containerName);
				containerConfig = ConfigLoadUtil.readContainerConfig(containerConfig,
						attributes);
				containerConfigs.put(containerConfig.getName(), containerConfig);
				currentContainer = containerConfig;
			}

		} else if (name.equals(ComponentTag.ROOT))
		{
			String componentName = attributes.getValue(ComponentTag.Attributes.NAME);
			ComponentConfig config = ConfigLoadUtil.getRegisteredOrNewComponentConfig(
					currentContainer.getComponents(), componentName);
			// component name
			config = ConfigLoadUtil.readComponentConfig(config, attributes);
			// check component name duplication
			currentContainer.getComponents().put(componentName, config);
			currentComponent = config;

		} else if (name.equals(ComponentTag.ConstructorArgTag.ROOT))
		{
			ConstructorArg config = new ConstructorArg();
			config = ConfigLoadUtil.readConstructorArgConfig(config, attributes);
			currentComponent.getConstructorArgs().add(config);

		} else if (name.equals(ComponentTag.SetterArgTag.ROOT))
		{
			SetterArg config = new SetterArg();
			config = ConfigLoadUtil.readSetterArgConfig(config, attributes);
			currentComponent.getSetterArgs().add(config);
		}
	}

	@Override
	public void endElement(String uri, String localName, String name) throws SAXException
	{
		if (name.equals(ContainerTag.ROOT))
		{
			if (currentContainer != null)
			{
				ContainerConfig config = ObjectUtil.deepCopy(currentContainer);
				containerConfigs.put(config.getName(), config);
			}
		} else if (name.equals(ComponentTag.ROOT))
		{
			ComponentConfig config = ObjectUtil.deepCopy(currentComponent);
			currentContainer.getComponents().put(config.getName(), config);
		}
	}

	public Map<String, ContainerConfig> getContainerConfigs()
	{
		return containerConfigs;
	}

	public void setContainerConfigs(Map<String, ContainerConfig> containerConfigs)
	{
		this.containerConfigs = containerConfigs;
	}

	public Map<String, ContainerConfig> getIncludedConfigXMLs()
	{
		return includedConfigXMLs;
	}

	/**
	 * @param currentContainer
	 *            the currentContainer to set
	 */
	public void setCurrentContainer(ContainerConfig currentContainer)
	{
		this.currentContainer = currentContainer;
	}

	/**
	 * @return the currentContainer
	 */
	public ContainerConfig getCurrentContainer()
	{
		return currentContainer;
	}

}
