package org.lightdi.container.factory;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.lightdi.container.DIContainer;
import org.lightdi.container.config.ComponentConfig;
import org.lightdi.container.config.ConfigXML;
import org.lightdi.container.config.ContainerConfig;
import org.lightdi.container.config.ComponentConfig.ConstructorArg;
import org.lightdi.container.config.ComponentConfig.SetterArg;
import org.lightdi.container.config.parser.ConfigLoadUtil;
import org.lightdi.container.impl.DIContainerImpl;
import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.meta.MetaComponentRef;
import org.lightdi.util.ArrayUtil;
import org.lightdi.util.ResourceUtil;

public class DIContainerFactory
{
	private static final DIContainerManager containerManager = new DIContainerManager();
	private static Logger logger = Logger.getLogger("lightdi");

	private static void infoLogging(String msg)
	{
		String className = DIContainerFactory.class.getCanonicalName();
		String methodName = "staticLoading";
		logger.logp(Level.INFO, className, methodName, msg);
	}

	private static final String LIGHT_DI_CONFIG_PATH = "lightdi-config.xml";
	static
	{
		// create di containers
		InputStream is = ResourceUtil.getResourceStream(LIGHT_DI_CONFIG_PATH);
		try
		{
			// load start
			if (is != null)
			{
				infoLogging("LightDI static load start.");
				addConfigXML(LIGHT_DI_CONFIG_PATH);
				reloadContainers();
				Map<String, DIContainer> containers = getAllContainers();
				Set<String> nameSet = containers.keySet();
				for (String name : nameSet)
				{
					// TODO
					infoLogging("Loaded DIContainer : " + name);
				}
				infoLogging("LightDI static load end. (" + containers.size()
						+ " containers)");
			}
		} finally
		{
			if (is != null)
			{
				try
				{
					is.close();

				} catch (Exception ignore)
				{
				}
			}
		}
		// auto injection
		// TODO
		ClassLoader classLoader = DIContainer.class.getClassLoader();
		Field classes = null;
		try
		{
			classes = ClassLoader.class.getDeclaredField("classes");
		} catch (Exception e)
		{
			// TODO: handle exception
			e.printStackTrace();
		}
		classes.setAccessible(true);
		Vector<Class<?>> loadedClasses = null;
		try
		{
			loadedClasses = (Vector<Class<?>>) classes.get(classLoader);
		} catch (Exception e)
		{
			// TODO: handle exception
			e.printStackTrace();
		}
		for (Class<?> clazz : loadedClasses)
		{
			// System.out.println(clazz.getName());
		}
	}

	private DIContainerFactory()
	{
	}

	public static DIContainer getContainer()
	{
		return containerManager.getContainers().get(DIContainer.DEFAULT_CONTAINER_NAME);
	}

	public static DIContainer getContainer(String containerName)
	{
		return containerManager.getContainers().get(containerName);
	}

	public static Map<String, DIContainer> getAllContainers()
	{
		return containerManager.getContainers();
	}

	public static void addConfigXML(String path)
	{
		containerManager.getRegisterdConfigXMLList().put(path, new ConfigXML());
	}

	public static void removeCofingXML(String path)
	{
		containerManager.getRegisterdConfigXMLList().get(path);
		containerManager.getRegisterdConfigXMLList().remove(path);
	}

	public static void clearAllContainers()
	{
		containerManager
				.setRegisterdConfigXMLList(new ConcurrentHashMap<String, ConfigXML>());
		containerManager.setContainers(new ConcurrentHashMap<String, DIContainer>());
	}

	public static void reloadContainers()
	{
		parseConfigXML();

	}

	private static void parseConfigXML()
	{
		Map<String, ConfigXML> configXMLMapping = containerManager
				.getRegisterdConfigXMLList();
		Map<String, ContainerConfig> containerMapping = new ConcurrentHashMap<String, ContainerConfig>();
		Set<String> configXMLSet = configXMLMapping.keySet();
		Map<String, ContainerConfig> configMap = null;
		for (String configXML : configXMLSet)
		{
			configMap = ConfigLoadUtil.readConfigXML(configXML);
			Set<String> containerNameSet = configMap.keySet();
			for (String containerName : containerNameSet)
			{
				containerMapping.put(containerName, configMap.get(containerName));
			}
			ConfigXML element = new ConfigXML();
			element.setContainers(configMap);
			configXMLMapping.put(configXML, element);

		}
		try
		{
			Map<String, DIContainer> containers = createContainerConfigMapping(containerMapping);
			containerManager.setContainers(containers);
		} catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
			infoLogging(e.getMessage());
		}
	}

	private static Map<String, DIContainer> createContainerConfigMapping(
			Map<String, ContainerConfig> containerMapping) throws Exception
	{
		Map<String, DIContainer> ret = new ConcurrentHashMap<String, DIContainer>();
		Set<String> nameSet = containerMapping.keySet();
		for (String name : nameSet)
		{
			ContainerConfig config = containerMapping.get(name);
			DIContainer container = createContainer(config);
			container = createSingletonComponents(container);
			ret.put(container.getName(), container);
		}
		return ret;
	}

	private static DIContainer createSingletonComponents(DIContainer container)
	{
		for (MetaComponent component : container.getMetaComponents())
		{
			for (Object constArg : component.getConstructorArgValues())
			{
				if (constArg instanceof MetaComponentRef)
				{
					MetaComponentRef ref = (MetaComponentRef) constArg;
					constArg = container.getComponent(ref.getName());
				}
			}
			for (Object setArg : component.getSetterArgValues())
			{
				if (setArg instanceof MetaComponentRef)
				{
					MetaComponentRef ref = (MetaComponentRef) setArg;
					setArg = container.getComponent(ref.getName());
				}
			}
			if (component.getInstanceType().equals(MetaComponent.InstanceType.SINGLETON))
			{
				container.getSingletonComponents().put(component.getName(),
						container.getComponent(component.getName()));
			}
		}
		return container;
	}

	private static DIContainer createContainer(ContainerConfig config) throws Exception
	{
		DIContainer container = new DIContainerImpl();
		container.setName(config.getName());
		List<MetaComponent> metaComponents = new ArrayList<MetaComponent>();
		Map<String, Object> singletonComponents = new ConcurrentHashMap<String, Object>();
		container.setMetaComponents(metaComponents);
		container.setSingletonComponents(singletonComponents);

		Map<String, ComponentConfig> componentConfigs = config.getComponents();

		Set<String> configNameSet = componentConfigs.keySet();
		for (String configName : configNameSet)
		{
			// create meta compoent
			MetaComponent meta = new MetaComponent();
			ComponentConfig componentConfig = componentConfigs.get(configName);
			String name = componentConfig.getName();
			meta.setName(name);
			String className = componentConfig.getClassName();
			meta.setClassName(className);
			Object value = componentConfig.getValue();
			meta.setValue(value);

			// constructor arg setting
			List<ConstructorArg> constructorArgList = componentConfig
					.getConstructorArgs();
			for (ConstructorArg arg : constructorArgList)
			{
				if (arg == null)
					break;

				Class<?> conClass = null;
				Object conValue = null;

				if (arg.getRef() != null)
				{
					// prototype only
					ComponentConfig referred = componentConfigs.get(arg.getRef()
							.getName());
					String instanceType = referred.getInstanceType();
					if (MetaComponent.InstanceType.SINGLETON.equals(instanceType))
					{
						throw new IllegalStateException(
								"Instance type of the referred component must be 'prototype' : "
										+ arg.getRef().getName());
					}
					conClass = MetaComponentRef.class;
					conValue = arg.getRef();
				} else
				{
					String conClassName = arg.getClassName();
					conClass = Class.forName(conClassName);
					conValue = arg.getValue();
				}
				meta.getConstructorArgTypes().add(conClass);
				meta.getConstructorArgValues().add(conValue);
			}
			Class<?> clazz = Class.forName(className);

			// constructor arg ref setting
			List<Class<?>> conTypes = meta.getConstructorArgTypes();
			List<Object> conValues = meta.getConstructorArgValues();
			int conLen = conTypes.size();
			for (int i = 0; i < conLen; i++)
			{
				if (conTypes.get(i) == MetaComponentRef.class)
				{
					MetaComponentRef ref = (MetaComponentRef) conValues.get(i);
					ComponentConfig refConfig = (ComponentConfig) componentConfigs
							.get(ref.getName());
					conTypes.set(i, Class.forName(refConfig.getClassName()));
					// conValues.set(i, refConfig);
				}
			}
			Constructor<?> constructor = clazz
					.getConstructor(ArrayUtil.toArray(conTypes));
			meta.setConstructor(constructor);

			// component instance type setting
			String instanceType = componentConfig.getInstanceType();
			meta.setInstanceType(instanceType);

			// setter arg setting
			List<SetterArg> setterArgList = componentConfig.getSetterArgs();
			for (SetterArg arg : setterArgList)
			{
				if (arg == null)
					continue;

				String setName = arg.getName();
				meta.getSetterNames().add(setName);

				Class<?> setClass = null;
				Object setValue = null;
				if (arg.getRef() != null)
				{
					// prototype only
					ComponentConfig referred = componentConfigs.get(arg.getRef()
							.getName());
					String setInstanceType = referred.getInstanceType();
					if (MetaComponent.InstanceType.SINGLETON.equals(setInstanceType))
					{
						throw new IllegalStateException(
								"Instance type of the referred component must be 'prototype' : "
										+ arg.getRef().getName());
					}
					setClass = MetaComponentRef.class;
					setValue = arg.getRef();
				} else
				{
					String conClassName = arg.getClassName();
					setClass = Class.forName(conClassName);
					setValue = arg.getValue();
				}
				meta.getSetterArgTypes().add(setClass);
				meta.getSetterArgValues().add(setValue);

			}
			// setter arg ref setting
			List<Class<?>> setTypes = meta.getSetterArgTypes();
			List<Object> setValues = meta.getSetterArgValues();
			int setLen = setTypes.size();
			for (int i = 0; i < setLen; i++)
			{
				if (setTypes.get(i) == MetaComponentRef.class)
				{
					MetaComponentRef ref = (MetaComponentRef) setValues.get(i);
					// setValues.set(i, config.getComponent(ref.getName()));
					ComponentConfig refConfig = (ComponentConfig) componentConfigs
							.get(ref.getName());
					setTypes.set(i, Class.forName(refConfig.getClassName()));
					// setValues.set(i, refConfig);
				}
			}

			// // TODO singleton
			// if (MetaComponent.InstanceType.SINGLETON.equals(instanceType))
			// {
			// List<Object> values = meta.getConstructorArgValues();
			// int argLen = values.size();
			// List<Class<?>> types = meta.getConstructorArgTypes();
			// for (int i = 0; i < argLen; i++)
			// {
			// Object conArg = values.get(i);
			// Class<?> type = types.get(i);
			// values.set(i, ReflectionUtil.instantiate(type, conArg));
			// }
			//
			// Object[] args = ArrayUtil.toArray(values);
			// Object singleton = null;
			// if (meta.getValue() != null)
			// {
			// singleton = meta.getValue();
			// } else
			// {
			// singleton = meta.getConstructor().newInstance(args);
			// }
			// List<String> fieldNames = meta.getSetterNames();
			// int len = fieldNames.size();
			// for (int i = 0; i < len; i++)
			// {
			// String setterName = ReflectionUtil.getSetterMethodName(fieldNames
			// .get(i));
			// Class<?> type = meta.getSetterArgTypes().get(i);
			// Method setter = clazz.getMethod(setterName, type);
			// // meta.setSetter(setter);
			// Object setterVal = meta.getSetterArgValues().get(i);
			// // setter.invoke(singleton, setterVal);
			// }
			// singletonComponents.put(meta.getName(), singleton);
			// }

			metaComponents.add(meta);
		}
		return container;
	}
}
