package sample;

import org.lightdi.container.DIContainer;
import org.lightdi.container.factory.DIContainerFactory;

import component.Blog;

public class MainTest
{

	public static void main(String[] args)
	{

		DIContainerFactory.reloadContainers();
		DIContainerFactory.addConfigXML("lightdi-test-config.xml");
		DIContainerFactory.reloadContainers();

		// named container
		DIContainer sampleContainer = DIContainerFactory.getContainer("sampleContainer");
		String helloWorld = (String) sampleContainer.getComponent("helloWorld");
		System.out.println(helloWorld);

		// another named container
		DIContainer yetAnotherContainer = DIContainerFactory
				.getContainer("yetAnotherContainer");
		Blog cocolog = (Blog) yetAnotherContainer.getComponent("cocolog");
		System.out.println(cocolog.getUsername());

		// default container
		DIContainer container = DIContainerFactory.getContainer();
		Blog ameblo = (Blog) container.getComponent("ameblo");
		System.out.println(ameblo.getUsername());
		Blog hatena = (Blog) container.getComponent("hatena");
		System.out.println(hatena.getUsername());
		Blog livedoor = (Blog) container.getComponent("livedoor");
		System.out.println(livedoor.getUsername());

	}

}
