package org.lightdi.container.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.lightdi.container.DIContainer;
import org.lightdi.container.meta.MetaComponent;
import org.lightdi.container.meta.MetaComponentRef;
import org.lightdi.container.security.ContainerLockKey;
import org.lightdi.container.util.MetaComponentUtil;
import org.lightdi.util.ArrayUtil;
import org.lightdi.util.ReflectionUtil;

public class DIContainerImpl implements DIContainer
{
	private String name;
	private List<MetaComponent> metaComponents = new ArrayList<MetaComponent>();
	private Map<String, Object> singletonComponents = new ConcurrentHashMap<String, Object>();
	private ContainerLockKey key;

	public List<MetaComponent> getMetaComponents()
	{
		return metaComponents;
	}

	public void setMetaComponents(List<MetaComponent> metaComponents)
	{
		this.metaComponents = metaComponents;
	}

	public Map<String, Object> getSingletonComponents()
	{
		return singletonComponents;
	}

	public void setSingletonComponents(Map<String, Object> singletonComponents)
	{
		this.singletonComponents = singletonComponents;
	}

	public ContainerLockKey getKey()
	{
		return key;
	}

	public void setKey(ContainerLockKey key)
	{
		this.key = key;
	}

	public Object getComponent(String componentName)
	{
		if (singletonComponents.get(componentName) != null)
		{
			// singleton
			// TODO create timing
			return singletonComponents.get(componentName);
		} else
		{
			// prototype
			Object returnObj = null;
			MetaComponent meta = MetaComponentUtil.getMetaComponent(metaComponents,
					componentName);

			// constructor
			Object[] initArgs = null;
			List<Object> args = meta.getConstructorArgValues();
			List<Class<?>> types = meta.getConstructorArgTypes();

			// specified value attribute
			if (meta.getValue() != null)
			{
				// component is a simple Object
				// not required get several constructor args
				Class<?> retClass = null;
				try
				{
					retClass = Class.forName(meta.getClassName());
				} catch (ClassNotFoundException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				return ReflectionUtil.instantiate(retClass, meta.getValue());
			}

			// constructor args
			initArgs = new Object[args.size()];
			int conLen = initArgs.length;
			for (int i = 0; i < conLen; i++)
			{
				// ref
				if (args.get(i) instanceof MetaComponentRef)
				{
					MetaComponentRef ref = (MetaComponentRef) args.get(i);
					initArgs[i] = getComponent(ref.getName());
				} else
				{
					Class<?> clazz = types.get(i);
					initArgs[i] = ReflectionUtil.instantiate(clazz, args.get(i));
				}
			}
			try
			{
				returnObj = meta.getConstructor().newInstance((Object[]) initArgs);
			} catch (Exception e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			// setter
			// TODO setter injection
			List<String> setterNames = meta.getSetterNames();
			int setLen = setterNames.size();

			List<Class<?>> setterTypes = meta.getSetterArgTypes();
			List<Object> setterValues = meta.getSetterArgValues();

			// get referred component
			for (int i = 0; i < setLen; i++)
			{
				if (setterValues.get(i) instanceof MetaComponentRef)
				{
					MetaComponentRef ref = (MetaComponentRef) setterValues.get(i);
					setterValues.set(i, getComponent(ref.getName()));
				}
			}

			try
			{
				String className = meta.getClassName();
				Class<?> clazz = Class.forName(className);
				for (int i = 0; i < setLen; i++)
				{
					String setterName = ReflectionUtil.getSetterMethodName(setterNames
							.get(i));
					Class<?>[] argTypes = ArrayUtil.toArray(setterTypes);
					Method setter = clazz.getMethod(setterName, argTypes);
					setter.invoke(returnObj, ArrayUtil.toArray(setterValues));
				}
			} catch (Exception e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			return returnObj;
		}
	}

	public List<Object> getComponents()
	{
		List<Object> ret = new ArrayList<Object>();
		for (MetaComponent meta : metaComponents)
		{
			Object value = getComponent(meta.getName());
			ret.add(value);
		}
		return ret;
	}

	public String getName()
	{
		return name;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public void lock(ContainerLockKey key)
	{
		this.key = key;
	}

	public void unlock(ContainerLockKey key)
	{
		if (this.key.equals(key))
			this.key = null;
		else
			throw new SecurityException("Cannot unlock the container : " + name);
	}

	public boolean isLocked()
	{
		return this.key != null ? true : false;
	}

}
