package example;

import org.lightdi.container.DIContainer;
import org.lightdi.container.alias.LightDI;
import org.lightdi.container.factory.LightDIContainerFactory;

import component.Blog;

public class Main
{

	public static void main(String[] args) throws Exception
	{

		// replace component for testing
		LightDIContainerFactory.addConfigXML("lightdi-test-config.xml");
		LightDIContainerFactory.reloadContainers();

		Thread.sleep(100);

		// named container
		DIContainer sampleContainer = LightDIContainerFactory
				.getContainer("sampleContainer");
		String helloWorld = (String) sampleContainer.getComponent("helloWorld");
		System.out.println(helloWorld);

		// another named container
		DIContainer yetAnotherContainer = LightDIContainerFactory
				.getContainer("yetAnotherContainer");
		Blog cocolog = yetAnotherContainer.getComponent("cocolog");
		System.out.println(cocolog.getUsername());

		// default container
		DIContainer container = LightDIContainerFactory.getDefaultContainer();
		Blog ameblo = container.getComponent("ameblo");
		System.out.println(ameblo.getUsername());
		Blog hatena = container.getComponent("hatena");
		System.out.println(hatena.getUsername());
		Blog livedoor = container.getComponent("livedoor");
		System.out.println(livedoor.getUsername());
		Blog excite = container.getComponent("excite");
		System.out.println(excite.getUsername());

		// alias
		DIContainer container2 = LightDI.getDefaultContainer();
		Blog hatena2 = container2.getComponent("hatena");
		System.out.println(hatena2.getUsername());
		Blog ameblo2 = LightDI.inject("ameblo");
		System.out.println(ameblo2.getUsername());

		Blog cocolog2 = LightDI.inject("yetAnotherContainer", "cocolog");
		System.out.println(cocolog2.getUsername());

	}

}
