package org.lightdi.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import junit.framework.TestCase;

public class ResourceUtilTest extends TestCase
{
	public void test_closeBufferedInputStream() throws Exception
	{
		InputStream is = ResourceUtil.getResourceStream("dummy/dummy.txt");
		BufferedInputStream bis = new BufferedInputStream(is);
		bis.available();
		ResourceUtil.close(bis);
		ResourceUtil.close(is);
		try
		{
			bis.available();
			fail("resource has not been closed.");
		} catch (IOException e)
		{
		}
	}

	public void test_closeBufferedInputStream_null() throws Exception
	{
		BufferedInputStream bis = null;
		ResourceUtil.close(bis);
	}

	public void test_closeBufferedReader() throws Exception
	{
		String userDir = ResourceUtil.getSystemPropUserDir();
		String filepath = userDir + "/src/test/resources/dummy/dummy.txt";
		FileReader fr = new FileReader(filepath);
		BufferedReader br = new BufferedReader(fr);
		ResourceUtil.close(br);
		ResourceUtil.close(fr);
		try
		{
			br.ready();
			fail("resource has not been closed.");
		} catch (IOException e)
		{
		}
	}

	public void test_closeBufferedReader_null() throws Exception
	{
		BufferedReader br = null;
		ResourceUtil.close(br);
	}

	public void test_closeFileOutputStream() throws Exception
	{
		String userDir = ResourceUtil.getSystemPropUserDir();
		String filepath = userDir + "/src/test/resources/dummy/output.txt";
		FileOutputStream fos = new FileOutputStream(filepath);
		ResourceUtil.close(fos);
		try
		{
			fos.write(0);
			fail("resource has not been closed.");
		} catch (IOException e)
		{
		}
	}

	public void test_closeFileOutputStream_null() throws Exception
	{
		FileOutputStream fos = null;
		ResourceUtil.close(fos);
	}

	public void test_closeInputStream() throws Exception
	{
		InputStream is = ResourceUtil.getResourceStream("dummy/dummy.txt");
		ResourceUtil.close(is);
		try
		{
			is.available();
			fail("resource has not been closed.");
		} catch (IOException e)
		{
		}
	}

	public void test_closeInputStream_null() throws Exception
	{
		InputStream is = null;
		ResourceUtil.close(is);
	}

	public void test_closeInputStreamReader() throws Exception
	{
		InputStream is = ResourceUtil.getResourceStream("dummy/dummy.txt");
		InputStreamReader isr = new InputStreamReader(is);
		ResourceUtil.close(isr);
		ResourceUtil.close(is);
		try
		{
			isr.ready();
			fail("resource has not been closed.");
		} catch (IOException e)
		{
		}
	}

	public void test_closeInputStreamReader_null() throws Exception
	{
		InputStreamReader isr = null;
		ResourceUtil.close(isr);
	}

	public void test_getResourceStream() throws Exception
	{
		InputStream is = ResourceUtil.getResourceStream("dummy/dummy.txt");
		is.available();
		ResourceUtil.close(is);
	}

	public void test_getResourceStream_null() throws Exception
	{
		InputStream is = ResourceUtil.getResourceStream("aaaa");
		assertNull(is);
		ResourceUtil.close(is);
	}

}
