/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Time
implements Comparable<Time> {
    public final long timeValue;
    public final int timeScale;
    private final double _second;
    private final int _hashCode;

    public Time(long timeValue, int timeScale) {
        this.timeValue = timeValue;
        this.timeScale = timeScale;
        this._second = (double)timeValue / (double)timeScale;
        this._hashCode = (int)(timeValue * 1000L / (long)timeScale);
    }

    public static Time fromFrameNumber(long frameNumber, Time frameDuration) {
        return new Time(frameNumber * frameDuration.timeValue, frameDuration.timeScale);
    }

    public long toFrameNumber(Time frameDuration) {
        if (this.timeScale == frameDuration.timeScale) {
            return this.timeValue / frameDuration.timeValue;
        }
        return this.timeValue * (long)frameDuration.timeScale / ((long)this.timeScale * frameDuration.timeValue);
    }

    public double toSecond() {
        return this._second;
    }

    public boolean before(Time o) {
        return this.compareTo(o) < 0;
    }

    public boolean after(Time o) {
        return this.compareTo(o) > 0;
    }

    @Override
    public int compareTo(Time o) {
        long diff = this.timeScale == o.timeScale ? this.timeValue - o.timeValue : this.timeValue * (long)o.timeScale - (long)this.timeScale * o.timeValue;
        return diff > 0L ? 1 : (diff < 0L ? -1 : 0);
    }

    public Time add(Time addend) {
        if (addend.timeScale == this.timeScale) {
            return new Time(this.timeValue + addend.timeValue, this.timeScale);
        }
        return new Time(this.timeValue + addend.timeValue * (long)this.timeScale / (long)addend.timeScale, this.timeScale);
    }

    public Time subtract(Time subtrahend) {
        if (subtrahend.timeScale == this.timeScale) {
            return new Time(this.timeValue - subtrahend.timeValue, this.timeScale);
        }
        return new Time(this.timeValue - subtrahend.timeValue * (long)this.timeScale / (long)subtrahend.timeScale, this.timeScale);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((Time)obj) == 0;
    }

    public String toString() {
        return "Time [" + this.timeValue + "/" + this.timeScale + "]";
    }
}

