/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.time;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.time.EchoOperator;
import com.google.inject.Inject;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.Echo", category="ch.kuramo.javie.api.effectCategory.time")
public class Echo {
    @Property(value="-0.0333")
    private IAnimatableDouble echoTime;
    @Property(value="1", min="0")
    private IAnimatableInteger numberOfEchoes;
    @Property(value="1", min="0", max="1")
    private IAnimatableDouble startingIntensity;
    @Property(value="1", min="0")
    private IAnimatableDouble decay;
    @Property
    private IAnimatableEnum<EchoOperator> echoOperator;
    private final IVideoEffectContext context;
    private final IShaderRegistry shaders;
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] ADD = Echo.createProgramSource("add");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] MAXIMUM = Echo.createProgramSource("lighten");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] MINIMUM = Echo.createProgramSource("darken");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SCREEN = Echo.createProgramSource("screen");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] COMPOSITE = Echo.createProgramSource("normal");

    @Inject
    public Echo(IVideoEffectContext context, IShaderRegistry shaders) {
        this.context = context;
        this.shaders = shaders;
    }

    public VideoBounds getVideoBounds() {
        Time time = this.context.getTime();
        double echoTime = (Double)this.context.value((IAnimatableValue)this.echoTime);
        int numberOfEchoes = (Integer)this.context.value((IAnimatableValue)this.numberOfEchoes);
        VideoBounds bounds = null;
        int i = 0;
        while (i <= numberOfEchoes) {
            Time t = time.add(new Time(Math.round((double)i * echoTime * (double)time.timeScale), time.timeScale));
            this.context.setTime(t);
            VideoBounds b = this.context.getPreviousBounds();
            if (!b.isEmpty()) {
                if (bounds == null) {
                    bounds = b;
                } else {
                    double left = Math.min(b.x, bounds.x);
                    double top = Math.min(b.y, bounds.y);
                    double right = Math.max(b.x + (double)b.width, bounds.x + (double)bounds.width);
                    double bottom = Math.max(b.y + (double)b.height, bounds.y + (double)bounds.height);
                    bounds = new VideoBounds(left, top, (int)Math.ceil(right - left), (int)Math.ceil(bottom - top));
                }
            }
            ++i;
        }
        if (bounds == null) {
            bounds = new VideoBounds(0, 0);
        }
        return bounds;
    }

    public IVideoBuffer doVideoEffect() {
        Time time = this.context.getTime();
        double echoTime = (Double)this.context.value((IAnimatableValue)this.echoTime);
        int numberOfEchoes = (Integer)this.context.value((IAnimatableValue)this.numberOfEchoes);
        double startingIntensity = (Double)this.context.value((IAnimatableValue)this.startingIntensity);
        double decay = (Double)this.context.value((IAnimatableValue)this.decay);
        EchoOperator op = (EchoOperator)((Object)this.context.value(this.echoOperator));
        final IShaderProgram program = this.shaders.getProgram(Echo.class, op == EchoOperator.COMPOSITE_IN_BACK || op == EchoOperator.COMPOSITE_IN_FRONT ? "COMPOSITE" : op.name());
        IVideoBuffer vb1 = null;
        try {
            final GL2 gl = this.context.getGL().getGL2();
            GLU glu = this.context.getGLU();
            int i = 0;
            while (i <= numberOfEchoes) {
                int echoIndex = op == EchoOperator.COMPOSITE_IN_FRONT ? numberOfEchoes - i : i;
                final double intensity = Math.min(1.0, startingIntensity * Math.pow(decay, echoIndex));
                Time t = time.add(new Time(Math.round((double)echoIndex * echoTime * (double)time.timeScale), time.timeScale));
                this.context.setTime(t);
                IVideoBuffer vb2 = null;
                IVideoBuffer vb3 = null;
                try {
                    vb2 = this.context.doPreviousEffect();
                    if (vb2.getBounds().isEmpty()) {
                        vb3 = vb1;
                        vb1 = null;
                    } else {
                        if (vb1 == null) {
                            vb1 = this.context.createVideoBuffer(vb2.getBounds());
                            VideoEffectUtil.clearTexture(vb1, gl);
                        }
                        final VideoBounds b1 = vb1.getBounds();
                        final VideoBounds b2 = vb2.getBounds();
                        double left = Math.min(b1.x, b2.x);
                        double top = Math.min(b1.y, b2.y);
                        double right = Math.max(b1.x + (double)b1.width, b2.x + (double)b2.width);
                        double bottom = Math.max(b1.y + (double)b1.height, b2.y + (double)b2.height);
                        final VideoBounds bounds = new VideoBounds(left, top, (int)Math.ceil(right - left), (int)Math.ceil(bottom - top));
                        vb3 = this.context.createVideoBuffer(bounds);
                        VideoEffectUtil.clearTexture(vb3, gl);
                        VideoEffectUtil.ortho2D(gl, glu, bounds.width, bounds.height);
                        gl.glFramebufferTexture2D(36160, 36064, 34037, vb3.getTexture(), 0);
                        gl.glDrawBuffer(36064);
                        gl.glActiveTexture(33984);
                        gl.glBindTexture(34037, vb1.getTexture());
                        gl.glActiveTexture(33985);
                        gl.glBindTexture(34037, vb2.getTexture());
                        program.useProgram(new Runnable(){

                            public void run() {
                                gl.glUniform1i(program.getUniformLocation("texDst"), 0);
                                gl.glUniform1i(program.getUniformLocation("texSrc"), 1);
                                gl.glUniform1f(program.getUniformLocation("intensity"), (float)intensity);
                                gl.glBegin(7);
                                gl.glMultiTexCoord2f(33984, (float)(bounds.x - b1.x), (float)(bounds.y - b1.y));
                                gl.glMultiTexCoord2f(33985, (float)(bounds.x - b2.x), (float)(bounds.y - b2.y));
                                gl.glVertex2f(0.0f, 0.0f);
                                gl.glMultiTexCoord2f(33984, (float)(bounds.x - b1.x + (double)bounds.width), (float)(bounds.y - b1.y));
                                gl.glMultiTexCoord2f(33985, (float)(bounds.x - b2.x + (double)bounds.width), (float)(bounds.y - b2.y));
                                gl.glVertex2f((float)bounds.width, 0.0f);
                                gl.glMultiTexCoord2f(33984, (float)(bounds.x - b1.x + (double)bounds.width), (float)(bounds.y - b1.y + (double)bounds.height));
                                gl.glMultiTexCoord2f(33985, (float)(bounds.x - b2.x + (double)bounds.width), (float)(bounds.y - b2.y + (double)bounds.height));
                                gl.glVertex2f((float)bounds.width, (float)bounds.height);
                                gl.glMultiTexCoord2f(33984, (float)(bounds.x - b1.x), (float)(bounds.y - b1.y + (double)bounds.height));
                                gl.glMultiTexCoord2f(33985, (float)(bounds.x - b2.x), (float)(bounds.y - b2.y + (double)bounds.height));
                                gl.glVertex2f(0.0f, (float)bounds.height);
                                gl.glEnd();
                            }
                        });
                        gl.glActiveTexture(33985);
                        gl.glBindTexture(34037, 0);
                        gl.glActiveTexture(33984);
                        gl.glBindTexture(34037, 0);
                        gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
                    }
                }
                finally {
                    if (vb1 != null) {
                        vb1.dispose();
                        vb1 = null;
                    }
                    if (vb2 != null) {
                        vb2.dispose();
                        vb2 = null;
                    }
                    vb1 = vb3;
                    vb3 = null;
                }
                ++i;
            }
            if (vb1 == null) {
                IVideoBuffer iVideoBuffer = this.context.createVideoBuffer(new VideoBounds(0, 0));
                return iVideoBuffer;
            }
            VideoEffectUtil.premultiply(vb1, gl, glu);
            IVideoBuffer result = vb1;
            vb1 = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (vb1 != null) {
                vb1.dispose();
            }
        }
    }

    private static final String[] createProgramSource(String name) {
        return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float intensity;", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float intensity);", name), "", "void main(void)", "{", "\tvec4 dst = texture2DRect(texDst, gl_TexCoord[0].st);", "\tvec4 src = texture2DRect(texSrc, gl_TexCoord[1].st);", String.format("\tdst = blend_%s(vec4(dst.rgb*dst.a, dst.a), src, intensity);", name), "\tgl_FragColor = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "}"};
    }
}

