/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.transition;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.effects.VideoEffectUtil;
import ch.kuramo.javie.effects.blurSharpen.BlurUtil;
import com.google.inject.Inject;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

@Effect(id="ch.kuramo.javie.RadialWipe", category="ch.kuramo.javie.api.effectCategory.transition")
public class RadialWipe {
    private final IVideoEffectContext context;
    private final IArrayPools arrayPools;
    private final IShaderRegistry shaders;
    @Property(min="0", max="100")
    private IAnimatableDouble transitionCompletion;
    @Property(value="0")
    private IAnimatableDouble startAngle;
    @Property
    private IAnimatableVec2d wipeCenter;
    @Property
    private IAnimatableEnum<TypeOfRadialWipe> typeOfWipe;
    @Property(min="0", max="500")
    private IAnimatableDouble feather;

    @Inject
    public RadialWipe(IVideoEffectContext context, IArrayPools arrayPools, IShaderRegistry shaders) {
        this.context = context;
        this.arrayPools = arrayPools;
        this.shaders = shaders;
    }

    public IVideoBuffer doVideoEffect() {
        double completion = (Double)this.context.value((IAnimatableValue)this.transitionCompletion) / 100.0;
        if (completion == 0.0) {
            return null;
        }
        if (completion == 1.0) {
            IVideoBuffer vb = this.context.doPreviousEffect();
            VideoEffectUtil.clearTexture(vb, this.context.getGL().getGL2());
            return vb;
        }
        double startAngle = (Double)this.context.value((IAnimatableValue)this.startAngle);
        Vec2d wipeCenter = (Vec2d)this.context.value((IAnimatableValue)this.wipeCenter);
        TypeOfRadialWipe typeOfWipe = (TypeOfRadialWipe)((Object)this.context.value(this.typeOfWipe));
        double feather = (Double)this.context.value((IAnimatableValue)this.feather);
        RenderResolution resolution = this.context.getRenderResolution();
        wipeCenter = resolution.scale(wipeCenter);
        feather = resolution.scale(feather);
        switch (typeOfWipe) {
            case COUNTERCLOCKWISE: {
                startAngle -= 360.0 * completion;
                break;
            }
            case BOTH: {
                startAngle -= 180.0 * completion;
            }
        }
        startAngle %= 360.0;
        if (startAngle < 0.0) {
            startAngle += 360.0;
        }
        double endAngle = startAngle + 360.0 * completion;
        IVideoBuffer inputBuffer = null;
        IVideoBuffer wipeBuffer = null;
        try {
            inputBuffer = this.context.doPreviousEffect();
            VideoBounds inputBounds = inputBuffer.getBounds();
            if (inputBounds.isEmpty()) {
                IVideoBuffer result = inputBuffer;
                inputBuffer = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            int wipeBoundsExpand = (int)Math.ceil(feather);
            VideoBounds wipeBounds = VideoEffectUtil.expandBounds(inputBounds, wipeBoundsExpand, true, true);
            wipeCenter = new Vec2d(wipeCenter.x - wipeBounds.x, wipeCenter.y - wipeBounds.y);
            GL2 gl = this.context.getGL().getGL2();
            GLU glu = this.context.getGLU();
            wipeBuffer = this.createWipeBuffer(wipeBounds, wipeCenter, feather, startAngle, endAngle, gl, glu);
            int w = inputBounds.width;
            int h = inputBounds.height;
            VideoEffectUtil.ortho2D(gl, glu, w, h);
            gl.glFramebufferTexture2D(36160, 36064, 34037, inputBuffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(34037, wipeBuffer.getTexture());
            gl.glEnable(34037);
            gl.glEnable(3042);
            gl.glBlendFuncSeparate(0, 770, 0, 770);
            gl.glBegin(7);
            gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            gl.glTexCoord2f((float)wipeBoundsExpand, (float)wipeBoundsExpand);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord2f((float)(wipeBoundsExpand + w), (float)wipeBoundsExpand);
            gl.glVertex2f((float)w, 0.0f);
            gl.glTexCoord2f((float)(wipeBoundsExpand + w), (float)(wipeBoundsExpand + h));
            gl.glVertex2f((float)w, (float)h);
            gl.glTexCoord2f((float)wipeBoundsExpand, (float)(wipeBoundsExpand + h));
            gl.glVertex2f(0.0f, (float)h);
            gl.glEnd();
            gl.glDisable(3042);
            gl.glDisable(34037);
            gl.glBindTexture(34037, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            IVideoBuffer result = inputBuffer;
            inputBuffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (wipeBuffer != null) {
                wipeBuffer.dispose();
            }
            if (inputBuffer != null) {
                inputBuffer.dispose();
            }
        }
    }

    private IVideoBuffer createWipeBuffer(VideoBounds wipeBounds, Vec2d wipeCenter, double feather, double startAngle, double endAngle, GL2 gl, GLU glu) {
        IVideoBuffer wipeBuffer = null;
        int[] wipeTex = null;
        try {
            wipeBuffer = this.context.createVideoBuffer(wipeBounds);
            gl.glFramebufferTexture2D(36160, 36064, 34037, wipeBuffer.getTexture(), 0);
            gl.glDrawBuffer(36064);
            wipeTex = new int[1];
            gl.glGenTextures(1, wipeTex, 0);
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, wipeTex[0]);
            gl.glTexParameteri(3552, 10241, 9729);
            gl.glTexParameteri(3552, 10240, 9729);
            gl.glTexParameteri(3552, 10242, 33071);
            gl.glTexParameteri(3552, 10243, 33071);
            gl.glEnable(3552);
            this.drawWipe(wipeBounds, wipeCenter, feather, startAngle, endAngle, false, gl, glu);
            gl.glPushAttrib(24576);
            gl.glEnable(3042);
            gl.glBlendFunc(1, 1);
            gl.glBlendEquation(endAngle - startAngle < 180.0 ? 32776 : 32775);
            this.drawWipe(wipeBounds, wipeCenter, feather, startAngle, endAngle, true, gl, glu);
            gl.glPopAttrib();
            gl.glDisable(3552);
            gl.glActiveTexture(33984);
            gl.glBindTexture(3552, 0);
            gl.glFramebufferTexture2D(36160, 36064, 34037, 0, 0);
            if (feather == 0.0) {
                IVideoBuffer result = wipeBuffer;
                wipeBuffer = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            IVideoBuffer iVideoBuffer = this.blur(wipeBuffer, feather, gl, glu);
            return iVideoBuffer;
        }
        finally {
            if (wipeTex != null) {
                gl.glDeleteTextures(1, wipeTex, 0);
            }
            if (wipeBuffer != null) {
                wipeBuffer.dispose();
            }
        }
    }

    private void drawWipe(VideoBounds wipeBounds, Vec2d wipeCenter, double feather, double startAngle, double endAngle, boolean secondPath, GL2 gl, GLU glu) {
        double y0;
        double x0;
        int w = wipeBounds.width;
        int h = wipeBounds.height;
        double angle = secondPath ? endAngle : startAngle;
        double radian = Math.toRadians(angle);
        double wipeLen = (double)w * Math.abs(Math.cos(radian)) + (double)h * Math.abs(Math.sin(radian));
        double wipeWidth = (double)h * Math.abs(Math.cos(radian)) + (double)w * Math.abs(Math.sin(radian));
        switch ((int)angle / 90 % 4) {
            case 0: {
                x0 = 0.0;
                y0 = 0.0;
                break;
            }
            case 1: {
                x0 = w;
                y0 = 0.0;
                break;
            }
            case 2: {
                x0 = w;
                y0 = h;
                break;
            }
            case 3: {
                x0 = 0.0;
                y0 = h;
                break;
            }
            default: {
                throw new Error();
            }
        }
        double sig = -Math.signum(Math.cos(radian));
        if (sig == 0.0) {
            sig = 1.0;
        }
        double tan = Math.tan(radian);
        double d = sig * (x0 + tan * y0 - wipeCenter.x - tan * wipeCenter.y) / Math.sqrt(1.0 + tan * tan);
        if (secondPath) {
            double angleDiff = endAngle - startAngle;
            if (angleDiff < 5.0) {
                d -= 2.0 * (1.0 - angleDiff / 5.0);
            } else if (angleDiff > 355.0) {
                d += 2.0 * (1.0 - (360.0 - angleDiff) / 5.0);
            }
        }
        IArray wipeArray = this.arrayPools.getFloatArray((int)Math.ceil(wipeLen + 2.0 * feather));
        try {
            float[] array = (float[])wipeArray.getArray();
            int arrayLen = wipeArray.getLength();
            double border = Math.min(Math.max(feather + d, 0.0), (double)arrayLen);
            int borderInt = (int)border;
            Arrays.fill(array, 0, borderInt, (float)(!secondPath ? 1 : 0));
            if (borderInt < arrayLen) {
                array[borderInt] = (float)(secondPath ? 1.0 - (border - (double)borderInt) : border - (double)borderInt);
            }
            if (borderInt + 1 < arrayLen) {
                Arrays.fill(array, borderInt + 1, arrayLen, (float)(secondPath ? 1 : 0));
            }
            FloatBuffer buffer = FloatBuffer.wrap(array, 0, arrayLen);
            switch (this.context.getColorMode()) {
                case RGBA8: {
                    gl.glTexImage1D(3552, 0, 32828, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16: {
                    gl.glTexImage1D(3552, 0, 32830, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA16_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34844, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                case RGBA32_FLOAT: {
                    gl.glTexImage1D(3552, 0, 34838, arrayLen, 0, 6406, 5126, (Buffer)buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown ColorMode: " + this.context.getColorMode());
                }
            }
            VideoEffectUtil.ortho2D(gl, glu, w, h);
            gl.glMatrixMode(5888);
            gl.glTranslatef((float)w / 2.0f, (float)h / 2.0f, 0.0f);
            gl.glRotatef((float)(angle + 90.0), 0.0f, 0.0f, 1.0f);
            gl.glScalef((float)(wipeWidth / (double)w), (float)((wipeLen + 2.0 * feather) / (double)h), 1.0f);
            gl.glTranslatef((float)(-w) / 2.0f, (float)(-h) / 2.0f, 0.0f);
            float texCoord = (float)((wipeLen + 2.0 * feather) / (double)arrayLen);
            gl.glBegin(7);
            gl.glTexCoord1f(texCoord);
            gl.glVertex2f(0.0f, 0.0f);
            gl.glTexCoord1f(texCoord);
            gl.glVertex2f((float)w, 0.0f);
            gl.glTexCoord1f(0.0f);
            gl.glVertex2f((float)w, (float)h);
            gl.glTexCoord1f(0.0f);
            gl.glVertex2f(0.0f, (float)h);
            gl.glEnd();
        }
        finally {
            wipeArray.release();
        }
    }

    private IVideoBuffer blur(IVideoBuffer input, double blur, GL2 gl, GLU glu) {
        return this.blur(input, blur, true, true, true, true, gl, glu);
    }

    private IVideoBuffer blur(IVideoBuffer input, double blur, boolean repeatEdgePixels, boolean horz, boolean vert, boolean fast, GL2 gl, GLU glu) {
        VideoBounds inputBounds = input.getBounds();
        int sampleRatio = 1;
        if (fast) {
            VideoBounds bounds = inputBounds;
            int[] nArray = BlurUtil.getDownSampleFactors(blur);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int factor = nArray[n2];
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                }
                int hFactor = horz ? factor : 1;
                int vFactor = vert ? factor : 1;
                bounds = new VideoBounds(bounds.x / (double)hFactor, bounds.y / (double)vFactor, (bounds.width + hFactor - 1) / hFactor, (bounds.height + vFactor - 1) / vFactor);
                IVideoBuffer buf = this.context.createVideoBuffer(bounds);
                BlurUtil.doDownSample(input, buf, hFactor, vFactor, gl, glu, this.shaders);
                input.dispose();
                input = buf;
                sampleRatio *= factor;
                ++n2;
            }
            blur /= (double)sampleRatio;
        }
        int radius = (int)Math.ceil(blur);
        double sigma = blur / 2.5;
        double sigmaSquare = sigma * sigma;
        float[] kernel = new float[radius * 2 + 1];
        float sum = 0.0f;
        int i = 1;
        while (i <= radius) {
            float f = (float)Math.exp((double)(-i * i) / (2.0 * sigmaSquare));
            kernel[radius - i] = f;
            sum += 2.0f * f;
            ++i;
        }
        kernel[radius] = 1.0f / (sum += 1.0f);
        i = 1;
        while (i <= radius) {
            int n = radius - i;
            float f = kernel[n] / sum;
            kernel[n] = f;
            kernel[radius + i] = f;
            ++i;
        }
        IVideoBuffer buf1 = null;
        IVideoBuffer buf2 = null;
        IVideoBuffer buf3 = null;
        try {
            VideoBounds bounds;
            if (horz) {
                bounds = input.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(input, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, true, false);
                }
                buf1 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(input, buf1, true, radius, kernel, gl, glu, this.shaders);
            } else {
                buf1 = input;
                input = null;
            }
            if (vert) {
                bounds = buf1.getBounds();
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf1, gl);
                } else {
                    bounds = VideoEffectUtil.expandBounds(bounds, radius, false, true);
                }
                buf2 = this.context.createVideoBuffer(bounds);
                VideoEffectUtil.convolution1D(buf1, buf2, false, radius, kernel, gl, glu, this.shaders);
            } else {
                buf2 = buf1;
                buf1 = null;
            }
            if (sampleRatio != 1) {
                VideoBounds bounds2;
                int vRatio;
                int hRatio = horz ? sampleRatio : 1;
                int n = vRatio = vert ? sampleRatio : 1;
                if (repeatEdgePixels) {
                    VideoEffectUtil.setClampToEdge(buf2, gl);
                    bounds2 = inputBounds;
                } else {
                    bounds2 = buf2.getBounds();
                    bounds2 = new VideoBounds(bounds2.x * (double)hRatio, bounds2.y * (double)vRatio, bounds2.width * hRatio, bounds2.height * vRatio);
                }
                buf3 = this.context.createVideoBuffer(bounds2);
                BlurUtil.doUpSample(buf2, buf3, hRatio, vRatio, gl, glu);
            } else {
                buf3 = buf2;
                buf2 = null;
            }
            IVideoBuffer iVideoBuffer = buf3;
            return iVideoBuffer;
        }
        finally {
            if (input != null) {
                input.dispose();
            }
            if (buf1 != null) {
                buf1.dispose();
            }
            if (buf2 != null) {
                buf2.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeOfRadialWipe {
        CLOCKWISE,
        COUNTERCLOCKWISE,
        BOTH;

    }
}

