/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUDetailsGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionStatusPage;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public abstract class ResolutionResultsWizardPage
extends ResolutionStatusPage {
    private static final String DIALOG_SETTINGS_SECTION = "ResolutionResultsPage";
    protected IUElementListRoot input;
    PlannerResolutionOperation resolvedOperation;
    protected Policy policy;
    TreeViewer treeViewer;
    ProvElementContentProvider contentProvider;
    IUDetailsLabelProvider labelProvider;
    protected Display display;
    private IUDetailsGroup iuDetailsGroup;
    SashForm sashForm;

    protected ResolutionResultsWizardPage(Policy policy, IUElementListRoot input, String profileID, PlannerResolutionOperation resolvedOperation) {
        super("ResolutionPage", profileID);
        this.policy = policy;
        Assert.isNotNull((Object)resolvedOperation);
        this.resolvedOperation = resolvedOperation;
        this.input = input == null ? new IUElementListRoot() : input;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        this.sashForm = new SashForm(parent, 512);
        FillLayout layout = new FillLayout();
        this.sashForm.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        this.initializeDialogUnits((Control)this.sashForm);
        Composite composite = new Composite((Composite)this.sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.treeViewer = this.createTreeViewer(composite);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(true);
        this.activateCopy((Control)tree);
        IUColumnConfig[] columns = this.getColumnConfig();
        int i = 0;
        while (i < columns.length) {
            TreeColumn tc = new TreeColumn(tree, 16384, i);
            tc.setResizable(true);
            tc.setText(columns[i].columnTitle);
            tc.setWidth(columns[i].getWidth());
            ++i;
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResolutionResultsWizardPage.this.setDetailText(ResolutionResultsWizardPage.this.resolvedOperation);
            }
        });
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(this.getColumnConfig());
        this.treeViewer.setComparator((ViewerComparator)comparator);
        this.treeViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.contentProvider = new ProvElementContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new IUDetailsLabelProvider(null, this.getColumnConfig(), this.getShell());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.setDrilldownElements(this.input, this.resolvedOperation.getProvisioningPlan());
        this.treeViewer.setInput((Object)this.input);
        this.createSizingInfo(composite);
        this.iuDetailsGroup = new IUDetailsGroup((Composite)this.sashForm, (ISelectionProvider)this.treeViewer, this.convertWidthInCharsToPixels(80), true);
        this.updateStatus(this.input, this.resolvedOperation);
        this.setControl((Control)this.sashForm);
        this.sashForm.setWeights(this.getSashWeights());
        Dialog.applyDialogFont((Control)this.sashForm);
    }

    protected void createSizingInfo(Composite parent) {
    }

    public boolean performFinish() {
        if (this.resolvedOperation.getResolutionResult().getSummaryStatus().getSeverity() != 4) {
            ProfileModificationOperation op = this.createProfileModificationOperation(this.resolvedOperation);
            ProvisioningOperationRunner.schedule(op, 3);
            return true;
        }
        return false;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public ProvisioningPlan getCurrentPlan() {
        return this.resolvedOperation.getProvisioningPlan();
    }

    protected Object[] getSelectedElements() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toArray();
    }

    protected IInstallableUnit getSelectedIU() {
        IInstallableUnit[] units = ElementUtils.elementsToIUs(this.getSelectedElements());
        if (units.length == 0) {
            return null;
        }
        return units[0];
    }

    protected String getProfileId() {
        return this.profileId;
    }

    protected IInstallableUnit[] getIUs() {
        return ElementUtils.elementsToIUs(this.input.getChildren(this.input));
    }

    void setDrilldownElements(IUElementListRoot root, ProvisioningPlan plan) {
        if (plan == null) {
            return;
        }
        Object[] elements = root.getChildren(root);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof QueriedElement) {
                ((QueriedElement)elements[i]).setQueryable(this.getQueryable(plan));
            }
            ++i;
        }
    }

    private ProfileModificationOperation createProfileModificationOperation(PlannerResolutionOperation op) {
        return new ProfileModificationOperation(this.getOperationLabel(), this.profileId, op.getProvisioningPlan(), op.getProvisioningContext());
    }

    protected abstract String getOperationLabel();

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 67586);
    }

    protected abstract IQueryable getQueryable(ProvisioningPlan var1);

    protected String getClipboardText(Control control) {
        return CopyUtils.getIndentedClipboardText(this.getSelectedElements(), this.labelProvider);
    }

    protected IUDetailsGroup getDetailsGroup() {
        return this.iuDetailsGroup;
    }

    protected boolean isCreated() {
        return this.treeViewer != null;
    }

    protected void updateCaches(IUElementListRoot newRoot, PlannerResolutionOperation op) {
        this.resolvedOperation = op;
        this.setDrilldownElements(newRoot, this.resolvedOperation.getProvisioningPlan());
        if (this.treeViewer != null) {
            if (this.input != newRoot) {
                this.treeViewer.setInput((Object)newRoot);
            } else {
                this.treeViewer.refresh();
            }
        }
        this.input = newRoot;
    }

    protected String getDialogSettingsName() {
        return String.valueOf(this.getWizard().getClass().getName()) + "." + DIALOG_SETTINGS_SECTION;
    }

    protected int getColumnWidth(int index) {
        return this.treeViewer.getTree().getColumn(index).getWidth();
    }

    protected SashForm getSashForm() {
        return this.sashForm;
    }
}

