/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.swt.widgets.Shell;

public class ElementUtils {
    static /* synthetic */ Class class$0;

    public static void updateRepositoryUsingElements(final MetadataRepositoryElement[] elements, Shell shell) {
        Job job = new Job(ProvUIMessages.ElementUtils_UpdateJobTitle){

            public IStatus run(IProgressMonitor monitor) {
                ProvUI.startBatchOperation();
                try {
                    try {
                        int visibilityFlags = Policy.getDefault().getQueryContext().getMetadataRepositoryFlags();
                        URI[] currentlyEnabled = ProvisioningUtil.getMetadataRepositories(visibilityFlags);
                        URI[] currentlyDisabled = ProvisioningUtil.getMetadataRepositories(8 | visibilityFlags);
                        int i = 0;
                        while (i < elements.length) {
                            URI location = elements[i].getLocation();
                            if (elements[i].isEnabled()) {
                                if (ElementUtils.containsURI(currentlyDisabled, location)) {
                                    ProvisioningUtil.setColocatedRepositoryEnablement(location, true);
                                } else if (!ElementUtils.containsURI(currentlyEnabled, location)) {
                                    ProvisioningUtil.addMetadataRepository(location, false);
                                    ProvisioningUtil.addArtifactRepository(location, false);
                                }
                            } else if (ElementUtils.containsURI(currentlyEnabled, location)) {
                                ProvisioningUtil.setColocatedRepositoryEnablement(location, false);
                            } else if (!ElementUtils.containsURI(currentlyDisabled, location)) {
                                ProvisioningUtil.addMetadataRepository(location, false);
                                ProvisioningUtil.addArtifactRepository(location, false);
                                ProvisioningUtil.setColocatedRepositoryEnablement(location, false);
                            }
                            String name = elements[i].getName();
                            if (name != null && name.length() > 0) {
                                ProvisioningUtil.setMetadataRepositoryProperty(location, "p2.nickname", name);
                                ProvisioningUtil.setArtifactRepositoryProperty(location, "p2.nickname", name);
                            }
                            ++i;
                        }
                        HashSet<String> nowKnown = new HashSet<String>();
                        int i2 = 0;
                        while (i2 < elements.length) {
                            nowKnown.add(URIUtil.toUnencodedString((URI)elements[i2].getLocation()));
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < currentlyEnabled.length) {
                            if (!nowKnown.contains(URIUtil.toUnencodedString((URI)currentlyEnabled[i2]))) {
                                ProvisioningUtil.removeMetadataRepository(currentlyEnabled[i2]);
                                ProvisioningUtil.removeArtifactRepository(currentlyEnabled[i2]);
                            }
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < currentlyDisabled.length) {
                            if (!nowKnown.contains(URIUtil.toUnencodedString((URI)currentlyDisabled[i2]))) {
                                ProvisioningUtil.removeMetadataRepository(currentlyDisabled[i2]);
                                ProvisioningUtil.removeArtifactRepository(currentlyDisabled[i2]);
                            }
                            ++i2;
                        }
                    }
                    catch (ProvisionException e) {
                        IStatus iStatus = e.getStatus();
                        ProvUI.endBatchOperation(true);
                        return iStatus;
                    }
                }
                finally {
                    ProvUI.endBatchOperation(true);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static IInstallableUnit getIU(Object element) {
        if (element instanceof IInstallableUnit) {
            return (IInstallableUnit)element;
        }
        if (element instanceof IIUElement) {
            return ((IIUElement)element).getIU();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit)ProvUI.getAdapter(element, clazz);
    }

    public static IInstallableUnit[] elementsToIUs(Object[] elements) {
        ArrayList<IInstallableUnit> theIUs = new ArrayList<IInstallableUnit>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IInstallableUnit iu;
            Object object = elements[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iu = (IInstallableUnit)ProvUI.getAdapter(object, clazz)) != null) {
                theIUs.add(iu);
            }
            ++i;
        }
        return theIUs.toArray(new IInstallableUnit[theIUs.size()]);
    }

    static boolean containsURI(URI[] locations, URI url) {
        int i = 0;
        while (i < locations.length) {
            if (locations[i].equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

