/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.internal.repository.tools.Activator;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryUtilities;
import org.eclipse.osgi.util.NLS;

public class RecreateRepositoryApplication {
    private static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private RepositoryDescriptor descriptor;
    private String repoName = null;
    boolean removeArtifactRepo = true;
    private Map repoProperties = null;
    private Map repoMap = null;

    public IStatus run(IProgressMonitor monitor) throws ProvisionException, IOException {
        try {
            IArtifactRepository repository = this.initialize(monitor);
            this.removeRepository(repository, monitor);
            this.recreateRepository(monitor);
        }
        finally {
            if (this.removeArtifactRepo) {
                IArtifactRepositoryManager repositoryManager = Activator.getArtifactRepositoryManager();
                repositoryManager.removeRepository(this.descriptor.getRepoLocation());
            }
        }
        return Status.OK_STATUS;
    }

    public void setArtifactRepository(RepositoryDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    private IArtifactRepository initialize(IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager repositoryManager = Activator.getArtifactRepositoryManager();
        this.removeArtifactRepo = !repositoryManager.contains(this.descriptor.getRepoLocation());
        IArtifactRepository repository = repositoryManager.loadRepository(this.descriptor.getRepoLocation(), 1, monitor);
        if (repository == null || !repository.isModifiable()) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_destinationNotModifiable, (Object)repository.getLocation()));
        }
        if (!(repository instanceof IFileArtifactRepository)) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_notLocalFileRepo, (Object)repository.getLocation()));
        }
        this.repoName = repository.getName();
        this.repoProperties = repository.getProperties();
        this.repoMap = new HashMap();
        IArtifactKey[] keys = repository.getArtifactKeys();
        int i = 0;
        while (i < keys.length) {
            IArtifactDescriptor[] descriptors = repository.getArtifactDescriptors(keys[i]);
            this.repoMap.put(keys[i], descriptors);
            ++i;
        }
        return repository;
    }

    private void removeRepository(IArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException, IOException {
        IArtifactRepositoryManager manager = Activator.getArtifactRepositoryManager();
        manager.removeRepository(repository.getLocation());
        boolean compressed = Boolean.valueOf((String)this.repoProperties.get("p2.compressed"));
        URI realLocation = SimpleArtifactRepository.getActualLocation((URI)repository.getLocation(), (boolean)compressed);
        File realFile = URIUtil.toFile((URI)realLocation);
        if (!realFile.exists() || !realFile.delete()) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_unableToRemoveRepo, (Object)realFile.toString()));
        }
    }

    private void recreateRepository(IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager = Activator.getArtifactRepositoryManager();
        HashMap<String, String> newProperties = new HashMap<String, String>(this.repoProperties);
        newProperties.put(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
        IArtifactRepository repository = manager.createRepository(this.descriptor.getRepoLocation(), this.repoName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", newProperties);
        if (!(repository instanceof IFileArtifactRepository)) {
            throw new ProvisionException(NLS.bind((String)Messages.exception_notLocalFileRepo, (Object)repository.getLocation()));
        }
        IFileArtifactRepository simple = (IFileArtifactRepository)repository;
        Iterator iterator = this.repoMap.keySet().iterator();
        while (iterator.hasNext()) {
            IArtifactKey key = (IArtifactKey)iterator.next();
            IArtifactDescriptor[] descriptors = (IArtifactDescriptor[])this.repoMap.get(key);
            String unpackedSize = null;
            File packFile = null;
            HashSet<File> files = new HashSet<File>();
            int i = 0;
            while (i < descriptors.length) {
                File temp;
                File artifactFile = simple.getArtifactFile(descriptors[i]);
                files.add(artifactFile);
                String size = Long.toString(artifactFile.length());
                ArtifactDescriptor newDescriptor = new ArtifactDescriptor(descriptors[i]);
                newDescriptor.setProperty("artifact.size", size);
                newDescriptor.setProperty("download.size", size);
                if (newDescriptor.getProperties().containsKey("download.md5")) {
                    newDescriptor.setProperty("download.md5", RepositoryUtilities.computeMD5(artifactFile));
                }
                if ((temp = new File(artifactFile.getParentFile(), String.valueOf(artifactFile.getName()) + ".pack.gz")).exists()) {
                    packFile = temp;
                    unpackedSize = size;
                }
                repository.addDescriptor((IArtifactDescriptor)newDescriptor);
                ++i;
            }
            if (packFile == null || files.contains(packFile)) continue;
            ArtifactDescriptor packDescriptor = this.createPack200ArtifactDescriptor(key, packFile, unpackedSize);
            repository.addDescriptor((IArtifactDescriptor)packDescriptor);
        }
    }

    private ArtifactDescriptor createPack200ArtifactDescriptor(IArtifactKey key, File packFile, String installSize) {
        if (packFile != null && packFile.exists()) {
            ArtifactDescriptor result = new ArtifactDescriptor(key);
            result.setProperty("artifact.size", installSize);
            result.setProperty("download.size", Long.toString(packFile.length()));
            ProcessingStepDescriptor[] steps = new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
            result.setProcessingSteps(steps);
            result.setProperty("format", "packed");
            return result;
        }
        return null;
    }
}

