/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.ColocatedRepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IUViewQueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.PlanValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.RepositoryManipulator;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class SDKPolicy
extends Policy {
    public SDKPolicy() {
        this.setProfileChooser(new IProfileChooser(){

            public String getProfileId(Shell shell) {
                try {
                    return ProvSDKUIActivator.getSelfProfileId();
                }
                catch (ProvisionException e) {
                    ProvUI.handleException((Throwable)e, (String)e.getStatus().getMessage(), (int)1);
                    return null;
                }
            }
        });
        this.setRepositoryManipulator((RepositoryManipulator)new ColocatedRepositoryManipulator(this, "org.eclipse.equinox.internal.p2.ui.sdk.SitesPreferencePage"){

            public String getManipulatorLinkLabel() {
                return ProvSDKMessages.ProvSDKUIActivator_SitePrefLink;
            }
        });
        this.setPlanValidator(new PlanValidator(){

            public boolean continueWorkingWithPlan(ProvisioningPlan plan, Shell shell) {
                if (plan == null) {
                    return false;
                }
                if (plan.getStatus().getSeverity() == 8) {
                    return false;
                }
                if (plan.getStatus().getCode() == 10000) {
                    ProvUI.reportStatus((IStatus)plan.getStatus(), (int)4);
                    return false;
                }
                if (plan.getStatus().getSeverity() != 4) {
                    return true;
                }
                IPreferenceStore prefs = ProvSDKUIActivator.getDefault().getPreferenceStore();
                String openPlan = prefs.getString("allowNonOKPlan");
                if ("always".equals(openPlan)) {
                    return true;
                }
                if ("never".equals(openPlan)) {
                    ProvUI.reportStatus((IStatus)plan.getStatus(), (int)3);
                    return false;
                }
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)ProvSDKMessages.ProvSDKUIActivator_Question, (String)ProvSDKMessages.ProvSDKUIActivator_OpenWizardAnyway, null, (boolean)false, (IPreferenceStore)prefs, (String)"allowNonOKPlan");
                if (dialog.getReturnCode() == 3) {
                    ProvUI.reportStatus((IStatus)plan.getStatus(), (int)3);
                }
                return dialog.getReturnCode() == 2;
            }
        });
        IUViewQueryContext queryContext = new IUViewQueryContext(1);
        this.setQueryContext(queryContext);
        ProvSDKUIActivator.getDefault().updateWithPreferences(queryContext);
    }

    public IStatus getNoProfileChosenStatus() {
        return ProvSDKUIActivator.getNoSelfProfileStatus();
    }
}

