/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class KeyframeInterpolationAction
extends Action {
    private final TreeViewer viewer;
    private final Interpolation newInterpolation;

    public KeyframeInterpolationAction(TreeViewer treeViewer, Interpolation interpolation) {
        super(interpolation.label());
        this.viewer = treeViewer;
        this.newInterpolation = interpolation;
        this.setEnabled(false);
        this.setChecked(false);
        Tree tree = treeViewer.getTree();
        final TreeColumn[] columns = tree.getColumns();
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TimelineManager tm;
                Map<Keyframe<?>, AnimatableValueElement> selection;
                boolean enabled = false;
                boolean checked = false;
                int left = 0;
                int i = 0;
                while (i < columns.length - 1) {
                    left += columns[i].getWidth();
                    ++i;
                }
                if (left <= e.x && e.x < left + columns[columns.length - 1].getWidth() && (selection = (tm = (TimelineManager)KeyframeInterpolationAction.this.viewer.getData("TIMELINE_MANAGER")).getKeyframeSelection()).size() > 0) {
                    enabled = true;
                    checked = true;
                    for (Map.Entry<Keyframe<?>, AnimatableValueElement> entry : selection.entrySet()) {
                        AnimatableValueElement avElem = entry.getValue();
                        AnimatableValue<?> avalue = avElem.getAnimatableValue();
                        enabled &= avalue.getAvailableInterpolations().contains(KeyframeInterpolationAction.this.newInterpolation);
                        checked &= entry.getKey().interpolation == KeyframeInterpolationAction.this.newInterpolation;
                    }
                }
                KeyframeInterpolationAction.this.setEnabled(enabled);
                KeyframeInterpolationAction.this.setChecked(checked);
            }
        });
    }

    public void run() {
        TimelineManager tm = (TimelineManager)this.viewer.getData("TIMELINE_MANAGER");
        tm.modifySelectedKeyframeInterpolation(this.newInterpolation);
    }
}

