/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.DisableTimeRemapOperation;
import ch.kuramo.javie.app.project.ModifyLayerKeyframesOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchWindow;

public class TimeRemapAction
extends Action {
    private final IWorkbenchWindow window;
    private final TreeViewer viewer;

    public TimeRemapAction(IWorkbenchWindow window, TreeViewer viewer) {
        super("\u30bf\u30a4\u30e0\u30ea\u30de\u30c3\u30d7");
        this.window = window;
        this.viewer = viewer;
        this.setEnabled(false);
        this.setChecked(false);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = false;
                boolean checked = false;
                TreeSelection selection = (TreeSelection)event.getSelection();
                if (selection.size() == 1) {
                    Object element = selection.getFirstElement();
                    if (element instanceof LayerElement) {
                        Layer layer = ((LayerElement)element).layer;
                        enabled = LayerNature.isTimeRemapNature((Layer)layer);
                        checked = LayerNature.isTimeRemapEnabled((Layer)layer);
                    } else if (element instanceof LayerAnimatableValueElement) {
                        LayerAnimatableValueElement avalueElem = (LayerAnimatableValueElement)element;
                        enabled = checked = avalueElem.getProperty().equals("timeRemap");
                    }
                }
                TimeRemapAction.this.setEnabled(enabled);
                TimeRemapAction.this.setChecked(checked);
            }
        });
    }

    public void run() {
        LayerAnimatableValueElement avalueElem;
        TreeSelection selection = (TreeSelection)this.viewer.getSelection();
        Object element = selection.getFirstElement();
        Layer layer = null;
        if (element instanceof LayerElement) {
            layer = ((LayerElement)element).layer;
        } else if (element instanceof LayerAnimatableValueElement && (avalueElem = (LayerAnimatableValueElement)element).getProperty().equals("timeRemap")) {
            layer = ((LayerElement)avalueElem.parent).layer;
        }
        if (layer == null || !LayerNature.isTimeRemapNature((Layer)layer)) {
            return;
        }
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.window);
        if (LayerNature.isTimeRemapEnabled((Layer)layer)) {
            pm.postOperation(new DisableTimeRemapOperation(pm, (MediaLayer)layer));
        } else {
            Double[] doubleArray;
            Time[] timeArray;
            double rate = layer.getRate();
            Time duration = ((MediaLayer)layer).getMediaInput().getDuration();
            Time startTime = layer.getStartTime();
            Time endTime = startTime.add(new Time((long)((double)duration.timeValue / Math.abs(rate)), duration.timeScale));
            if (rate == 0.0) {
                Time[] timeArray2 = new Time[1];
                timeArray = timeArray2;
                timeArray2[0] = startTime;
            } else {
                Time[] timeArray3 = new Time[2];
                timeArray3[0] = startTime;
                timeArray = timeArray3;
                timeArray3[1] = endTime;
            }
            Time[] times = timeArray;
            if (rate == 0.0) {
                Double[] doubleArray2 = new Double[1];
                doubleArray = doubleArray2;
                doubleArray2[0] = 0.0;
            } else if (rate > 0.0) {
                Double[] doubleArray3 = new Double[2];
                doubleArray3[0] = 0.0;
                doubleArray = doubleArray3;
                doubleArray3[1] = duration.toSecond();
            } else {
                Double[] doubleArray4 = new Double[2];
                doubleArray4[0] = duration.toSecond();
                doubleArray = doubleArray4;
                doubleArray4[1] = 0.0;
            }
            Double[] values = doubleArray;
            pm.postOperation(new ModifyLayerKeyframesOperation<Double>(pm, layer, "timeRemap", times, values, "\u30bf\u30a4\u30e0\u30ea\u30de\u30c3\u30d7\u306e\u4f7f\u7528"));
        }
    }
}

