/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableVec2d;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.EffectRegistry;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddEffectsOperation
extends ProjectOperation {
    private final String _compId;
    private final List<Entry> _entries = Util.newList();
    @Inject
    private EffectRegistry _effectRegistry;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public AddEffectsOperation(ProjectManager projectManager, Map<EffectableLayer, Integer> effectIndices, EffectDescriptor ed) {
        super(projectManager, String.format("%s\u306e\u8ffd\u52a0", ed.getLabel()));
        InjectorHolder.getInjector().injectMembers((Object)this);
        if (effectIndices.isEmpty()) {
            this._noEffect = true;
            this._compId = null;
            return;
        }
        LayerComposition comp = projectManager.checkLayer((Layer)effectIndices.entrySet().iterator().next().getKey());
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        for (Map.Entry<EffectableLayer, Integer> e : effectIndices.entrySet()) {
            EffectableLayer layer = e.getKey();
            Integer effectIndex = e.getValue();
            if (projectManager.checkLayer((Layer)layer) != comp) {
                throw new IllegalArgumentException();
            }
            effectIndex = Math.max(0, Math.min(effectIndex, layer.getEffects().size()));
            Effect effect = this._effectRegistry.newEffect(ed.getType());
            this.centerProperties(effect, layer, (Composition)comp);
            String data = this._encoder.encodeElement((Object)effect);
            this._entries.add(new Entry(layer.getId(), data, effectIndex));
        }
    }

    private void centerProperties(Effect effect, EffectableLayer layer, Composition comp) {
        VideoBounds bounds;
        MediaInput input;
        Vec2d center = null;
        if (LayerNature.isCTCR((Layer)layer)) {
            Size2i size = comp.getSize();
            center = new Vec2d((double)size.width / 2.0, (double)size.height / 2.0);
        } else if (layer instanceof MediaLayer && (input = ((MediaLayer)layer).getMediaInput()) != null && (bounds = input.getVideoFrameBounds()) != null) {
            center = new Vec2d(bounds.x + (double)bounds.width / 2.0, bounds.y + (double)bounds.height / 2.0);
        }
        if (center != null) {
            for (PropertyDescriptor pd : effect.getEffectDescriptor().getPropertyDescriptors()) {
                if (pd.getPropertyClass() != AnimatableVec2d.class || !Boolean.parseBoolean(pd.getString("initiallyCenter"))) continue;
                AnimatableVec2d avalue = (AnimatableVec2d)pd.get(effect);
                avalue.reset((Object)center);
            }
        }
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        for (Entry entry : this._entries) {
            Effect effect;
            try {
                effect = (Effect)this._decoder.decodeElement((CharSequence)entry.data, Effect.class);
                effect.afterDecode(project);
            }
            catch (ProjectDecodeException e) {
                throw new JavieRuntimeException((Throwable)e);
            }
            EffectableLayer layer = (EffectableLayer)comp.getLayer(entry.layerId);
            layer.getEffects().add(entry.effectIndex, effect);
        }
        if (pm != null) {
            this.fireEffectsAddRemove(true, comp, pm);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        for (Entry entry : this._entries) {
            EffectableLayer layer = (EffectableLayer)comp.getLayer(entry.layerId);
            layer.getEffects().remove(entry.effectIndex);
        }
        if (pm != null) {
            this.fireEffectsAddRemove(false, comp, pm);
        }
        return Status.OK_STATUS;
    }

    private Object[][] createData(LayerComposition comp) {
        List data = Util.newList();
        for (Entry entry : this._entries) {
            EffectableLayer layer = (EffectableLayer)comp.getLayer(entry.layerId);
            data.add(new Object[]{layer, entry.effectIndex});
        }
        return (Object[][])data.toArray((T[])new Object[data.size()][]);
    }

    private void fireEffectsAddRemove(boolean add, LayerComposition comp, ProjectManager pm) {
        Object[][] data = this.createData(comp);
        if (add) {
            pm.fireEffectsAdd(comp, data);
        } else {
            pm.fireEffectsRemove(comp, data);
        }
    }

    private static class Entry {
        private String layerId;
        private String data;
        private int effectIndex;

        private Entry(String layerId, String data, int effectIndex) {
            this.layerId = layerId;
            this.data = data;
            this.effectIndex = effectIndex;
        }
    }
}

