/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.actions.NewCompositionAction;
import ch.kuramo.javie.app.actions.NewFileItemsAction;
import ch.kuramo.javie.app.actions.NewFolderAction;
import ch.kuramo.javie.app.actions.NewSolidColorItemAction;
import ch.kuramo.javie.app.actions.RenameItemAction;
import ch.kuramo.javie.app.project.NewFileItemsOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.RenameItemOperation;
import ch.kuramo.javie.app.project.ReparentItemsOperation;
import ch.kuramo.javie.app.views.ItemLabelProvider;
import ch.kuramo.javie.app.views.ItemTreeContentProvider;
import ch.kuramo.javie.app.views.LocalSelectionWrapper;
import ch.kuramo.javie.app.widgets.FontUtil;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.Util;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ProjectView
extends ViewPart {
    public static final String ID = "ch.kuramo.javie.app.views.projectView";
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private TreeViewer _treeViewer;
    private boolean _editName;

    public void createPartControl(Composite parent) {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getSite().getWorkbenchWindow());
        if (pm == null) {
            throw new IllegalStateException("No ProjectManager exists for this window.");
        }
        this._treeViewer = new TreeViewer(parent, 2);
        this._treeViewer.setContentProvider((IContentProvider)new ItemTreeContentProvider());
        Tree tree = this._treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(!COCOA);
        FontUtil.setCompatibleFont((Control)tree);
        tree.setBackground(ColorUtil.tableBackground());
        if (COCOA) {
            final Color lineColor = ColorUtil.tableRowLine();
            tree.addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    int x = event.x;
                    int y = event.y + event.height - 1;
                    GC gc = event.gc;
                    gc.setForeground(lineColor);
                    gc.drawLine(x, y, x + event.width, y);
                }
            });
        }
        TreeViewerColumn nameViewerColumn = this.createViewerColumn(200, null, "\u540d\u524d");
        this.setEditingSupportForName(nameViewerColumn);
        Image labelIcon = null;
        this.createViewerColumn(25, labelIcon, "");
        this.createViewerColumn(90, null, "\u7a2e\u985e");
        this.createViewerColumn(60, null, "\u30b5\u30a4\u30ba");
        this.createViewerColumn(90, null, "\uff83\uff9e\uff6d\uff9a\uff70\uff7c\uff6e\uff9d");
        this.createViewerColumn(300, null, "\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9");
        this.initContextMenu();
        this.initDragAndDrop();
        this.initDoubleClick();
        this._treeViewer.setInput((Object)pm);
    }

    private TreeViewerColumn createViewerColumn(int width, Image image, String name) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this._treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setWidth(width);
        column.setImage(image);
        column.setText(name);
        column.setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new ItemLabelProvider()));
        return viewerColumn;
    }

    private void setEditingSupportForName(TreeViewerColumn viewerColumn) {
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this._treeViewer){
            private final TextCellEditor cellEditor;
            {
                this.cellEditor = new TextCellEditor((Composite)ProjectView.this._treeViewer.getTree(), 2052);
                Control control = this.cellEditor.getControl();
                control.setBackground(control.getDisplay().getSystemColor(1));
            }

            protected boolean canEdit(Object element) {
                return ProjectView.this._editName;
            }

            protected CellEditor getCellEditor(Object element) {
                return this.cellEditor;
            }

            protected Object getValue(Object element) {
                return ((Item)element).getName();
            }

            protected void setValue(Object element, Object value) {
                ProjectManager pm = (ProjectManager)ProjectView.this._treeViewer.getInput();
                pm.postOperation(new RenameItemOperation(pm, (Item)element, String.valueOf(value)));
            }
        });
    }

    private void initContextMenu() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        MenuManager menuMgr = new MenuManager();
        MenuManager inputMenu = new MenuManager("\u8aad\u307f\u8fbc\u307f");
        menuMgr.add((IAction)new NewCompositionAction(window));
        menuMgr.add((IAction)new NewSolidColorItemAction(window));
        menuMgr.add((IAction)new NewFolderAction(window));
        menuMgr.add((IContributionItem)inputMenu);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new RenameItemAction(window, (Viewer)this._treeViewer));
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        inputMenu.add((IAction)new NewFileItemsAction(window));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._treeViewer);
        Control treeViewControl = this._treeViewer.getControl();
        Menu treeViewMenu = menuMgr.createContextMenu(treeViewControl);
        treeViewControl.setMenu(treeViewMenu);
    }

    private void initDragAndDrop() {
        final LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
        DragSourceListener sourceListener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionWrapper selection = new LocalSelectionWrapper((Viewer)ProjectView.this._treeViewer);
                if (selection.isEmpty()) {
                    event.doit = false;
                } else {
                    selectionTransfer.setSelection((ISelection)selection);
                    selectionTransfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                    event.doit = true;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = selectionTransfer.getSelection();
            }

            public void dragFinished(DragSourceEvent event) {
                selectionTransfer.setSelection(null);
                selectionTransfer.setSelectionSetTime(0L);
            }
        };
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        DropTargetAdapter targetListener = new DropTargetAdapter(){

            private Item getDestinationItem(TreeItem treeItem, boolean compAllowed) {
                if (treeItem == null) {
                    return null;
                }
                Object data = treeItem.getData();
                if (!(data instanceof Folder || compAllowed && data instanceof CompositionItem)) {
                    data = (treeItem = treeItem.getParentItem()) != null ? treeItem.getData() : null;
                }
                return (Item)data;
            }

            private boolean isAcceptable(DropTargetEvent event) {
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    return true;
                }
                if (!selectionTransfer.isSupportedType(event.currentDataType)) {
                    return false;
                }
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)ProjectView.this._treeViewer);
                if (selection == null) {
                    return false;
                }
                Item destItem = this.getDestinationItem((TreeItem)event.item, true);
                if (destItem == null) {
                    return true;
                }
                Set selectedFolders = Util.newSet();
                for (Object o : selection.toList()) {
                    if (!(o instanceof Folder)) continue;
                    selectedFolders.add((Folder)o);
                }
                Item i = destItem;
                while (i != null) {
                    if (selectedFolders.contains(i)) {
                        return false;
                    }
                    i = i.getParent();
                }
                return true;
            }

            public void dragOver(DropTargetEvent event) {
                if (!this.isAcceptable(event)) {
                    event.detail = 0;
                    event.feedback = 0;
                    return;
                }
                int detail = event.operations & 2;
                if (event.item != null) {
                    boolean isFile = fileTransfer.isSupportedType(event.currentDataType);
                    Item destItem = this.getDestinationItem((TreeItem)event.item, !isFile);
                    if (destItem != event.item.getData()) {
                        event.feedback = (event.feedback | 1 | 0x20) & 0xFFFFFFFB & 0xFFFFFFFD;
                    } else if (destItem instanceof CompositionItem) {
                        detail = event.operations & 4;
                    }
                }
                event.detail = detail;
            }

            public void dropAccept(DropTargetEvent event) {
                this.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
                boolean isFile = fileTransfer.isSupportedType(event.currentDataType);
                Item destItem = this.getDestinationItem((TreeItem)event.item, !isFile);
                ProjectManager pm = (ProjectManager)ProjectView.this._treeViewer.getInput();
                if (isFile) {
                    Set files = Util.newSet();
                    String[] stringArray = (String[])event.data;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String path = stringArray[n2];
                        files.add(new File(path));
                        ++n2;
                    }
                    pm.postOperation(new NewFileItemsOperation(pm, (Folder)destItem, files));
                } else {
                    ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)ProjectView.this._treeViewer);
                    if (selection == null) {
                        event.detail = 0;
                        return;
                    }
                    if (!(destItem instanceof CompositionItem)) {
                        List items = selection.toList();
                        pm.postOperation(new ReparentItemsOperation(pm, items, (Folder)destItem));
                    }
                }
            }
        };
        this._treeViewer.addDragSupport(6, new Transfer[]{selectionTransfer}, sourceListener);
        this._treeViewer.addDropSupport(6, new Transfer[]{selectionTransfer, fileTransfer}, (DropTargetListener)targetListener);
    }

    private void initDoubleClick() {
        class DoubleClickListener
        extends MouseAdapter
        implements IDoubleClickListener {
            private int modifiers;

            DoubleClickListener() {
            }

            public void mouseDown(MouseEvent event) {
                this.modifiers = event.stateMask & SWT.MODIFIER_MASK;
            }

            public void doubleClick(DoubleClickEvent event) {
                if (this.modifiers != 0) {
                    return;
                }
                ITreeSelection selection = (ITreeSelection)ProjectView.this._treeViewer.getSelection();
                for (Object item : selection) {
                    if (!(item instanceof Item)) continue;
                    ProjectView.this.openItem((Item)item);
                }
            }
        }
        DoubleClickListener listener = new DoubleClickListener();
        this._treeViewer.getTree().addMouseListener((MouseListener)listener);
        this._treeViewer.addDoubleClickListener((IDoubleClickListener)listener);
    }

    public void setFocus() {
        this._treeViewer.getControl().setFocus();
    }

    public Folder getItemTreeInsertionPoint() {
        TreeSelection selection = (TreeSelection)this._treeViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        TreePath[] pathes = selection.getPaths();
        if (pathes.length == 1) {
            Item item = (Item)pathes[0].getLastSegment();
            return item instanceof Folder ? (Folder)item : item.getParent();
        }
        Folder folder = null;
        int i = 1;
        while (true) {
            Folder tmp = null;
            TreePath[] treePathArray = pathes;
            int n = pathes.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (path.getSegmentCount() <= i) {
                    return folder;
                }
                Folder parent = ((Item)path.getSegment(i)).getParent();
                if (tmp == null) {
                    tmp = parent;
                } else if (tmp != parent) {
                    return folder;
                }
                ++n2;
            }
            folder = tmp;
            ++i;
        }
    }

    public void editName(Item item) {
        this._editName = true;
        this._treeViewer.editElement((Object)item, 0);
        this._editName = false;
    }

    private void openItem(Item item) {
        IWorkbenchPage page = this.getSite().getPage();
        if (item instanceof CompositionItem && ((CompositionItem)item).getComposition() instanceof LayerComposition) {
            UIUtil.showView(page, "ch.kuramo.javie.app.views.layerCompositionView", item.getId(), 1);
            UIUtil.showView(page, "ch.kuramo.javie.app.views.mediaPlayerView", item.getId(), 2);
            return;
        }
        if (item instanceof MediaItem) {
            UIUtil.showView(page, "ch.kuramo.javie.app.views.mediaPlayerView", item.getId(), 1);
        }
    }
}

