/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnimatableValueElementDelegate<V> {
    private static final int[] UNDERLINE_DASH = new int[]{2, 2};
    protected static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    protected static final boolean WIN32 = SWT.getPlatform().equals("win32");
    protected final AnimatableValueElement element;
    protected final String name;
    protected final AnimatableValue<V> avalue;
    protected V value;
    protected final Rectangle stopwatchArea = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, 13, 14);
    protected final List<Rectangle> valueArea = Util.newList();
    protected int yKeyframe = Integer.MIN_VALUE;
    protected V originalValue;
    protected int valueIndex;
    protected DragGestureEditor dragGestureEditor;
    protected boolean canInlineEdit;
    protected Element[] children;
    private static Method cocoaGetCurrentButtonStateMethod;

    public AnimatableValueElementDelegate(AnimatableValueElement element, String name, AnimatableValue<V> avalue) {
        this.element = element;
        this.name = name;
        this.avalue = avalue;
    }

    public Image getColumnImage(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ImageUtil.getStopwatchIcon(this.avalue.hasKeyframe());
            }
        }
        return null;
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.name;
            }
            case 1: {
                return " ";
            }
        }
        return null;
    }

    public boolean hasChildren() {
        return this.hasExpression();
    }

    public Element[] getChildren() {
        if (this.hasExpression()) {
            if (this.children == null) {
                this.children = new Element[]{new ExpressionElement()};
            }
            return this.children;
        }
        return Element.EMPTY_CHILDREN;
    }

    public void paintColumn(Event event) {
        switch (event.index) {
            case 0: {
                this.stopwatchArea.x = event.x + 5;
                this.stopwatchArea.y = event.y + (WIN32 ? 1 : 4);
                break;
            }
            case 1: {
                this.updateValue();
                this.valueArea.clear();
                GC gc = event.gc;
                int x = event.x + 5;
                int y = event.y;
                int height = ((TreeItem)event.item).getBounds((int)event.index).height;
                boolean focused = (event.detail & 2) != 0 && ((Control)event.widget).isFocusControl();
                this.drawValue(gc, x, y, height, focused);
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
                this.yKeyframe = tm.drawKeyframes(event, this.avalue);
            }
        }
    }

    public void updateCursor(MouseEvent event, int columnIndex) {
        Cursor cursor = null;
        block0 : switch (columnIndex) {
            case 1: {
                for (Rectangle r : this.valueArea) {
                    if (!r.contains(event.x, event.y)) continue;
                    cursor = event.display.getSystemCursor(21);
                    break block0;
                }
                break;
            }
        }
        this.element.viewer.getTree().setCursor(cursor);
    }

    public void mouseDown(MouseEvent event, int columnIndex) {
        block0 : switch (columnIndex) {
            case 0: {
                if (!this.stopwatchArea.contains(event.x, event.y)) break;
                this.toggleStopwatchButon();
                break;
            }
            case 1: {
                if (event.button != 1) break;
                int i = 0;
                int n = this.valueArea.size();
                while (i < n) {
                    Rectangle r = this.valueArea.get(i);
                    if (r.contains(event.x, event.y)) {
                        if (!this.canDragGestureEdit()) {
                            this.valueIndex = i;
                            this.openInlineEditor();
                            break block0;
                        }
                        if (this.dragGestureEditor != null) break block0;
                        this.originalValue = this.value;
                        this.valueIndex = i;
                        this.dragGestureEditor = new DragGestureEditor(event);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 7: {
                TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
                tm.mouseDown(event, this.yKeyframe, this.element, this.avalue);
            }
        }
    }

    public boolean canEdit(int columnIndex) {
        return false;
    }

    public CellEditor getCellEditor(int columnIndex) {
        return null;
    }

    public Object getCellEditorValue(int columnIndex) {
        return null;
    }

    public void setCellEditorValue(int columnIndex, Object value) {
    }

    public boolean updateValue() {
        Map animatableValues = (Map)this.element.viewer.getData("ANIMATABLE_VALUES");
        Object newValue = animatableValues.get(this.avalue);
        if (this.value != null && !this.value.equals(newValue) || this.value == null && newValue != null) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public boolean hasExpression() {
        return this.avalue.getExpression() != null;
    }

    protected void openInlineEditor() {
        this.element.viewer.getTree().setCursor(null);
        this.canInlineEdit = true;
        this.element.viewer.editElement((Object)this.element, 1);
        this.canInlineEdit = false;
    }

    protected void modifyValue(V newValue) {
        this.modifyValue(newValue, null);
    }

    protected void modifyValue(V newValue, String relation) {
        if (newValue != null && this.avalue instanceof ArithmeticalAnimatableValue) {
            newValue = ((ArithmeticalAnimatableValue)this.avalue).clamp(newValue);
        }
        if (this.value != null && !this.value.equals(newValue) || this.value == null && newValue != null) {
            ProjectManager pm = (ProjectManager)this.element.viewer.getData("PROJECT_MANAGER");
            TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
            pm.postOperation(this.avalue.hasKeyframe() ? this.element.createModifyKeyframeOperation(pm, tm.getCurrentTime(), newValue, relation) : this.element.createModifyValueOperation(pm, newValue, relation));
        }
    }

    protected void modifyExpression(String newExpr) {
        String oldExpr;
        if (newExpr != null && (newExpr = newExpr.trim()).length() == 0) {
            newExpr = null;
        }
        if ((oldExpr = this.avalue.getExpression()) != null && !oldExpr.equals(newExpr) || oldExpr == null && newExpr != null) {
            ProjectManager pm = (ProjectManager)this.element.viewer.getData("PROJECT_MANAGER");
            ProjectOperation operation = this.element.createModifyExpressionOperation(pm, newExpr);
            pm.postOperation(operation);
        }
    }

    protected void toggleStopwatchButon() {
        ProjectManager pm = (ProjectManager)this.element.viewer.getData("PROJECT_MANAGER");
        TimelineManager tm = (TimelineManager)this.element.viewer.getData("TIMELINE_MANAGER");
        pm.postOperation(this.avalue.hasKeyframe() ? this.element.createClearKeyframesOperation(pm) : this.element.createModifyKeyframeOperation(pm, tm.getCurrentTime(), this.value, null));
    }

    protected abstract void drawValue(GC var1, int var2, int var3, int var4, boolean var5);

    protected abstract boolean canDragGestureEdit();

    protected abstract V dragGesture(double var1, double var3);

    protected void setForeground(GC gc, boolean focused) {
        gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 2));
    }

    protected void setValueForeground(GC gc, boolean focused) {
        gc.setForeground(gc.getDevice().getSystemColor(focused ? 1 : 10));
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, String value) {
        this.setValueForeground(gc, focused);
        Point extent = gc.textExtent(value, 1);
        gc.drawString(value, x, y += (height - extent.y) / 2, true);
        this.valueArea.add(new Rectangle(x, y, extent.x, extent.y));
        y += extent.y;
        gc.setLineDash(UNDERLINE_DASH);
        if (COCOA) {
            gc.drawLine(x, y - 1, x + extent.x, y - 1);
        } else if (WIN32) {
            gc.drawLine(x, y, x + extent.x - 2, y);
        } else {
            gc.drawLine(x, y, x + extent.x, y);
        }
        return x + extent.x;
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, Double value, int precision, String unit) {
        x = this.drawValue(gc, x, y, height, focused, String.format("%." + precision + "f", value));
        if (unit != null) {
            x = this.drawString(gc, x + 1, y, height, unit);
        }
        return x;
    }

    protected int drawValue(GC gc, int x, int y, int height, boolean focused, Integer value, String unit) {
        x = this.drawValue(gc, x, y, height, focused, value.toString());
        if (unit != null) {
            x = this.drawString(gc, x + 1, y, height, unit);
        }
        return x;
    }

    protected int drawString(GC gc, int x, int y, int height, String str) {
        Point extent = gc.textExtent(str, 1);
        gc.drawString(str, x, y += (height - extent.y) / 2, true);
        return x + extent.x;
    }

    protected String formatValue(Double value, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException();
        }
        String s = String.format("%." + precision + "f", value);
        int dotIndex = s.indexOf(46);
        if (dotIndex != -1) {
            int i = s.length() - 1;
            while (i >= dotIndex) {
                char c = s.charAt(i);
                if (c != '0') {
                    return s.substring(0, c == '.' ? i : i + 1);
                }
                --i;
            }
        }
        return s;
    }

    private static int getCocoaCurrentButtonState() {
        try {
            if (cocoaGetCurrentButtonStateMethod == null) {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.OS");
                cocoaGetCurrentButtonStateMethod = clazz.getMethod("GetCurrentButtonState", new Class[0]);
            }
            return (Integer)cocoaGetCurrentButtonStateMethod.invoke(null, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    protected class DragGestureEditor {
        private final String relation = Util.randomId();
        private final long downTime;
        private final Point downPoint;
        private boolean dragDetected;
        private Point detectPoint;
        private Point prevPoint;
        private double[] currentPoint;

        protected DragGestureEditor(MouseEvent event) {
            Control control = (Control)event.widget;
            this.downTime = System.currentTimeMillis();
            this.downPoint = control.toDisplay(event.x, event.y);
            this.init(control);
        }

        private void init(final Control control) {
            final Display display = control.getDisplay();
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 5: {
                            if (!control.isDisposed()) {
                                if (COCOA && (AnimatableValueElementDelegate.getCocoaCurrentButtonState() & 1) == 0) break;
                                Point pt = display.getCursorLocation();
                                if (!DragGestureEditor.this.dragDetected) {
                                    DragGestureEditor.this.dragDetected = System.currentTimeMillis() - DragGestureEditor.this.downTime > 100L && (Math.abs(pt.x - ((DragGestureEditor)DragGestureEditor.this).downPoint.x) > 3 || Math.abs(pt.y - ((DragGestureEditor)DragGestureEditor.this).downPoint.y) > 3);
                                    if (DragGestureEditor.this.dragDetected) {
                                        DragGestureEditor.this.currentPoint = new double[]{pt.x, pt.y};
                                        Point point = pt;
                                        DragGestureEditor.this.detectPoint = point;
                                        DragGestureEditor.this.prevPoint = point;
                                    }
                                }
                                if (!DragGestureEditor.this.dragDetected) break;
                                double deltaScale = (e.stateMask & SWT.MOD2) != 0 ? 10.0 : ((e.stateMask & SWT.MOD1) != 0 ? 0.1 : 1.0);
                                double[] dArray = DragGestureEditor.this.currentPoint;
                                dArray[0] = dArray[0] + (double)(pt.x - ((DragGestureEditor)DragGestureEditor.this).prevPoint.x) * deltaScale;
                                double[] dArray2 = DragGestureEditor.this.currentPoint;
                                dArray2[1] = dArray2[1] + (double)(pt.y - ((DragGestureEditor)DragGestureEditor.this).prevPoint.y) * deltaScale;
                                DragGestureEditor.this.prevPoint = pt;
                                Object newValue = AnimatableValueElementDelegate.this.dragGesture(DragGestureEditor.this.currentPoint[0] - (double)((DragGestureEditor)DragGestureEditor.this).detectPoint.x, DragGestureEditor.this.currentPoint[1] - (double)((DragGestureEditor)DragGestureEditor.this).detectPoint.y);
                                AnimatableValueElementDelegate.this.modifyValue(newValue, DragGestureEditor.this.relation);
                                break;
                            }
                        }
                        case 4: 
                        case 27: {
                            ((DragGestureEditor)DragGestureEditor.this).AnimatableValueElementDelegate.this.dragGestureEditor = null;
                            display.removeFilter(5, (Listener)this);
                            display.removeFilter(4, (Listener)this);
                            display.removeFilter(27, (Listener)this);
                            if (e.type != 4 || control.isDisposed() || DragGestureEditor.this.dragDetected) break;
                            AnimatableValueElementDelegate.this.openInlineEditor();
                        }
                    }
                }
            };
            display.addFilter(5, listener);
            display.addFilter(4, listener);
            display.addFilter(27, listener);
        }
    }

    public class ExpressionElement
    extends Element {
        private static final String EDITOR_KEY = "ExpressionElement.TextCellEditor";

        public ExpressionElement() {
            super(AnimatableValueElementDelegate.this.element);
        }

        public String getColumnText(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "\u30a8\u30af\u30b9\u30d7\u30ec\u30c3\u30b7\u30e7\u30f3\uff1a" + AnimatableValueElementDelegate.this.name;
                }
                case 7: {
                    return AnimatableValueElementDelegate.this.avalue.getExpression();
                }
            }
            return null;
        }

        public void mouseDown(MouseEvent event, int columnIndex) {
            super.mouseDown(event, columnIndex);
            if (WIN32 && columnIndex == 7 && event.button == 1) {
                this.viewer.editElement((Object)this, 7);
            }
        }

        public boolean canEdit(int columnIndex) {
            return columnIndex == 7;
        }

        public CellEditor getCellEditor(int columnIndex) {
            if (columnIndex == 7) {
                TextCellEditor editor = (TextCellEditor)this.viewer.getData(EDITOR_KEY);
                if (editor == null) {
                    editor = new TextCellEditor((Composite)this.viewer.getTree(), 2052);
                    Control control = editor.getControl();
                    control.setBackground(control.getDisplay().getSystemColor(1));
                    this.viewer.setData(EDITOR_KEY, (Object)editor);
                }
                return editor;
            }
            return null;
        }

        public Object getCellEditorValue(int columnIndex) {
            if (columnIndex == 7) {
                return AnimatableValueElementDelegate.this.avalue.getExpression();
            }
            return null;
        }

        public void setCellEditorValue(int columnIndex, Object value) {
            if (columnIndex == 7) {
                AnimatableValueElementDelegate.this.modifyExpression((String)value);
            }
        }
    }
}

