/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.project.ModifyEffectPropertyOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.RenameEffectOperation;
import ch.kuramo.javie.app.views.layercomp.EffectAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.EffectsElement;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.app.views.layercomp.Switch;
import ch.kuramo.javie.app.views.layercomp.SwitchGroup;
import ch.kuramo.javie.app.widgets.WSWin32;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.PropertyDescriptor;
import ch.kuramo.javie.core.Util;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class EffectElement
extends Element {
    public final Effect effect;
    private final List<Element> children = Util.newList();
    private final Map<PropertyDescriptor, Element> childrenMap = Util.newMap();
    private final SwitchGroup enableSwitch = new SwitchGroup();
    private TextCellEditor nameEditor;
    private static final ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();

    public EffectElement(EffectsElement parent, Effect effect) {
        super(parent);
        if (!this.getLayer().getEffects().contains(effect)) {
            throw new IllegalArgumentException();
        }
        this.effect = effect;
        this.enableSwitch.add(new EnableSwitch());
        if (WSWin32.isXPThemed()) {
            this.enableSwitch.setMarginLeft(11);
        }
    }

    public String getColumnText(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.effect.getName();
            }
        }
        return null;
    }

    public boolean hasChildren() {
        return this.effect.getEffectDescriptor().getPropertyDescriptors().size() > 0;
    }

    public Element[] getChildren() {
        this.prepareChildren();
        return this.children.toArray(new Element[this.children.size()]);
    }

    public void paintColumn(Event event) {
        switch (event.index) {
            case 5: {
                this.enableSwitch.paint(event);
                break;
            }
            default: {
                super.paintColumn(event);
            }
        }
    }

    public void mouseDown(MouseEvent event, int columnIndex) {
        switch (columnIndex) {
            case 5: {
                this.enableSwitch.mouseDown(event);
                break;
            }
            default: {
                super.mouseDown(event, columnIndex);
            }
        }
    }

    public boolean canEdit(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.TRUE.equals(this.viewer.getData("EDIT_ELEMENT_NAME"));
            }
        }
        return false;
    }

    public CellEditor getCellEditor(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                if (this.nameEditor == null) {
                    this.nameEditor = new TextCellEditor((Composite)this.viewer.getTree(), 2052);
                    Control control = this.nameEditor.getControl();
                    control.setBackground(control.getDisplay().getSystemColor(1));
                }
                return this.nameEditor;
            }
        }
        return null;
    }

    public Object getCellEditorValue(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.effect.getName();
            }
        }
        return null;
    }

    public void setCellEditorValue(int columnIndex, Object value) {
        ProjectManager pm = (ProjectManager)this.viewer.getData("PROJECT_MANAGER");
        switch (columnIndex) {
            case 0: {
                String newName = (String)value;
                if (newName.length() == 0) {
                    newName = this.effect.getEffectDescriptor().getLabel();
                }
                pm.postOperation(new RenameEffectOperation(pm, this.getLayer(), this.effect, newName));
            }
        }
    }

    private EffectableLayer getLayer() {
        return (EffectableLayer)((LayerElement)this.parent.parent).layer;
    }

    private Element getChildElement(PropertyDescriptor pd) {
        Element child = this.childrenMap.get(pd);
        if (child == null) {
            child = AnimatableValue.class.isAssignableFrom(pd.getPropertyClass()) ? new EffectAnimatableValueElement(this, this.getLayer(), this.effect, pd) : new Element(this);
            this.childrenMap.put(pd, child);
        }
        return child;
    }

    private void prepareChildren() {
        this.children.clear();
        for (PropertyDescriptor pd : this.effect.getEffectDescriptor().getPropertyDescriptors()) {
            this.children.add(this.getChildElement(pd));
        }
        this.childrenMap.values().retainAll(this.children);
    }

    private class EnableSwitch
    implements Switch {
        private EnableSwitch() {
        }

        public boolean hasBorder() {
            return true;
        }

        public Image getImage() {
            return EffectElement.this.effect.isEnabled() ? imageRegistry.get("IMG_SWITCH_EFFECT") : null;
        }

        public void mouseDown(MouseEvent event) {
            boolean currentEnabled = EffectElement.this.effect.isEnabled();
            String label = currentEnabled ? "\u30a8\u30d5\u30a7\u30af\u30c8\u306e\u505c\u6b62" : "\u30a8\u30d5\u30a7\u30af\u30c8\u306e\u4f7f\u7528";
            ProjectManager pm = (ProjectManager)EffectElement.this.viewer.getData("PROJECT_MANAGER");
            pm.postOperation(new ModifyEffectPropertyOperation<Boolean>(pm, EffectElement.this.getLayer(), EffectElement.this.effect, "enabled", !currentEnabled, label));
        }
    }
}

