/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.layercomp.AnimatableStringElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.core.AnimatableString;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class TextSourceElementDelegate
extends AnimatableStringElementDelegate {
    private static final String EDITOR_KEY = "TextSourceElementDelegate.TextCellEditor";
    private static final Pattern LF = Pattern.compile("\\n");
    private static final Pattern CR_OR_CRLF = Pattern.compile("\\r\\n?");

    public TextSourceElementDelegate(AnimatableValueElement element, String name, AnimatableString avalue) {
        super(element, name, avalue);
    }

    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            TextCellEditor editor = (TextCellEditor)this.element.viewer.getData(EDITOR_KEY);
            if (editor == null) {
                editor = new TextCellEditor((Composite)this.element.viewer.getTree(), 2562){

                    public CellEditor.LayoutData getLayoutData() {
                        CellEditor.LayoutData data = super.getLayoutData();
                        data.minimumHeight = 80;
                        data.verticalAlignment = 128;
                        return data;
                    }
                };
                Control control = editor.getControl();
                control.setBackground(control.getDisplay().getSystemColor(1));
                this.element.viewer.setData(EDITOR_KEY, (Object)editor);
            }
            return editor;
        }
        return super.getCellEditor(columnIndex);
    }

    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            return LF.matcher((CharSequence)this.value).replaceAll(Text.DELIMITER);
        }
        return super.getCellEditorValue(columnIndex);
    }

    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            value = CR_OR_CRLF.matcher((String)value).replaceAll("\n");
        }
        super.setCellEditorValue(columnIndex, value);
    }
}

