/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.LayerSlipOperation;
import ch.kuramo.javie.app.project.ModifyKeyframeInterpolationOperation;
import ch.kuramo.javie.app.project.ModifyLayerInPointOperation;
import ch.kuramo.javie.app.project.ModifyLayerOutPointOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.project.RemoveKeyframesOperation;
import ch.kuramo.javie.app.project.ShiftKeyframesOperation;
import ch.kuramo.javie.app.project.ShiftLayerTimesOperation;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.EffectAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.TimeCode;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineManager {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final int FRAME_WIDTH = 50;
    private static final int LEFT_MARGIN = 20;
    private static final int RIGHT_MARGIN = 40;
    private final ProjectManager projectManager;
    private final LayerComposition composition;
    private final LayerCompositionView view;
    private final Composite meter;
    private final Scale zoomScale;
    private final Slider scrollSlider;
    private final TreeColumn timelineColumn;
    private double zoom;
    private Time currentTime;
    private Time fromTime;
    private Time toTime;
    private boolean wrapMode = true;
    private final Map<Keyframe<?>, AnimatableValueElement> keyframeSelection = Util.newMap();
    private AbstractDragGestureEditor dragGestureEditor;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;
    private static Method cocoaGetCurrentButtonStateMethod;

    public TimelineManager(ProjectManager projectManager, LayerComposition composition, LayerCompositionView view, Composite meter, Scale zoomScale, Slider scrollSlider, Tree tree) {
        InjectorHolder.getInjector().injectMembers((Object)this);
        this.projectManager = projectManager;
        this.composition = composition;
        this.view = view;
        this.meter = meter;
        this.zoomScale = zoomScale;
        this.scrollSlider = scrollSlider;
        this.timelineColumn = tree.getColumn(tree.getColumnCount() - 1);
        this.zoom = Double.NaN;
        meter.setBackground(ColorUtil.tableBackground());
        meter.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TimelineManager.this.drawMeter(e);
            }
        });
        meter.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TimelineManager.this.mouseDownOnMeter(e);
            }
        });
        zoomScale.setMinimum(0);
        zoomScale.setMaximum(10);
        zoomScale.setSelection(5);
        zoomScale.setIncrement(1);
        zoomScale.setPageIncrement(1);
        scrollSlider.setMinimum(0);
        scrollSlider.setIncrement(50);
        this.update(Time.fromFrameNumber((long)0L, (Time)composition.getFrameDuration()), true);
    }

    public void update(Time currentTime, boolean reveal) {
        if (this.dragGestureEditor != null) {
            reveal = false;
        }
        int oldScroll = this.scrollSlider.getSelection();
        double oldZoom = this.zoom;
        Time compDuration = this.composition.getDuration();
        Time frameDuration = this.composition.getFrameDuration();
        double zoom = Math.pow(2.0, this.zoomScale.getSelection() - this.zoomScale.getMaximum());
        int totalPixels = this.timeToPixels(compDuration, frameDuration, zoom) + 40;
        int colWidth = this.timelineColumn.getWidth();
        this.scrollSlider.setMaximum(totalPixels);
        this.scrollSlider.setThumb(colWidth);
        this.scrollSlider.setPageIncrement(colWidth - 20 - 40);
        this.scrollSlider.setEnabled(totalPixels > colWidth);
        boolean wrap = this.wrapMode;
        if (!reveal && zoom != oldZoom && !Double.isNaN(oldZoom)) {
            Time oldFromTime = this.pixelsToTime(oldScroll, frameDuration, oldZoom);
            Time oldToTime = this.pixelsToTime(oldScroll + colWidth, frameDuration, oldZoom);
            if (currentTime.before(oldFromTime) || currentTime.after(oldToTime)) {
                Time tmp = oldFromTime.add(oldToTime);
                Time center = new Time(tmp.timeValue / 2L, tmp.timeScale);
                this.scrollSlider.setSelection(this.timeToPixels(center, frameDuration, zoom) - colWidth / 2);
            } else {
                int offset = this.timeToPixels(currentTime, frameDuration, oldZoom) - this.timeToPixels(oldFromTime, frameDuration, oldZoom);
                this.scrollSlider.setSelection(this.timeToPixels(currentTime, frameDuration, zoom) - offset);
                reveal = true;
                wrap = false;
            }
        }
        if (reveal) {
            Time leftTime = this.pixelsToTime(this.scrollSlider.getSelection() + 20, frameDuration, zoom);
            Time rightTime = this.pixelsToTime(this.scrollSlider.getSelection() + colWidth - 40 - (int)(50.0 * zoom), frameDuration, zoom);
            if (currentTime.before(leftTime) || wrap && currentTime.after(rightTime)) {
                this.scrollSlider.setSelection(this.timeToPixels(currentTime, frameDuration, zoom) - 20);
            } else if (!wrap && currentTime.after(rightTime)) {
                Time t = currentTime.add(leftTime).subtract(rightTime);
                this.scrollSlider.setSelection(this.timeToPixels(t, frameDuration, zoom) - 20);
            }
        }
        this.zoom = zoom;
        this.currentTime = currentTime;
        this.fromTime = this.pixelsToTime(this.scrollSlider.getSelection(), frameDuration, zoom);
        this.toTime = this.pixelsToTime(this.scrollSlider.getSelection() + colWidth, frameDuration, zoom);
        this.redraw();
    }

    public void redraw() {
        int x = this.timelineColumnX();
        Tree tree = this.timelineColumn.getParent();
        Rectangle clientArea = tree.getClientArea();
        tree.redraw(clientArea.x + x, clientArea.y, clientArea.width - x, clientArea.height, true);
        this.meter.redraw();
    }

    private int timeToPixels(Time time, Time frameDuration, double zoom) {
        return (int)Math.round(50.0 * zoom * time.toSecond() / frameDuration.toSecond()) + 20;
    }

    private Time pixelsToTime(int pixels, Time frameDuration, double zoom) {
        double frames = (double)(pixels - 20) / (50.0 * zoom);
        return new Time(Math.round(frames * (double)frameDuration.timeValue), frameDuration.timeScale);
    }

    private int timelineColumnX() {
        Tree tree = this.timelineColumn.getParent();
        int x = 0;
        int i = 0;
        int n = tree.getColumnCount() - 1;
        while (i < n) {
            TreeColumn column = tree.getColumn(i);
            x += column.getWidth();
            ++i;
        }
        return x;
    }

    public void drawCurrentFrameRegion(Event e) {
        Time frameDuration = this.composition.getFrameDuration();
        int scroll = this.scrollSlider.getSelection();
        int x1 = this.timeToPixels(this.currentTime, frameDuration, this.zoom) - scroll;
        int x2 = this.timeToPixels(this.currentTime.add(frameDuration), frameDuration, this.zoom) - scroll;
        e.gc.setBackground(e.display.getSystemColor(9));
        e.gc.setAlpha(48);
        e.gc.fillRectangle(e.x + x1, e.y, x2 - x1, e.height);
        e.gc.setAlpha(255);
    }

    public void drawTimeIndicatorLine(PaintEvent e) {
        int x;
        Time frameDuration = this.composition.getFrameDuration();
        int scroll = this.scrollSlider.getSelection();
        int left = this.timeToPixels(this.fromTime, frameDuration, this.zoom) - scroll;
        if (left <= (x = this.timeToPixels(this.currentTime, frameDuration, this.zoom) - scroll)) {
            e.gc.setForeground(e.display.getSystemColor(3));
            e.gc.drawLine(x += this.timelineColumnX(), e.y, x, e.y + e.height);
        }
    }

    public void drawColumnLeftLine(PaintEvent e) {
        int x = this.timelineColumnX() - 1;
        e.gc.setForeground(ColorUtil.tableRowLine());
        e.gc.drawLine(x, e.y, x, e.y + e.height);
    }

    private void drawMeter(PaintEvent e) {
        Display display = e.display;
        GC gc = e.gc;
        Time frameDuration = this.composition.getFrameDuration();
        int scroll = this.scrollSlider.getSelection();
        int h = this.meter.getBounds().height;
        gc.setForeground(display.getSystemColor(2));
        long step = (long)(1.0 / this.zoom);
        long i0 = this.fromTime.toFrameNumber(frameDuration) - step;
        long i1 = this.toTime.toFrameNumber(frameDuration) + step;
        long i = i0 = Math.max(i0 / step * step, 0L);
        while (i <= i1) {
            Time t = Time.fromFrameNumber((long)i, (Time)frameDuration);
            int x = this.timeToPixels(t, frameDuration, this.zoom) - scroll;
            String text = TimeCode.toTimeCode((Time)t, (Time)frameDuration, (boolean)true, (boolean)false);
            Point extent = gc.textExtent(text);
            gc.drawLine(x, extent.y, x, h);
            if (i / step % 3L == 0L) {
                gc.drawText(text, x - extent.x / 2, 0);
            }
            i += step;
        }
        int x = this.timeToPixels(this.currentTime, frameDuration, this.zoom) - scroll;
        gc.setForeground(display.getSystemColor(3));
        gc.drawLine(x, 0, x, h);
    }

    private void mouseDownOnMeter(MouseEvent e) {
        this.setWrapMode(false);
        this.updateView(e.x);
        Control control = (Control)e.widget;
        Display display = e.display;
        class MeterMouseTracker
        implements Runnable,
        Listener {
            private int x;
            private boolean end;
            private final /* synthetic */ Display val$display;
            private final /* synthetic */ Control val$control;

            MeterMouseTracker(MouseEvent mouseEvent, Display display, Control control) {
                this.val$display = display;
                this.val$control = control;
                this.x = mouseEvent.x;
            }

            public void run() {
                if (!this.end) {
                    TimelineManager.this.updateView(this.x);
                    this.val$display.timerExec(30, (Runnable)this);
                }
            }

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 5: {
                        if (!this.val$control.isDisposed()) {
                            if (COCOA && (TimelineManager.getCocoaCurrentButtonState() & 1) == 0) break;
                            this.x = this.val$control.toControl((Point)this.val$display.getCursorLocation()).x;
                            TimelineManager.this.updateView(this.x);
                            break;
                        }
                    }
                    case 4: 
                    case 27: {
                        this.end = true;
                        this.val$display.removeFilter(5, (Listener)this);
                        this.val$display.removeFilter(4, (Listener)this);
                        this.val$display.removeFilter(27, (Listener)this);
                        TimelineManager.this.setWrapMode(true);
                    }
                }
            }
        }
        MeterMouseTracker tracker = new MeterMouseTracker(e, display, control);
        display.timerExec(30, (Runnable)tracker);
        display.addFilter(5, (Listener)tracker);
        display.addFilter(4, (Listener)tracker);
        display.addFilter(27, (Listener)tracker);
    }

    private void updateView(int x) {
        Time frameDuration = this.composition.getFrameDuration();
        int scroll = this.scrollSlider.getSelection();
        Time time = this.pixelsToTime(x + scroll, frameDuration, this.zoom);
        if (time.timeValue < 0L) {
            time = new Time(0L, time.timeScale);
        } else if (!time.before(this.composition.getDuration())) {
            time = this.composition.getDuration().subtract(frameDuration);
        }
        time = Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration);
        if (!time.equals((Object)this.currentTime)) {
            this.view.update(time);
        }
    }

    public void drawLayer(Event e, Layer layer) {
        Time duration;
        MediaInput input;
        Time frameDuration = this.composition.getFrameDuration();
        int scroll = this.scrollSlider.getSelection();
        int x = e.x;
        int y = e.y;
        int h = e.height - 1;
        GC gc = e.gc;
        boolean hasSlipBar = false;
        if (layer instanceof MediaItemLayer && !LayerNature.isTimeRemapEnabled((Layer)layer) && (input = ((MediaItemLayer)layer).getMediaInput()) != null && (duration = input.getDuration()) != null) {
            Time startTime = layer.getStartTime();
            Time endTime = startTime.add(new Time((long)((double)duration.timeValue / Math.abs(layer.getRate())), duration.timeScale));
            int x1 = x + this.timeToPixels(startTime, frameDuration, this.zoom) - scroll;
            int x2 = x + this.timeToPixels(endTime, frameDuration, this.zoom) - scroll;
            gc.setBackground(e.display.getSystemColor(3));
            gc.setAlpha(64);
            gc.fillRectangle(x1, y, x2 - x1, h);
            hasSlipBar = true;
        }
        Time inPoint = layer.getInPoint();
        Time outPoint = layer.getOutPoint();
        int x1 = x + this.timeToPixels(inPoint, frameDuration, this.zoom) - scroll;
        int x2 = x + this.timeToPixels(outPoint, frameDuration, this.zoom) - scroll;
        if (!hasSlipBar) {
            gc.setBackground(e.display.getSystemColor(3));
            gc.setAlpha(64);
            gc.fillRectangle(x1, y, x2 - x1, h);
        }
        gc.setBackground(e.display.getSystemColor(4));
        gc.setAlpha(128);
        gc.fillRectangle(x1, y, x2 - x1, h);
        gc.setAlpha(255);
        this.drawCurrentFrameRegion(e);
    }

    public void updateCursor(MouseEvent e, Layer layer) {
        Time duration;
        MediaInput input;
        if (this.dragGestureEditor != null) {
            return;
        }
        Cursor cursor = null;
        Time frameDuration = this.composition.getFrameDuration();
        Time inPoint = layer.getInPoint();
        Time outPoint = layer.getOutPoint();
        int x = e.x - this.timelineColumnX() + this.scrollSlider.getSelection();
        int x1 = this.timeToPixels(inPoint, frameDuration, this.zoom);
        int x2 = this.timeToPixels(outPoint, frameDuration, this.zoom);
        if (x1 - 3 < x && x < x1 + 3) {
            cursor = e.display.getSystemCursor(12);
        } else if (x2 - 3 < x && x < x2 + 3) {
            cursor = e.display.getSystemCursor(13);
        } else if (x1 <= x && x < x2) {
            cursor = e.display.getSystemCursor(21);
        } else if (layer instanceof MediaItemLayer && !LayerNature.isTimeRemapEnabled((Layer)layer) && (input = ((MediaItemLayer)layer).getMediaInput()) != null && (duration = input.getDuration()) != null) {
            Time startTime = layer.getStartTime();
            Time endTime = startTime.add(new Time((long)((double)duration.timeValue / Math.abs(layer.getRate())), duration.timeScale));
            x1 = this.timeToPixels(startTime, frameDuration, this.zoom);
            x2 = this.timeToPixels(endTime, frameDuration, this.zoom);
            if (x1 <= x && x < x2) {
                cursor = e.display.getSystemCursor(21);
            }
        }
        Tree tree = this.timelineColumn.getParent();
        tree.setCursor(cursor);
    }

    public void mouseDown(MouseEvent e, Layer layer) {
        if (this.dragGestureEditor != null) {
            return;
        }
        Time frameDuration = this.composition.getFrameDuration();
        Time inPoint = layer.getInPoint();
        Time outPoint = layer.getOutPoint();
        int x = e.x - this.timelineColumnX() + this.scrollSlider.getSelection();
        int x1 = this.timeToPixels(inPoint, frameDuration, this.zoom);
        int x2 = this.timeToPixels(outPoint, frameDuration, this.zoom);
        if (x1 - 3 < x && x < x1 + 3) {
            this.clearKeyframeSelection();
            this.dragGestureEditor = new DragGestureInPointShifter(e, this.pixelsToTime(x, frameDuration, this.zoom));
        } else if (x2 - 3 < x && x < x2 + 3) {
            this.clearKeyframeSelection();
            this.dragGestureEditor = new DragGestureOutPointShifter(e, this.pixelsToTime(x, frameDuration, this.zoom));
        } else if (x1 <= x && x < x2) {
            this.clearKeyframeSelection();
            this.dragGestureEditor = new DragGestureLayerTimeShifter(e, this.pixelsToTime(x, frameDuration, this.zoom));
        } else if (layer instanceof MediaItemLayer && !LayerNature.isTimeRemapEnabled((Layer)layer)) {
            Time duration;
            MediaInput input = ((MediaItemLayer)layer).getMediaInput();
            if (input != null && (duration = input.getDuration()) != null) {
                Time startTime = layer.getStartTime();
                Time endTime = startTime.add(new Time((long)((double)duration.timeValue / Math.abs(layer.getRate())), duration.timeScale));
                x1 = this.timeToPixels(startTime, frameDuration, this.zoom);
                x2 = this.timeToPixels(endTime, frameDuration, this.zoom);
                if (x1 <= x && x < x2) {
                    this.dragGestureEditor = new DragGestureSlipEditor(e, this.pixelsToTime(x, frameDuration, this.zoom));
                }
            }
            if (this.dragGestureEditor == null) {
                this.clearKeyframeSelection();
            }
        } else {
            this.clearKeyframeSelection();
        }
    }

    public int drawKeyframes(Event e, AnimatableValue<?> avalue) {
        Time frameDuration = this.composition.getFrameDuration();
        int scroll = this.scrollSlider.getSelection();
        int ex = e.x;
        int y = e.y + e.height / 2 - 1;
        GC gc = e.gc;
        for (Keyframe kf : avalue.getKeyframes(this.fromTime, this.toTime)) {
            int x = ex + this.timeToPixels(kf.time, frameDuration, this.zoom) - scroll;
            Image icon = ImageUtil.getKeyframeIcon(kf.interpolation, this.keyframeSelection.containsKey(kf));
            if (icon != null) {
                gc.drawImage(icon, x - 5, y - 5);
                continue;
            }
            gc.setForeground(e.display.getSystemColor(2));
            gc.drawRectangle(x - 4, y - 4, 8, 8);
        }
        return y;
    }

    private Keyframe<?> findKeyframe(MouseEvent e, int yKeyframe, AnimatableValue<?> avalue) {
        if (e.y - 4 > yKeyframe || e.y + 4 < yKeyframe) {
            return null;
        }
        int x = e.x - this.timelineColumnX();
        int scroll = this.scrollSlider.getSelection();
        Time frameDuration = this.composition.getFrameDuration();
        Time time1 = this.pixelsToTime(x - 4 + scroll, frameDuration, this.zoom);
        Time time2 = this.pixelsToTime(x + 5 + scroll, frameDuration, this.zoom);
        SortedMap head = avalue.headKeyframeMap(time2);
        if (head.isEmpty()) {
            return null;
        }
        Keyframe kf = (Keyframe)head.get(head.lastKey());
        return time1.after(kf.time) ? null : kf;
    }

    public void mouseDown(MouseEvent e, int yKeyframe, AnimatableValueElement element, AnimatableValue<?> avalue) {
        Keyframe<?> kf = this.findKeyframe(e, yKeyframe, avalue);
        if (kf == null) {
            if (this.keyframeSelection.isEmpty()) {
                return;
            }
            this.keyframeSelection.clear();
        } else if (!this.keyframeSelection.containsKey(kf)) {
            if ((e.stateMask & 0x20000) != 131072) {
                this.keyframeSelection.clear();
            }
            this.keyframeSelection.put(kf, element);
        } else if (e.button == 1 && (e.stateMask & 0x20000) == 131072) {
            this.keyframeSelection.remove(kf);
        }
        this.redraw();
        if (kf != null && this.keyframeSelection.containsKey(kf) && e.button == 1 && this.dragGestureEditor == null) {
            this.dragGestureEditor = new DragGestureKeyframeShifter(e, kf.time);
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this.keyframeSelection.size() > 0 && e.x >= this.timelineColumnX()) {
            this.clearKeyframeSelection();
            this.redraw();
        }
    }

    public void clearKeyframeSelection() {
        this.keyframeSelection.clear();
    }

    public void addKeyframeSelection(Keyframe<?> keyframe, AnimatableValueElement element) {
        this.keyframeSelection.put(keyframe, element);
    }

    public boolean hasKeyframeSelection() {
        return this.keyframeSelection.size() > 0;
    }

    public Map<Keyframe<?>, AnimatableValueElement> getKeyframeSelection() {
        return Collections.unmodifiableMap(this.keyframeSelection);
    }

    private Object[][] createSelectedKeyframeData() {
        Object[][] data = new Object[this.keyframeSelection.size()][];
        int i = 0;
        for (Map.Entry<Keyframe<?>, AnimatableValueElement> e : this.keyframeSelection.entrySet()) {
            AnimatableValueElement avalueElem;
            Keyframe<?> kf = e.getKey();
            AnimatableValueElement element = e.getValue();
            if (element instanceof LayerAnimatableValueElement) {
                avalueElem = (LayerAnimatableValueElement)element;
                data[i++] = new Object[]{avalueElem.layer.getId(), -1, avalueElem.property, kf};
                continue;
            }
            avalueElem = (EffectAnimatableValueElement)element;
            data[i++] = new Object[]{((EffectAnimatableValueElement)avalueElem).layer.getId(), ((EffectAnimatableValueElement)avalueElem).layer.getEffects().indexOf(((EffectAnimatableValueElement)avalueElem).effect), ((EffectAnimatableValueElement)avalueElem).descriptor.getName(), kf};
        }
        return data;
    }

    private String[] createBaseAnimatableValues(Object[][] keyframeData) {
        Map map = Util.newMap();
        AnimatableValue[] baseAvalues = new AnimatableValue[keyframeData.length];
        int i = 0;
        int n = keyframeData.length;
        while (i < n) {
            AnimatableValue avalue;
            Layer layer = this.composition.getLayer((String)keyframeData[i][0]);
            Integer effectIndex = (Integer)keyframeData[i][1];
            String property = (String)keyframeData[i][2];
            Keyframe kf = (Keyframe)keyframeData[i][3];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            AnimatableValue baseAvalue = (AnimatableValue)map.get(avalue);
            if (baseAvalue == null) {
                String s = this._encoder.encodeElement((Object)avalue);
                try {
                    baseAvalue = (AnimatableValue)this._decoder.decodeElement((CharSequence)s, avalue.getClass());
                }
                catch (ProjectDecodeException e) {
                    throw new JavieRuntimeException((Throwable)e);
                }
                map.put(avalue, baseAvalue);
                baseAvalues[i] = baseAvalue;
            }
            baseAvalue.removeKeyframe(kf.time);
            ++i;
        }
        String[] encodedBaseAvalues = new String[baseAvalues.length];
        int i2 = 0;
        int n2 = baseAvalues.length;
        while (i2 < n2) {
            if (baseAvalues[i2] != null) {
                encodedBaseAvalues[i2] = this._encoder.encodeElement((Object)baseAvalues[i2]);
            }
            ++i2;
        }
        return encodedBaseAvalues;
    }

    public void removeSelectedKeyframes() {
        this.projectManager.postOperation(new RemoveKeyframesOperation(this.projectManager, this.composition, this.createSelectedKeyframeData()));
    }

    public void modifySelectedKeyframeInterpolation(Interpolation newInterpolation) {
        this.projectManager.postOperation(new ModifyKeyframeInterpolationOperation(this.projectManager, this.composition, this.createSelectedKeyframeData(), newInterpolation));
    }

    public void setWrapMode(boolean wrapMode) {
        this.wrapMode = wrapMode;
    }

    public Time getCurrentTime() {
        return this.currentTime;
    }

    private static int getCocoaCurrentButtonState() {
        try {
            if (cocoaGetCurrentButtonStateMethod == null) {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.OS");
                cocoaGetCurrentButtonStateMethod = clazz.getMethod("GetCurrentButtonState", new Class[0]);
            }
            return (Integer)cocoaGetCurrentButtonStateMethod.invoke(null, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private abstract class AbstractDragGestureEditor {
        private final Time baseTime;
        private final String relation = Util.randomId();
        private final long downTime;
        private final int downX;
        private boolean dragDetected;
        private Time prevTime;

        private AbstractDragGestureEditor(MouseEvent event, Time baseTime) {
            Time frameDuration = TimelineManager.this.composition.getFrameDuration();
            this.baseTime = this.prevTime = Time.fromFrameNumber((long)baseTime.toFrameNumber(frameDuration), (Time)frameDuration);
            Control control = (Control)event.widget;
            this.downTime = System.currentTimeMillis();
            this.downX = event.x;
            this.init(control);
        }

        private void init(final Control control) {
            final Display display = control.getDisplay();
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    switch (e.type) {
                        case 5: {
                            if (!control.isDisposed()) {
                                if (COCOA && (TimelineManager.getCocoaCurrentButtonState() & 1) == 0) break;
                                int x = control.toControl((Point)display.getCursorLocation()).x;
                                if (!AbstractDragGestureEditor.this.dragDetected) {
                                    AbstractDragGestureEditor.this.dragDetected = System.currentTimeMillis() - AbstractDragGestureEditor.this.downTime > 100L && Math.abs(x - AbstractDragGestureEditor.this.downX) > 3;
                                }
                                if (!AbstractDragGestureEditor.this.dragDetected) break;
                                AbstractDragGestureEditor.this.drag(x);
                                break;
                            }
                        }
                        case 4: 
                        case 27: {
                            TimelineManager.this.dragGestureEditor = null;
                            display.removeFilter(5, (Listener)this);
                            display.removeFilter(4, (Listener)this);
                            display.removeFilter(27, (Listener)this);
                        }
                    }
                }
            };
            display.addFilter(5, listener);
            display.addFilter(4, listener);
            display.addFilter(27, listener);
        }

        private void drag(int x) {
            Time frameDuration = TimelineManager.this.composition.getFrameDuration();
            Time time = TimelineManager.this.pixelsToTime(x - TimelineManager.this.timelineColumnX() + TimelineManager.this.scrollSlider.getSelection(), frameDuration, TimelineManager.this.zoom);
            if (!(time = Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration)).equals((Object)this.prevTime)) {
                TimelineManager.this.projectManager.postOperation(this.createOperation(time, this.prevTime, this.baseTime, this.relation));
                this.prevTime = time;
            }
        }

        protected abstract ProjectOperation createOperation(Time var1, Time var2, Time var3, String var4);
    }

    private class DragGestureInPointShifter
    extends AbstractDragGestureEditor {
        private final Object[][] layersAndInPoints;

        private DragGestureInPointShifter(MouseEvent event, Time baseTime) {
            super(event, baseTime);
            this.layersAndInPoints = this.getLayersAndInPoints();
        }

        private Object[][] getLayersAndInPoints() {
            List list = Util.newList();
            TreeItem[] treeItemArray = TimelineManager.this.timelineColumn.getParent().getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Object element = treeItem.getData();
                if (element instanceof LayerElement) {
                    Layer layer = ((LayerElement)element).layer;
                    list.add(new Object[]{layer, layer.getInPoint()});
                }
                ++n2;
            }
            return (Object[][])list.toArray((T[])new Object[list.size()][]);
        }

        protected ProjectOperation createOperation(Time time, Time prevTime, Time baseTime, String relation) {
            return new ModifyLayerInPointOperation(TimelineManager.this.projectManager, TimelineManager.this.composition, this.layersAndInPoints, time.subtract(baseTime), relation);
        }
    }

    private class DragGestureKeyframeShifter
    extends AbstractDragGestureEditor {
        private final Object[][] selectedKeyframeData;
        private final String[] baseAnimatableValues;

        private DragGestureKeyframeShifter(MouseEvent event, Time baseTime) {
            super(event, baseTime);
            this.selectedKeyframeData = TimelineManager.this.createSelectedKeyframeData();
            this.baseAnimatableValues = TimelineManager.this.createBaseAnimatableValues(this.selectedKeyframeData);
        }

        protected ProjectOperation createOperation(Time time, Time prevTime, Time baseTime, String relation) {
            return new ShiftKeyframesOperation(TimelineManager.this.projectManager, TimelineManager.this.composition, this.selectedKeyframeData, this.baseAnimatableValues, time.subtract(baseTime), relation);
        }
    }

    private class DragGestureLayerTimeShifter
    extends AbstractDragGestureEditor {
        private final List<Layer> layers;

        private DragGestureLayerTimeShifter(MouseEvent event, Time baseTime) {
            super(event, baseTime);
            this.layers = Util.newList();
            TreeItem[] treeItemArray = TimelineManager.this.timelineColumn.getParent().getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Object element = treeItem.getData();
                if (element instanceof LayerElement) {
                    this.layers.add(((LayerElement)element).layer);
                }
                ++n2;
            }
        }

        protected ProjectOperation createOperation(Time time, Time prevTime, Time baseTime, String relation) {
            return new ShiftLayerTimesOperation(TimelineManager.this.projectManager, TimelineManager.this.composition, this.layers, time.subtract(prevTime), relation);
        }
    }

    private class DragGestureOutPointShifter
    extends AbstractDragGestureEditor {
        private final Object[][] layersAndOutPoints;

        private DragGestureOutPointShifter(MouseEvent event, Time baseTime) {
            super(event, baseTime);
            this.layersAndOutPoints = this.getLayersAndOutPoints();
        }

        private Object[][] getLayersAndOutPoints() {
            List list = Util.newList();
            TreeItem[] treeItemArray = TimelineManager.this.timelineColumn.getParent().getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Object element = treeItem.getData();
                if (element instanceof LayerElement) {
                    Layer layer = ((LayerElement)element).layer;
                    list.add(new Object[]{layer, layer.getOutPoint()});
                }
                ++n2;
            }
            return (Object[][])list.toArray((T[])new Object[list.size()][]);
        }

        protected ProjectOperation createOperation(Time time, Time prevTime, Time baseTime, String relation) {
            return new ModifyLayerOutPointOperation(TimelineManager.this.projectManager, TimelineManager.this.composition, this.layersAndOutPoints, time.subtract(baseTime), relation);
        }
    }

    private class DragGestureSlipEditor
    extends AbstractDragGestureEditor {
        private final Object[][] layersAndStartTimes;
        private final Object[][] selectedKeyframeData;
        private final String[] baseAnimatableValues;

        private DragGestureSlipEditor(MouseEvent event, Time baseTime) {
            super(event, baseTime);
            this.layersAndStartTimes = this.getLayersAndStartTimes();
            this.selectedKeyframeData = TimelineManager.this.createSelectedKeyframeData();
            this.baseAnimatableValues = TimelineManager.this.createBaseAnimatableValues(this.selectedKeyframeData);
        }

        private Object[][] getLayersAndStartTimes() {
            List list = Util.newList();
            TreeItem[] treeItemArray = TimelineManager.this.timelineColumn.getParent().getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Object element = treeItem.getData();
                if (element instanceof LayerElement) {
                    Layer layer = ((LayerElement)element).layer;
                    list.add(new Object[]{layer, layer.getStartTime()});
                }
                ++n2;
            }
            return (Object[][])list.toArray((T[])new Object[list.size()][]);
        }

        protected ProjectOperation createOperation(Time time, Time prevTime, Time baseTime, String relation) {
            return new LayerSlipOperation(TimelineManager.this.projectManager, TimelineManager.this.composition, this.layersAndStartTimes, this.selectedKeyframeData, this.baseAnimatableValues, time.subtract(baseTime), relation);
        }
    }
}

