/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Expressionee;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.Util;
import net.arnx.jsonic.JSONHint;

public abstract class AbstractLayer
implements Layer {
    private String _id;
    private String _parentId;
    private Layer _parent;
    private String _name = "\u540d\u79f0\u672a\u8a2d\u5b9a\u30ec\u30a4\u30e4\u30fc";
    private boolean _shy;
    private Time _startTime;
    private Time _inPoint;
    private Time _outPoint;
    private double _rate = 1.0;

    public void initialize() {
        this._id = Util.randomId();
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getParentId() {
        return this._parentId;
    }

    public void setParentId(String parentId) {
        this._parentId = parentId;
    }

    @JSONHint(ignore=true)
    public Layer getParent() {
        return this._parent;
    }

    @JSONHint(ignore=true)
    public void setParent(Layer parent) {
        this._parentId = parent != null ? parent.getId() : null;
        this._parent = parent;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean isShy() {
        return this._shy;
    }

    public void setShy(boolean shy) {
        this._shy = shy;
    }

    public Time getStartTime() {
        return this._startTime;
    }

    public void setStartTime(Time startTime) {
        this._startTime = startTime;
    }

    public Time getInPoint() {
        return this._inPoint;
    }

    public void setInPoint(Time inPoint) {
        this._inPoint = inPoint;
    }

    public Time getOutPoint() {
        return this._outPoint;
    }

    public void setOutPoint(Time outPoint) {
        this._outPoint = outPoint;
    }

    public double getRate() {
        return this._rate;
    }

    public void setRate(double rate) {
        this._rate = rate;
    }

    public void afterDecode(Project p, LayerComposition c) throws ProjectDecodeException {
        if (this._parentId != null) {
            this._parent = c.getLayer(this._parentId);
            if (this._parent == null) {
                throw new ProjectDecodeException("no such parent layer found: id=" + this._parentId);
            }
        }
    }

    public void prepareExpression(ExpressionScope scope) {
        scope.setThis(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LayerExpressionElement {
        protected final RenderContext renderContext;

        public LayerExpressionElement(RenderContext renderContext) {
            this.renderContext = renderContext;
        }

        protected <T> T elem(Expressionee exprnee) {
            return this.renderContext.getExpressionElement(exprnee);
        }

        public LayerExpressionElement getThisLayer() {
            return this;
        }

        public double getStartTime() {
            return AbstractLayer.this._startTime.toSecond();
        }

        public double getInPoint() {
            return AbstractLayer.this._inPoint.toSecond();
        }

        public double getOutPoint() {
            return AbstractLayer.this._outPoint.toSecond();
        }

        public double getRate() {
            return AbstractLayer.this._rate;
        }
    }
}

