/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core;

import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.core.ArithmeticalAnimatableValue;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.RenderContext;
import ch.kuramo.javie.core.exprelems.DoubleProperty;
import java.util.Collection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableVec2d
extends ArithmeticalAnimatableValue<Vec2d>
implements IAnimatableVec2d {
    public AnimatableVec2d(Vec2d staticValue, Collection<Keyframe<Vec2d>> keyframes, String expression) {
        super(staticValue, keyframes, expression, Vec2d.NEGATIVE_INFINITY, Vec2d.POSITIVE_INFINITY);
    }

    public AnimatableVec2d(Vec2d defaultValue) {
        super(defaultValue, Vec2d.NEGATIVE_INFINITY, Vec2d.POSITIVE_INFINITY);
    }

    public AnimatableVec2d(Vec2d defaultValue, Vec2d minValue, Vec2d maxValue) {
        super(defaultValue, minValue, maxValue);
    }

    @Override
    public Vec2d clamp(Vec2d value) {
        return Vec2d.min((Vec2d)Vec2d.max((Vec2d)value, (Vec2d)((Vec2d)this._minValue)), (Vec2d)((Vec2d)this._maxValue));
    }

    @Override
    public Vec2d jsToJava(Object jsValue) {
        if (jsValue instanceof NativeJavaArray) {
            Object[] value = (Object[])((NativeJavaArray)jsValue).unwrap();
            double[] array = new double[2];
            int i = 0;
            int n = Math.min(2, value.length);
            while (i < n) {
                array[i] = (Double)Context.jsToJava((Object)value[i], Double.TYPE);
                ++i;
            }
            return this.valueOf(array);
        }
        double[] array = (double[])Context.jsToJava((Object)jsValue, double[].class);
        if (array.length < 2) {
            double[] tmp = array;
            array = new double[2];
            int i = 0;
            while (i < tmp.length) {
                array[i] = tmp[i];
                ++i;
            }
        }
        return this.valueOf(array);
    }

    @Override
    protected double[] toArray(Vec2d value) {
        return new double[]{value.x, value.y};
    }

    @Override
    protected Vec2d valueOf(double[] d) {
        return new Vec2d(d[0], d[1]);
    }

    public Scriptable[] createExpressionElement(final RenderContext renderContext) {
        DoubleProperty x = new DoubleProperty(){

            public double getValue() {
                return ((Vec2d)AnimatableVec2d.this.value((RenderContext)renderContext)).x;
            }

            public double valueAtTime(double t) {
                return ((Vec2d)AnimatableVec2d.this.valueAtTime((double)t, (RenderContext)renderContext)).x;
            }
        };
        DoubleProperty y = new DoubleProperty(){

            public double getValue() {
                return ((Vec2d)AnimatableVec2d.this.value((RenderContext)renderContext)).y;
            }

            public double valueAtTime(double t) {
                return ((Vec2d)AnimatableVec2d.this.valueAtTime((double)t, (RenderContext)renderContext)).y;
            }
        };
        return new Scriptable[]{renderContext.toNativeJavaObject(x, ScriptRuntime.NumberClass), renderContext.toNativeJavaObject(y, ScriptRuntime.NumberClass)};
    }
}

