/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AudioBuffer;
import ch.kuramo.javie.core.MediaFileInput;
import ch.kuramo.javie.core.VideoBuffer;
import ch.kuramo.javie.core.internal.MacOSXOpenGLPixelFormat;
import ch.kuramo.javie.core.services.AudioRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.SynchronousTaskThread;
import ch.kuramo.javie.core.services.VideoRenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacOSXQTCoreVideoInput
implements MediaFileInput {
    private static final Logger _logger = LoggerFactory.getLogger(MacOSXQTCoreVideoInput.class);
    private GLContext _glContext;
    private int _fboId;
    private long _videoInput;
    private long _audioInput;
    private VideoBounds _bounds;
    private Time _duration;
    private Time _videoFrameDuration;
    private AudioMode _audioMode;
    @Inject
    private SynchronousTaskThread _videoThread;
    @Inject
    private SynchronousTaskThread _audioThread;
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private VideoRenderContext _vrContext;
    @Inject
    private VideoRenderSupport _vrSupport;
    @Inject
    private AudioRenderSupport _arSupport;

    static {
        System.loadLibrary("QTCoreVideoInput");
    }

    public boolean initialize(final File file) {
        this._videoThread.start();
        this._videoThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                MacOSXQTCoreVideoInput.this.initializeVideo(file);
            }
        });
        if (this._videoInput == 0L) {
            this.disposeVideo();
        }
        this._audioThread.start();
        this._audioThread.invoke(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                MacOSXQTCoreVideoInput.this.initializeAudio(file);
            }
        });
        if (this._audioInput == 0L) {
            this.disposeAudio();
        }
        return this._videoInput != 0L || this._audioInput != 0L;
    }

    private void initializeVideo(File file) {
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            this._glContext = this._glGlobal.createContext();
            this._glContext.makeCurrent();
        }
        finally {
            lock.unlock();
        }
        GL2 gl = this._glContext.getGL().getGL2();
        int[] fboId = new int[1];
        gl.glGenBuffers(1, fboId, 0);
        this._fboId = fboId[0];
        gl.glBindFramebuffer(36160, this._fboId);
        long pixelFormat = MacOSXOpenGLPixelFormat.createPixelFormat(this._glContext);
        long[] result = this.openVideo(file.getAbsolutePath(), pixelFormat);
        MacOSXOpenGLPixelFormat.deletePixelFormat(pixelFormat);
        if (result != null) {
            this._videoInput = result[0];
            this._bounds = new VideoBounds((int)result[1], (int)result[2]);
            this._duration = new Time(result[4], (int)result[5]);
            this._videoFrameDuration = new Time(result[4] / result[3], (int)result[5]);
            this._videoThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Video): " + file.getName());
        }
    }

    private void initializeAudio(File file) {
        long[] result = this.openAudio(file.getAbsolutePath());
        if (result != null) {
            this._audioInput = result[0];
            if (this._duration == null) {
                this._duration = new Time(result[2], (int)result[3]);
            }
            this._audioThread.setName(String.valueOf(this.getClass().getSimpleName()) + " (Audio): " + file.getName());
        }
    }

    public void dispose() {
        this.disposeVideo();
        this.disposeAudio();
    }

    private void disposeVideo() {
        this._videoThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (MacOSXQTCoreVideoInput.this._videoInput != 0L) {
                    MacOSXQTCoreVideoInput.this.closeVideo(MacOSXQTCoreVideoInput.this._videoInput);
                    MacOSXQTCoreVideoInput.this._videoInput = 0L;
                    MacOSXQTCoreVideoInput.this._bounds = null;
                }
                if (MacOSXQTCoreVideoInput.this._glContext != null) {
                    GL2 gl = MacOSXQTCoreVideoInput.this._glContext.getGL().getGL2();
                    gl.glBindFramebuffer(36160, 0);
                    gl.glDeleteBuffers(1, new int[]{MacOSXQTCoreVideoInput.this._fboId}, 0);
                    MacOSXQTCoreVideoInput.this._fboId = 0;
                    ReentrantLock lock = MacOSXQTCoreVideoInput.this._glGlobal.getGlobalLock();
                    lock.lock();
                    try {
                        MacOSXQTCoreVideoInput.this._glContext.release();
                        MacOSXQTCoreVideoInput.this._glGlobal.destroyContext(MacOSXQTCoreVideoInput.this._glContext);
                    }
                    finally {
                        lock.unlock();
                    }
                    MacOSXQTCoreVideoInput.this._glContext = null;
                }
            }
        });
    }

    private void disposeAudio() {
        this._audioThread.exit(new SynchronousTaskThread.TaskWithoutResult(){

            protected void runWithoutResult() {
                if (MacOSXQTCoreVideoInput.this._audioInput != 0L) {
                    MacOSXQTCoreVideoInput.this.closeAudio(MacOSXQTCoreVideoInput.this._audioInput);
                    MacOSXQTCoreVideoInput.this._audioInput = 0L;
                    MacOSXQTCoreVideoInput.this._audioMode = null;
                }
            }
        });
    }

    public boolean isVideoAvailable() {
        return this._videoInput != 0L;
    }

    public boolean isAudioAvailable() {
        return this._audioInput != 0L;
    }

    public Time getDuration() {
        return this._duration;
    }

    public Time getVideoFrameDuration() {
        return this._videoFrameDuration;
    }

    public VideoBounds getVideoFrameBounds() {
        return this._bounds;
    }

    public VideoBuffer getVideoFrameImage(Time mediaTime) {
        if (this._videoInput == 0L) {
            return null;
        }
        final VideoBounds bounds = this._vrContext.getRenderResolution().scale(this._bounds);
        VideoBuffer vb = this._vrSupport.createVideoBuffer(this._vrContext.getColorMode(), bounds);
        vb.allocateAsTexture();
        if (mediaTime.timeValue < 0L || !mediaTime.before(this._duration)) {
            this._vrSupport.clear(vb);
            return vb;
        }
        Time time = Time.fromFrameNumber((long)mediaTime.toFrameNumber(this._videoFrameDuration), (Time)this._videoFrameDuration);
        final long timeValue = time.timeValue + this._videoFrameDuration.timeValue / 2L;
        final int timeScale = time.timeScale;
        final int texture = vb.getTexture();
        int error = this._videoThread.invoke(new SynchronousTaskThread.Task<Integer>(){

            @Override
            public Integer run() throws Exception {
                int error = MacOSXQTCoreVideoInput.this.frameImageAtTime(MacOSXQTCoreVideoInput.this._videoInput, timeValue, timeScale, texture, bounds.width, bounds.height);
                if (error != 0) {
                    _logger.error("frameImageAtTime: error " + error);
                }
                return error;
            }
        });
        if (error == 0) {
            return vb;
        }
        vb.dispose();
        return null;
    }

    public AudioBuffer getAudioChunk(Time mediaTime) {
        int offset;
        long frameNumber;
        if (this._audioInput == 0L) {
            return null;
        }
        final AudioBuffer ab = this._arSupport.createAudioBuffer();
        final AudioMode am = ab.getAudioMode();
        long fn = mediaTime.toFrameNumber(am.sampleDuration);
        if (-fn >= (long)ab.getFrameCount() || !mediaTime.before(this._duration)) {
            this._arSupport.clear(ab);
            return ab;
        }
        if (fn >= 0L) {
            frameNumber = fn;
            offset = 0;
        } else {
            frameNumber = 0L;
            offset = (int)(-fn);
            this._arSupport.clear(ab, 0, offset);
        }
        int error = this._audioThread.invoke(new SynchronousTaskThread.Task<Integer>(){

            @Override
            public Integer run() throws Exception {
                int error;
                if (am != MacOSXQTCoreVideoInput.this._audioMode) {
                    error = MacOSXQTCoreVideoInput.this.setAudioDescription(MacOSXQTCoreVideoInput.this._audioInput, am.channels, am.sampleRate, am.sampleSize, am.dataType == AudioMode.DataType.FLOAT);
                    if (error != 0) {
                        _logger.error("setAudioDescription: error " + error);
                        return error;
                    }
                    MacOSXQTCoreVideoInput.this._audioMode = am;
                }
                if ((error = MacOSXQTCoreVideoInput.this.audioChunkFromTime(MacOSXQTCoreVideoInput.this._audioInput, frameNumber, am.sampleRate, ab.getData(), offset, ab.getFrameCount() - offset)) != 0) {
                    _logger.error("audioChunkFromTime: error " + error);
                }
                return error;
            }
        });
        if (error == 0) {
            return ab;
        }
        ab.dispose();
        return null;
    }

    private native long[] openVideo(String var1, long var2);

    private native long[] openAudio(String var1);

    private native void closeVideo(long var1);

    private native void closeAudio(long var1);

    private native int frameImageAtTime(long var1, long var3, int var5, int var6, int var7, int var8);

    private native int setAudioDescription(long var1, int var3, int var4, int var5, boolean var6);

    private native int audioChunkFromTime(long var1, long var3, int var5, Object var6, int var7, int var8);
}

