/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.AbstractRenderContext;
import ch.kuramo.javie.core.services.AudioRenderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioRenderContextImpl
extends AbstractRenderContext
implements AudioRenderContext {
    private AudioMode _audioMode;
    private int _frameCount;
    private int _evalResolution;

    @Override
    public void deactivate() {
        this._audioMode = null;
        this._frameCount = 0;
        this._evalResolution = 0;
        super.deactivate();
    }

    @Override
    public void reset() {
        super.reset();
        this._audioMode = null;
        this._frameCount = 0;
        this._evalResolution = 0;
    }

    @Override
    public <T> T saveAndExecute(WrappedOperation<T> operation) {
        int frameCount = this._frameCount;
        try {
            T t = super.saveAndExecute(operation);
            return t;
        }
        finally {
            this._frameCount = frameCount;
        }
    }

    @Override
    public AudioMode getAudioMode() {
        if (this._audioMode == null) {
            throw new IllegalStateException("audioMode is not set.");
        }
        return this._audioMode;
    }

    @Override
    public void setAudioMode(AudioMode audioMode) {
        if (this._audioMode != null) {
            throw new IllegalStateException("audioMode has already been set.");
        }
        this._audioMode = audioMode;
    }

    @Override
    public int getFrameCount() {
        return this._frameCount;
    }

    @Override
    public void setFrameCount(int count) {
        this._frameCount = count;
    }

    @Override
    public int getEvaluationResolution() {
        if (this._evalResolution == 0) {
            throw new IllegalStateException("evaluationResolution is not set.");
        }
        return this._evalResolution;
    }

    @Override
    public void setEvaluationResolution(int resolution) {
        if (this._evalResolution != 0) {
            throw new IllegalStateException("evaluationResolution has already been set.");
        }
        if (resolution < 1) {
            throw new IllegalArgumentException();
        }
        this._evalResolution = resolution;
    }
}

