/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IShaderSourceFactory;
import ch.kuramo.javie.api.ShaderType;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ShaderRegistry;
import ch.kuramo.javie.core.services.ShaderRegistryException;
import ch.kuramo.javie.core.services.VideoRenderContext;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.scannotation.AnnotationDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderRegistryImpl
implements ShaderRegistry,
IShaderRegistry {
    private final Map<String, ShaderEntry> _entries = Util.newMap();
    @Inject
    private Injector _injector;
    @Inject
    private VideoRenderContext _vrContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEntry(String name, ShaderEntry entry) throws ShaderRegistryException {
        Map<String, ShaderEntry> map = this._entries;
        synchronized (map) {
            if (this._entries.containsKey(name)) {
                throw new ShaderRegistryException(name, "Same name shader already exists.");
            }
            this._entries.put(name, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderEntry getEntry(String name) {
        Map<String, ShaderEntry> map = this._entries;
        synchronized (map) {
            return this._entries.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShaderEntry getEntry(IShaderSourceFactory sourceFactory) {
        String name = sourceFactory.getName();
        Map<String, ShaderEntry> map = this._entries;
        synchronized (map) {
            ShaderEntry entry = this.getEntry(name);
            if (entry == null) {
                String[] attach = null;
                if (sourceFactory.isProgram() && (attach = sourceFactory.getAttach()) == null) {
                    attach = new String[]{};
                }
                entry = new ShaderEntry(name, sourceFactory.getType(), attach, sourceFactory.getSource());
                try {
                    this.putEntry(name, entry);
                }
                catch (ShaderRegistryException e) {
                    throw new JavieRuntimeException(e);
                }
            }
            return entry;
        }
    }

    private String fqfn(Class<?> clazz, String name) {
        return String.valueOf(clazz.getName()) + "." + name;
    }

    private String fqfn(Field field) {
        return this.fqfn(field.getDeclaringClass(), field.getName());
    }

    public IShaderProgram getProgram(String name) {
        ShaderEntry entry = this.getEntry(name);
        return entry != null ? entry.shaderProgram : null;
    }

    public IShaderProgram getProgram(Class<?> clazz, String name) {
        return this.getProgram(this.fqfn(clazz, name));
    }

    public IShaderProgram getProgram(IShaderSourceFactory sourceFactory) {
        if (!sourceFactory.isProgram()) {
            throw new IllegalArgumentException("must be program");
        }
        return this.getEntry(sourceFactory).shaderProgram;
    }

    public void addShader(IShaderSourceFactory sourceFactory) {
        this.getEntry(sourceFactory);
    }

    @Override
    public void scanShaders(AnnotationDB db, ClassLoader cl) throws ShaderRegistryException {
        HashSet classNames = new HashSet();
        Util.addAll((Collection)db.getAnnotationIndex().get(ShaderSource.class.getName()), classNames);
        for (String className : classNames) {
            Class<?> clazz;
            try {
                clazz = Class.forName(className, true, cl);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            Object obj = null;
            Field[] fieldArray = clazz.getFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                ShaderSource sourceAnno = null;
                Annotation[] annotationArray = field.getAnnotations();
                int n3 = annotationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation fieldAnno = annotationArray[n4];
                    if (fieldAnno instanceof ShaderSource) {
                        sourceAnno = (ShaderSource)fieldAnno;
                    }
                    ++n4;
                }
                if (sourceAnno != null) {
                    String[] source;
                    if (Modifier.isStatic(field.getModifiers())) {
                        source = this.getSource(null, field);
                    } else {
                        if (obj == null) {
                            try {
                                obj = this._injector.getInstance(clazz);
                            }
                            catch (Exception e) {
                                throw new ShaderRegistryException(this.fqfn(field), e);
                            }
                        }
                        source = this.getSource(obj, field);
                    }
                    String[] attach = null;
                    if (sourceAnno.program()) {
                        attach = (String[])sourceAnno.attach().clone();
                        int i = 0;
                        while (i < attach.length) {
                            if (attach[i].indexOf(46) == -1) {
                                attach[i] = this.fqfn(field.getDeclaringClass(), attach[i]);
                            }
                            ++i;
                        }
                    } else if (sourceAnno.attach().length > 0) {
                        throw new ShaderRegistryException(this.fqfn(field), "'attach' must be empty when 'program' is false");
                    }
                    String name = this.fqfn(field);
                    ShaderEntry entry = new ShaderEntry(name, sourceAnno.type(), attach, source);
                    this.putEntry(name, entry);
                }
                ++n2;
            }
        }
    }

    private String[] getSource(Object obj, Field field) throws ShaderRegistryException {
        String[] source;
        Object fieldValue;
        try {
            fieldValue = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new ShaderRegistryException(this.fqfn(field), e);
        }
        Class<?> fieldType = field.getType();
        if (fieldType == String[].class) {
            source = (String[])fieldValue;
        } else {
            if (fieldType == String.class) {
                InputStream in = field.getDeclaringClass().getResourceAsStream((String)fieldValue);
                if (in == null) {
                    throw new ShaderRegistryException(this.fqfn(field), "no such resource found: " + fieldValue);
                }
                try {
                    ArrayList<String> lines = new ArrayList<String>();
                    BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            lines.add(line);
                        }
                    }
                    finally {
                        br.close();
                    }
                    source = lines.toArray(new String[lines.size()]);
                }
                catch (IOException e) {
                    throw new ShaderRegistryException(this.fqfn(field), e);
                }
            }
            throw new ShaderRegistryException(this.fqfn(field), "Only String or String[] is allowed to the field type of ShaderSource.");
        }
        if (source == null || source.length == 0) {
            throw new ShaderRegistryException(this.fqfn(field), "Source is null or empty.");
        }
        int i = 0;
        while (i < source.length) {
            if (!source[i].endsWith("\n")) {
                int n = i;
                source[n] = String.valueOf(source[n]) + "\n";
            }
            ++i;
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void build(GL2 gl, ShaderEntry entry) throws ShaderRegistryException {
        int type;
        if (entry.shader != 0) {
            throw new IllegalArgumentException("the entry is already built");
        }
        switch (entry.shaderType) {
            case VERTEX_SHADER: {
                type = 35633;
                break;
            }
            case FRAGMENT_SHADER: {
                type = 35632;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported ShaderType: " + entry.shaderType);
            }
        }
        int shader = this.compile(gl, type, entry.source, entry.name);
        if (entry.attach == null) {
            entry.built(shader, 0, null);
            return;
        }
        int program = 0;
        try {
            String infoLog;
            program = gl.glCreateProgram();
            if (program == 0) {
                throw new ShaderRegistryException(entry.name, "glCreateProgram failed.");
            }
            gl.glAttachShader(program, shader);
            String[] stringArray = entry.attach;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attach = stringArray[n2];
                ShaderEntry attachEntry = this.getEntry(attach);
                if (attachEntry == null) {
                    throw new ShaderRegistryException(entry.name, "no such shader found: " + attach);
                }
                ShaderEntry shaderEntry = attachEntry;
                synchronized (shaderEntry) {
                    if (attachEntry.shader == 0) {
                        this.build(gl, attachEntry);
                    }
                }
                gl.glAttachShader(program, attachEntry.shader);
                ++n2;
            }
            gl.glLinkProgram(program);
            int[] status = new int[1];
            gl.glGetProgramiv(program, 35714, status, 0);
            if (status[0] == 1) {
                entry.built(shader, program, this.getUniforms(gl, program, entry.name));
                shader = 0;
                program = 0;
                return;
            }
            int[] length = new int[1];
            gl.glGetProgramiv(program, 35716, length, 0);
            byte[] infoLogBuf = new byte[length[0]];
            gl.glGetProgramInfoLog(program, length[0], length, 0, infoLogBuf, 0);
            try {
                infoLog = new String(infoLogBuf, 0, length[0], "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                infoLog = new String(infoLogBuf, 0, length[0]);
            }
            throw new ShaderRegistryException(entry.name, "link failed: " + infoLog);
        }
        finally {
            if (program != 0) {
                gl.glDeleteProgram(program);
            }
            if (shader != 0) {
                gl.glDeleteShader(shader);
            }
        }
    }

    private int compile(GL2 gl, int type, String[] source, String shaderName) throws ShaderRegistryException {
        String infoLog;
        int shader = gl.glCreateShader(type);
        if (shader == 0) {
            throw new ShaderRegistryException(shaderName, "glCreateShader failed.");
        }
        gl.glShaderSource(shader, source.length, source, null, 0);
        gl.glCompileShader(shader);
        int[] status = new int[1];
        gl.glGetShaderiv(shader, 35713, status, 0);
        if (status[0] == 1) {
            return shader;
        }
        int[] length = new int[1];
        gl.glGetShaderiv(shader, 35716, length, 0);
        byte[] infoLogBuf = new byte[length[0]];
        gl.glGetShaderInfoLog(shader, length[0], length, 0, infoLogBuf, 0);
        gl.glDeleteShader(shader);
        try {
            infoLog = new String(infoLogBuf, 0, length[0], "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            infoLog = new String(infoLogBuf, 0, length[0]);
        }
        throw new ShaderRegistryException(shaderName, "compile failed: " + infoLog);
    }

    private Map<String, Uniform> getUniforms(GL2 gl, int program, String programName) throws ShaderRegistryException {
        HashMap<String, Uniform> map = new HashMap<String, Uniform>();
        int[] int3 = new int[3];
        gl.glGetProgramiv(program, 35718, int3, 0);
        int activeUniforms = int3[0];
        gl.glGetProgramiv(program, 35719, int3, 0);
        int bufSize = int3[0];
        byte[] nameBuf = new byte[bufSize];
        int i = 0;
        while (i < activeUniforms) {
            String name;
            gl.glGetActiveUniform(program, i, bufSize, int3, 0, int3, 1, int3, 2, nameBuf, 0);
            int error = gl.glGetError();
            if (error != 0) {
                throw new ShaderRegistryException(programName, "glGetActiveUniform failed: " + GLU.createGLU((GL)gl).gluErrorString(error));
            }
            try {
                name = new String(nameBuf, 0, int3[0], "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                name = new String(nameBuf, 0, int3[0]);
            }
            int location = gl.glGetUniformLocation(program, name);
            map.put(name, new Uniform(location, int3[1], int3[2]));
            ++i;
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShaderEntry {
        private final String name;
        private final ShaderType shaderType;
        private String[] attach;
        private String[] source;
        private volatile int shader;
        private volatile int program;
        private Map<String, Uniform> uniforms;
        private final IShaderProgram shaderProgram;

        private ShaderEntry(String name, ShaderType shaderType, String[] attach, String[] source) {
            this.name = name;
            this.shaderType = shaderType;
            this.attach = attach;
            this.source = source;
            this.shaderProgram = attach != null ? this.createShaderProgramImpl() : null;
        }

        private void built(int shader, int program, Map<String, Uniform> uniforms) {
            this.shader = shader;
            this.program = program;
            this.uniforms = uniforms;
            this.attach = null;
            this.source = null;
        }

        private IShaderProgram createShaderProgramImpl() {
            return new IShaderProgram(){

                public String getName() {
                    return ShaderEntry.this.name;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void useProgram(Runnable r) {
                    GL2 gl = ShaderRegistryImpl.this._vrContext.getGL().getGL2();
                    ShaderEntry shaderEntry = ShaderEntry.this;
                    synchronized (shaderEntry) {
                        if (ShaderEntry.this.program == 0) {
                            try {
                                ShaderRegistryImpl.this.build(gl, ShaderEntry.this);
                            }
                            catch (ShaderRegistryException e) {
                                throw new JavieRuntimeException(e);
                            }
                        }
                        try {
                            gl.glUseProgram(ShaderEntry.this.program);
                            r.run();
                            gl.glFinish();
                        }
                        finally {
                            gl.glUseProgram(0);
                        }
                    }
                }

                public int getUniformLocation(String uniformName) {
                    if (ShaderEntry.this.program == 0) {
                        throw new IllegalStateException();
                    }
                    Uniform uniform = (Uniform)ShaderEntry.this.uniforms.get(uniformName);
                    if (uniform == null && uniformName.endsWith("[0]")) {
                        uniform = (Uniform)ShaderEntry.this.uniforms.get(uniformName.substring(0, uniformName.length() - 3));
                    }
                    return uniform != null ? uniform.location : -1;
                }
            };
        }
    }

    private static class Uniform {
        private final int location;

        private Uniform(int location, int size, int type) {
            this.location = location;
        }
    }
}

