/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.core.Util;
import java.util.LinkedList;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoEffectContextProxy
implements IVideoEffectContext {
    private static final ThreadLocal<LinkedList<IVideoEffectContext>> _threadLocal = new ThreadLocal();

    static void push(IVideoEffectContext impl) {
        VideoEffectContextProxy.getStack(true).addLast(impl);
    }

    static void pop() {
        LinkedList<IVideoEffectContext> stack = VideoEffectContextProxy.getStack(false);
        stack.removeLast();
        if (stack.isEmpty()) {
            _threadLocal.remove();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LinkedList<IVideoEffectContext> getStack(boolean create) {
        void var1_3;
        LinkedList<IVideoEffectContext> linkedList = _threadLocal.get();
        if (linkedList == null) {
            if (!create) throw new IllegalStateException("no stack is found");
            LinkedList linkedList2 = Util.newLinkedList();
            _threadLocal.set(linkedList2);
            return var1_3;
        } else {
            if (!linkedList.isEmpty()) return var1_3;
            throw new IllegalStateException("stack is empty");
        }
    }

    private IVideoEffectContext getImpl() {
        return VideoEffectContextProxy.getStack(false).getLast();
    }

    public VideoBounds getPreviousBounds() {
        return this.getImpl().getPreviousBounds();
    }

    public IVideoBuffer doPreviousEffect() {
        return this.getImpl().doPreviousEffect();
    }

    public Time getTime() {
        return this.getImpl().getTime();
    }

    public void setTime(Time time) {
        this.getImpl().setTime(time);
    }

    public <V> V value(IAnimatableValue<V> avalue) {
        return (V)this.getImpl().value(avalue);
    }

    public GL getGL() {
        return this.getImpl().getGL();
    }

    public GLU getGLU() {
        return this.getImpl().getGLU();
    }

    public RenderResolution getRenderResolution() {
        return this.getImpl().getRenderResolution();
    }

    public ColorMode getColorMode() {
        return this.getImpl().getColorMode();
    }

    public IVideoBuffer createVideoBuffer(VideoBounds bounds) {
        return this.getImpl().createVideoBuffer(bounds);
    }
}

