/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.RenderResolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.internal.services.AbstractRenderContext;
import ch.kuramo.javie.core.internal.services.AntiAliasSupportProxy;
import ch.kuramo.javie.core.internal.services.FontManagerProxy;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.VideoRenderContext;
import com.google.inject.Inject;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GL2;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoRenderContextImpl
extends AbstractRenderContext
implements VideoRenderContext {
    private static final Logger _logger = LoggerFactory.getLogger(VideoRenderContextImpl.class);
    @Inject
    private GLGlobal _glGlobal;
    @Inject
    private AntiAliasSupportProxy.Lifecycle _aaSupportLifecycle;
    @Inject
    private FontManagerProxy.Lifecycle _fontManagerLifecycle;
    private GLContext _glContext;
    private GLU _glu;
    private int _fboId;
    private RenderResolution _resolution;
    private ColorMode _colorMode;
    private Time _frameDuration;

    protected void finalize() throws Throwable {
        if (this._glContext != null) {
            _logger.warn("finalizing a VideoRenderContextImpl object, but the object is not deactivated.");
        }
        super.finalize();
    }

    @Override
    public void activate() {
        if (this._glContext != null) {
            throw new IllegalStateException("already activated");
        }
        super.activate();
        ReentrantLock lock = this._glGlobal.getGlobalLock();
        lock.lock();
        try {
            this._glContext = this._glGlobal.createContext();
            this._glContext.makeCurrent();
        }
        finally {
            lock.unlock();
        }
        GL2 gl = this._glContext.getGL().getGL2();
        this._glu = GLU.createGLU((GL)gl);
        int[] fboId = new int[1];
        gl.glGenFramebuffers(1, fboId, 0);
        this._fboId = fboId[0];
        gl.glBindFramebuffer(36160, this._fboId);
        this._aaSupportLifecycle.createImpl();
        this._fontManagerLifecycle.createImpl();
    }

    @Override
    public void deactivate() {
        this._fontManagerLifecycle.disposeImpl();
        this._aaSupportLifecycle.disposeImpl();
        if (this._glContext != null) {
            GL2 gl = this._glContext.getGL().getGL2();
            gl.glBindFramebuffer(36160, 0);
            gl.glDeleteBuffers(1, new int[]{this._fboId}, 0);
            this._fboId = 0;
            ReentrantLock lock = this._glGlobal.getGlobalLock();
            lock.lock();
            try {
                this._glContext.release();
                this._glGlobal.destroyContext(this._glContext);
            }
            finally {
                lock.unlock();
            }
            this._glContext = null;
            this._glu = null;
        }
        this._resolution = null;
        this._colorMode = null;
        this._frameDuration = null;
        super.deactivate();
    }

    @Override
    public void reset() {
        super.reset();
        this._resolution = null;
        this._colorMode = null;
        this._frameDuration = null;
    }

    @Override
    public <T> T saveAndExecute(WrappedOperation<T> operation) {
        ColorMode colorMode = this._colorMode;
        Time frameDuration = this._frameDuration;
        try {
            T t = super.saveAndExecute(operation);
            return t;
        }
        finally {
            this._colorMode = colorMode;
            this._frameDuration = frameDuration;
        }
    }

    @Override
    public GL getGL() {
        return this._glContext.getGL();
    }

    @Override
    public GLU getGLU() {
        return this._glu;
    }

    @Override
    public RenderResolution getRenderResolution() {
        if (this._resolution == null) {
            throw new IllegalStateException("renderResolution is not set.");
        }
        return this._resolution;
    }

    @Override
    public void setRenderResolution(RenderResolution resolution) {
        if (this._resolution != null) {
            throw new IllegalStateException("renderResolution has already been set.");
        }
        this._resolution = resolution;
    }

    @Override
    public ColorMode getColorMode() {
        return this._colorMode;
    }

    @Override
    public void setColorMode(ColorMode colorMode) {
        this._colorMode = colorMode;
    }

    @Override
    public Time getFrameDuration() {
        return this._frameDuration;
    }

    @Override
    public void setFrameDuration(Time frameDuration) {
        this._frameDuration = frameDuration;
    }
}

