/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine.phases;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.Phase;
import org.eclipse.equinox.internal.provisional.p2.engine.PropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;

public class Property
extends Phase {
    private static final String PHASE_ID = "property";

    public Property(int weight) {
        super(PHASE_ID, weight);
    }

    protected ProvisioningAction[] getActions(Operand operand) {
        InstallableUnitOperand iuOperand;
        if (operand instanceof PropertyOperand) {
            return new ProvisioningAction[]{new ProfilePropertyAction()};
        }
        if (operand instanceof InstallableUnitOperand && (iuOperand = (InstallableUnitOperand)operand).first() != null) {
            if (iuOperand.second() != null) {
                return new ProvisioningAction[]{new UpdateInstallableUnitProfilePropertiesAction()};
            }
            return new ProvisioningAction[]{new RemoveInstallableUnitProfilePropertiesAction()};
        }
        return null;
    }

    public class ProfilePropertyAction
    extends ProvisioningAction {
        public IStatus execute(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            PropertyOperand propertyOperand = (PropertyOperand)parameters.get("operand");
            if (propertyOperand.second() == null) {
                this.removeProfileProperty(profile, propertyOperand);
            } else {
                this.setProfileProperty(profile, propertyOperand, false);
            }
            return null;
        }

        public IStatus undo(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            PropertyOperand propertyOperand = (PropertyOperand)parameters.get("operand");
            if (propertyOperand.first() == null) {
                this.removeProfileProperty(profile, propertyOperand);
            } else {
                this.setProfileProperty(profile, propertyOperand, true);
            }
            return null;
        }

        private void setProfileProperty(Profile profile, PropertyOperand propertyOperand, boolean undo) {
            String value = (String)(undo ? propertyOperand.first() : propertyOperand.second());
            if (propertyOperand instanceof InstallableUnitPropertyOperand) {
                InstallableUnitPropertyOperand iuPropertyOperand = (InstallableUnitPropertyOperand)propertyOperand;
                profile.setInstallableUnitProperty(iuPropertyOperand.getInstallableUnit(), iuPropertyOperand.getKey(), value);
            } else {
                profile.setProperty(propertyOperand.getKey(), value);
            }
        }

        private void removeProfileProperty(Profile profile, PropertyOperand propertyOperand) {
            if (propertyOperand instanceof InstallableUnitPropertyOperand) {
                InstallableUnitPropertyOperand iuPropertyOperand = (InstallableUnitPropertyOperand)propertyOperand;
                profile.removeInstallableUnitProperty(iuPropertyOperand.getInstallableUnit(), iuPropertyOperand.getKey());
            } else {
                profile.removeProperty(propertyOperand.getKey());
            }
        }
    }

    public class RemoveInstallableUnitProfilePropertiesAction
    extends ProvisioningAction {
        Map originalSourceProperties;
        Map originalTargetProperties;

        public IStatus execute(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            InstallableUnitOperand iuOperand = (InstallableUnitOperand)parameters.get("operand");
            IInstallableUnit source = iuOperand.first();
            this.originalSourceProperties = profile.getInstallableUnitProperties(source);
            profile.clearInstallableUnitProperties(source);
            return null;
        }

        public IStatus undo(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            InstallableUnitOperand iuOperand = (InstallableUnitOperand)parameters.get("operand");
            IInstallableUnit source = iuOperand.first();
            profile.clearInstallableUnitProperties(source);
            profile.addInstallableUnitProperties(source, this.originalSourceProperties);
            return null;
        }
    }

    public class UpdateInstallableUnitProfilePropertiesAction
    extends ProvisioningAction {
        Map originalSourceProperties;
        Map originalTargetProperties;

        public IStatus execute(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            InstallableUnitOperand iuOperand = (InstallableUnitOperand)parameters.get("operand");
            IInstallableUnit source = iuOperand.first();
            this.originalSourceProperties = profile.getInstallableUnitProperties(source);
            IInstallableUnit target = iuOperand.second();
            this.originalTargetProperties = profile.getInstallableUnitProperties(target);
            profile.addInstallableUnitProperties(target, this.originalSourceProperties);
            profile.clearInstallableUnitProperties(source);
            return null;
        }

        public IStatus undo(Map parameters) {
            Profile profile = (Profile)parameters.get("profile");
            InstallableUnitOperand iuOperand = (InstallableUnitOperand)parameters.get("operand");
            IInstallableUnit source = iuOperand.first();
            profile.clearInstallableUnitProperties(source);
            profile.addInstallableUnitProperties(source, this.originalSourceProperties);
            IInstallableUnit target = iuOperand.second();
            profile.clearInstallableUnitProperties(target);
            profile.addInstallableUnitProperties(target, this.originalTargetProperties);
            return null;
        }
    }
}

