/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateAction;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatesPopup;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.StatusLineCLabelContribution;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.UpdateWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.DownloadPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProfileModificationOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AutomaticUpdater
implements IUpdateListener {
    StatusLineCLabelContribution updateAffordance;
    AutomaticUpdateAction updateAction;
    IStatusLineManager statusLineManager;
    IInstallableUnit[] iusWithUpdates;
    String profileId;
    AutomaticUpdatesPopup popup;
    IJobChangeListener provisioningJobListener;
    boolean alreadyValidated = false;
    boolean alreadyDownloaded = false;
    private static final String AUTO_UPDATE_STATUS_ITEM = "AutoUpdatesStatus";

    public void updatesAvailable(UpdateEvent event) {
        boolean download = this.getPreferenceStore().getBoolean("download");
        this.profileId = event.getProfileId();
        this.iusWithUpdates = event.getIUs();
        this.validateUpdates(null, true);
        this.alreadyDownloaded = false;
        if (this.iusWithUpdates.length <= 0) {
            this.clearUpdatesAvailable();
            return;
        }
        this.registerProvisioningJobListener();
        final ArrayList initialSelections = new ArrayList();
        final IUElementListRoot root = new IUElementListRoot();
        try {
            ProfileChangeRequest request = UpdateWizard.createProfileChangeRequest((IInstallableUnit[])event.getIUs(), (String)event.getProfileId(), (IUElementListRoot)root, initialSelections, null);
            if (request == null) {
                this.clearUpdatesAvailable();
                return;
            }
            final PlannerResolutionOperation operation = new PlannerResolutionOperation(AutomaticUpdateMessages.AutomaticUpdater_ResolutionOperationLabel, event.getProfileId(), request, null, new MultiStatus("org.eclipse.equinox.p2.ui.sdk.scheduler", 0, null, null), false);
            if (operation.execute((IProgressMonitor)new NullProgressMonitor()).isOK()) {
                if (download) {
                    Job job = ProvisioningOperationRunner.schedule((ProvisioningOperation)new ProfileModificationOperation(AutomaticUpdateMessages.AutomaticUpdater_AutomaticDownloadOperationName, event.getProfileId(), operation.getProvisioningPlan(), new ProvisioningContext(), (PhaseSet)new DownloadPhaseSet(), false), (int)1);
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent jobEvent) {
                            AutomaticUpdater.this.alreadyDownloaded = true;
                            IStatus status = jobEvent.getResult();
                            if (status.isOK()) {
                                AutomaticUpdater.this.createUpdateAction(operation, root, initialSelections);
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                                    final /* synthetic */ 1 this$1;
                                    {
                                        this.this$1 = var1_1;
                                    }

                                    public void run() {
                                        1.access$0(this.this$1).updateAction.suppressWizard(true);
                                        1.access$0(this.this$1).updateAction.run();
                                    }
                                });
                            } else if (status.getSeverity() != 8) {
                                ProvUI.reportStatus((IStatus)status, (int)1);
                            }
                        }

                        static /* synthetic */ AutomaticUpdater access$0(1 var0) {
                            return var0.AutomaticUpdater.this;
                        }
                    });
                } else {
                    this.createUpdateAction(operation, root, initialSelections);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AutomaticUpdater.this.updateAction.suppressWizard(true);
                            AutomaticUpdater.this.updateAction.run();
                        }
                    });
                }
            }
        }
        catch (ProvisionException e) {
            ProvUI.handleException((Throwable)e, (String)AutomaticUpdateMessages.AutomaticUpdater_ErrorCheckingUpdates, (int)1);
        }
    }

    void validateUpdates(IProgressMonitor monitor, boolean isKnownToBeAvailable) {
        ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>();
        int i = 0;
        while (i < this.iusWithUpdates.length) {
            try {
                if ((isKnownToBeAvailable || ProvisioningUtil.getPlanner().updatesFor(this.iusWithUpdates[i], new ProvisioningContext(), monitor).length > 0) && this.validToUpdate(this.iusWithUpdates[i])) {
                    list.add(this.iusWithUpdates[i]);
                }
            }
            catch (ProvisionException e) {
                ProvUI.handleException((Throwable)e, (String)AutomaticUpdateMessages.AutomaticUpdater_ErrorCheckingUpdates, (int)1);
            }
            catch (OperationCanceledException operationCanceledException) {}
            ++i;
        }
        this.iusWithUpdates = list.toArray(new IInstallableUnit[list.size()]);
    }

    private boolean validToUpdate(IInstallableUnit iu) {
        int lock = 0;
        boolean isRoot = false;
        try {
            IProfile profile = ProvisioningUtil.getProfile((String)this.profileId);
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                lock = Integer.parseInt(value);
            }
            isRoot = (value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.root")) == null ? false : Boolean.valueOf(value);
        }
        catch (ProvisionException provisionException) {
        }
        catch (NumberFormatException numberFormatException) {}
        return isRoot && (lock & 2) == 0;
    }

    Shell getWorkbenchWindowShell() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return activeWindow != null ? activeWindow.getShell() : null;
    }

    IStatusLineManager getStatusLineManager() {
        if (this.statusLineManager != null) {
            return this.statusLineManager;
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        try {
            Method method = activeWindow.getClass().getDeclaredMethod("getStatusLineManager", new Class[0]);
            try {
                Object statusLine = method.invoke((Object)activeWindow, new Object[0]);
                if (statusLine instanceof IStatusLineManager) {
                    this.statusLineManager = (IStatusLineManager)statusLine;
                    return this.statusLineManager;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        IWorkbenchPartSite site = activeWindow.getActivePage().getActivePart().getSite();
        if (site instanceof IViewSite) {
            this.statusLineManager = ((IViewSite)site).getActionBars().getStatusLineManager();
        } else if (site instanceof IEditorSite) {
            this.statusLineManager = ((IEditorSite)site).getActionBars().getStatusLineManager();
        }
        return this.statusLineManager;
    }

    void updateStatusLine() {
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.update(true);
        }
    }

    void createUpdateAffordance() {
        this.updateAffordance = new StatusLineCLabelContribution(AUTO_UPDATE_STATUS_ITEM, 5);
        this.updateAffordance.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                AutomaticUpdater.this.launchUpdate();
            }
        });
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.add((IContributionItem)this.updateAffordance);
            manager.update(true);
        }
    }

    void setUpdateAffordanceState(boolean isValid) {
        if (this.updateAffordance == null) {
            return;
        }
        if (isValid) {
            this.updateAffordance.setTooltip(AutomaticUpdateMessages.AutomaticUpdater_ClickToReviewUpdates);
            this.updateAffordance.setImage(ProvUIImages.getImage((String)"tool/update.gif"));
        } else {
            this.updateAffordance.setTooltip(AutomaticUpdateMessages.AutomaticUpdater_ClickToReviewUpdatesWithProblems);
            this.updateAffordance.setImage(ProvUIImages.getImage((String)"tool/update_problems.gif"));
        }
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            manager.update(true);
        }
    }

    void checkUpdateAffordanceEnablement() {
        IStatusLineManager manager;
        boolean shouldBeVisible;
        if (this.updateAffordance == null) {
            return;
        }
        boolean bl = shouldBeVisible = !ProvisioningOperationRunner.hasScheduledOperations();
        if (this.updateAffordance.isVisible() != shouldBeVisible && (manager = this.getStatusLineManager()) != null) {
            this.updateAffordance.setVisible(shouldBeVisible);
            manager.update(true);
        }
    }

    void createUpdatePopup() {
        this.popup = new AutomaticUpdatesPopup(this.getWorkbenchWindowShell(), this.alreadyDownloaded, this.getPreferenceStore());
        this.popup.open();
    }

    void createUpdateAction(PlannerResolutionOperation operation, IUElementListRoot root, ArrayList initialSelections) {
        if (this.updateAction != null) {
            this.updateAction.dispose();
        }
        this.updateAction = new AutomaticUpdateAction(this, this.getSelectionProvider(), this.profileId, operation, root, initialSelections);
    }

    void clearUpdatesAvailable() {
        if (this.updateAffordance != null) {
            IStatusLineManager manager = this.getStatusLineManager();
            if (manager != null) {
                manager.remove((IContributionItem)this.updateAffordance);
                manager.update(true);
            }
            this.updateAffordance.dispose();
            this.updateAffordance = null;
        }
        if (this.popup != null) {
            this.popup.close(false);
            this.popup = null;
        }
        this.alreadyValidated = false;
    }

    ISelectionProvider getSelectionProvider() {
        return new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object[])AutomaticUpdater.this.iusWithUpdates);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection sel) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
    }

    public void launchUpdate() {
        this.alreadyValidated = true;
        this.updateAction.suppressWizard(false);
        this.updateAction.run();
    }

    private void registerProvisioningJobListener() {
        if (this.provisioningJobListener == null) {
            this.provisioningJobListener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench == null || workbench.isClosing()) {
                        return;
                    }
                    if (workbench.getDisplay() == null) {
                        return;
                    }
                    workbench.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            6.access$0(this.this$1).checkUpdateAffordanceEnablement();
                        }
                    });
                }

                public void scheduled(IJobChangeEvent event) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (workbench == null || workbench.isClosing()) {
                        return;
                    }
                    if (workbench.getDisplay() == null) {
                        return;
                    }
                    workbench.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            6.access$0(this.this$1).checkUpdateAffordanceEnablement();
                        }
                    });
                }

                static /* synthetic */ AutomaticUpdater access$0(6 var0) {
                    return var0.AutomaticUpdater.this;
                }
            };
            ProvisioningOperationRunner.addJobChangeListener((IJobChangeListener)this.provisioningJobListener);
        }
    }

    void validateUpdates() {
        Job validateJob = new Job("Update validate job"){

            public IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AutomaticUpdater.this.validateUpdates(monitor, false);
                if (AutomaticUpdater.this.iusWithUpdates.length == 0) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                9.access$0(this.this$1).clearUpdatesAvailable();
                            }
                        });
                    }
                } else {
                    AutomaticUpdater.this.updatesAvailable(new UpdateEvent(AutomaticUpdater.this.profileId, AutomaticUpdater.this.iusWithUpdates));
                }
                return Status.OK_STATUS;
            }

            static /* synthetic */ AutomaticUpdater access$0(9 var0) {
                return var0.AutomaticUpdater.this;
            }
        };
        validateJob.setSystem(true);
        validateJob.setPriority(30);
        validateJob.schedule();
    }

    public void shutdown() {
        if (this.updateAction != null) {
            this.updateAction.dispose();
        }
        if (this.provisioningJobListener != null) {
            ProvisioningOperationRunner.removeJobChangeListener((IJobChangeListener)this.provisioningJobListener);
            this.provisioningJobListener = null;
        }
        this.statusLineManager = null;
        this.updateAction = null;
    }

    IPreferenceStore getPreferenceStore() {
        return AutomaticUpdatePlugin.getDefault().getPreferenceStore();
    }
}

