/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mailagent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.mailagent.Encode;

class MailSource {
    private Map<String, String> frommap = new HashMap<String, String>();
    private Map<String, String> tomap = new HashMap<String, String>();
    private Map<String, String> ccmap = new HashMap<String, String>();
    private Map<String, String> bccmap = new HashMap<String, String>();
    private String replyto;
    private String subject;
    private String message;
    private List<File> templist = new ArrayList<File>();

    protected MailSource() {
    }

    protected void setFrom(String addres, String alias) {
        this.mailexpress(addres);
        this.frommap.put(addres, alias);
    }

    protected void setTo(String addres, String alias) {
        this.mailexpress(addres);
        this.tomap.put(addres, alias);
    }

    protected void setCC(String addres, String alias) {
        this.mailexpress(addres);
        this.ccmap.put(addres, alias);
    }

    protected void setBCC(String addres, String alias) {
        this.mailexpress(addres);
        this.bccmap.put(addres, alias);
    }

    protected String getReplyto() {
        return this.replyto;
    }

    protected void setReplyto(String replyto) {
        this.replyto = replyto;
    }

    protected void setSubject(String subject) {
        if (subject == null || subject.length() == 0) {
            throw new IllegalArgumentException("mail body Nothing!");
        }
        this.subject = Encode.convProphibitCode(Encode.convCp932toJIS(subject));
    }

    protected void setMessage(String message) {
        if (message == null || message.length() == 0) {
            throw new IllegalArgumentException("mail body Nothing!");
        }
        this.message = message;
    }

    protected void setTemp(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists()) {
                throw new IllegalArgumentException("tempFile not exists!! : " + files[i].getPath());
            }
            this.templist.add(files[i]);
        }
    }

    protected void setTemp(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("tempFile not exists!! : " + file.getPath());
        }
        this.templist.add(file);
    }

    protected Map<String, String> getBccmap() {
        return this.bccmap;
    }

    protected Map<String, String> getCcmap() {
        return this.ccmap;
    }

    protected Map<String, String> getFrommap() {
        return this.frommap;
    }

    protected String getMessage() {
        return this.message;
    }

    protected String getSubject() {
        return this.subject;
    }

    protected List<File> getTemplist() {
        return this.templist;
    }

    protected Map<String, String> getTomap() {
        return this.tomap;
    }

    protected void clearTo() {
        this.tomap.clear();
        this.ccmap.clear();
        this.bccmap.clear();
    }

    protected void clearAll() {
        this.tomap.clear();
        this.ccmap.clear();
        this.bccmap.clear();
        this.frommap.clear();
        this.message = null;
        this.subject = null;
        this.replyto = null;
        this.templist.clear();
    }

    private void mailexpress(String str) {
        Pattern objPtn = Pattern.compile("[\\w\\.\\-]+@([\\w\\-]+\\.)+[\\w\\-]+", 2);
        Matcher matcher = objPtn.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Illegal mail addres : " + str);
        }
    }
}

