package jp.sourceforge.mailagent;

import java.util.Properties;

import org.apache.log4j.Logger;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;

/**
 * MailAgentr_.
 * <pre>
 * MailAgent 𐶐NXB
 * [ݒirlsoMݒjAev[gǏoݒRXgN^Ŏw肵āA
 * MailAgent̓sxAݒȂ悤ɂB
 * </pre>
 */
public final class MailAgentBuilder{
   private MailConfig config;
   private TemplateConfig  templateConfig;

   /**
    * RXgN^irlsoMݒ̂݁j.
    * @param config [ݒirlsoMݒjw肷IuWFNgɗ\ߐݒlĂƁB
    */
   public MailAgentBuilder(MailConfig config){
      this.config = config;
   }
   /**
    * RXgN^.
    * @param config [ݒirlsoMݒjw肷IuWFNgɗ\ߐݒlĂƁB
    * @param templateConfig ev[gǏoݒAw肷IuWFNgɗ\ߐݒlĂƁB
    */
   public MailAgentBuilder(MailConfig config,TemplateConfig templateConfig){
      this.config = config;
      this.templateConfig = templateConfig;
   }

   /**
    * MailAgent 
    * <pre>
    * ev[ggpȂꍇ́ÄȂgB
    * </pre>
    * @return MailAgent
    */
   public MailAgent create(){
      return this.create(null);
   }

   /**
    * MailAgent iev[gt@Cwj
    * <pre>
    * ev[gǏoݒ TemplateConfig Ŏw肵ev[gTfBNgɁA
    * Ŏw肷ev[gt@C݂Ȃ΂ȂȂB
    *  TemplateConfig#setTemplateLoadpath  ev[gTfBNgw肷
    * </pre>
    * @param templateName ev[gt@C
    * @return MailAgent
    */
   public MailAgent create(String templateName){
      MailAgent mailAgent = new MailAgentImpl();
      mailAgent.setMailConfig(this.config);
      if (templateName==null && this.templateConfig==null){
         return mailAgent;
      }else if(templateName != null && this.templateConfig != null){
         return this.setTemplate(mailAgent,this.templateConfig,templateName);
      }else if(templateName == null && this.templateConfig != null){
         throw new RuntimeException(" templateName is NULL");
      }
      throw new RuntimeException(" TemplateConfig is NULL");
   }

   private MailAgent setTemplate(MailAgent mailAgent,TemplateConfig templateConfig,String templateName){
      Properties prop = new Properties();
      prop.setProperty("resource.loader", "file,class");
      prop.setProperty("file.resource.loader.class", FileResourceLoader.class.getName());
      prop.setProperty("file.resource.loader.path",templateConfig.getTemplateLoadpath());
      prop.setProperty("class.resource.loader.class", ClasspathResourceLoader.class.getName());
      prop.setProperty("input.encoding",templateConfig.getTemplateInEncode());
      prop.setProperty("output.encoding",templateConfig.getTemplateOutEncode());
      // velocity Oo͂ȂݒI
      prop.setProperty("runtime.log.logsystem.class","org.apache.velocity.runtime.log.NullLogSystem");
      // Velocity
      VelocityEngine engine = new VelocityEngine();
      try{
      engine.init(prop);

      StringBuffer sb = new StringBuffer();
      sb.append(""+"\n");
      sb.append("\t\t"+" --------------- Velocity init  ---------------\n");
      sb.append("\t\t"+" resource.loader             = "+engine.getProperty("resource.loader")+"\n");
      sb.append("\t\t"+" file.resource.loader.class  = "+engine.getProperty("file.resource.loader.class")+"\n");
      sb.append("\t\t"+" file.resource.loader.path   = "+engine.getProperty("file.resource.loader.path")+"\n");
      sb.append("\t\t"+" class.resource.loader.class = "+engine.getProperty("class.resource.loader.class")+"\n");
      sb.append("\t\t"+" input.encoding   = "+engine.getProperty("input.encoding")+"\n");
      sb.append("\t\t"+" output.encoding  = "+engine.getProperty("output.encoding")+"\n");
      sb.append("\t\t"+" runtime.log.logsystem.class = "+engine.getProperty("runtime.log.logsystem.class")+"\n");
      Logger logger = Logger.getLogger("mailagent");
      logger.debug(sb.toString());
      logger.debug(" template set = "+templateName);

      mailAgent.setTemplate(engine.getTemplate(templateName));
      return mailAgent;
      }catch(Exception e){
         throw new RuntimeException(" Velocity init error Exception : "+e.getMessage(),e);
      }
   }
}
