package jp.sourceforge.mailagent;

import java.io.File;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/**
 * MailAgent
 */
class MailAgentImpl  implements MailAgent{
   private MailConfig config;      // [Mݒ
   private String mailbody;             // [a
   private MailSource mailSource;       // [M\[X
   private Template template;   // Velocity [ev[g
   private Logger logger;
   protected MailAgentImpl(){
      this.mailSource = new MailSource();
      this.logger = Logger.getLogger("mailagent");
   }

   /* [MiXbhsj.
    * @see jp.sourceforge.mailagent.MailAgent#post()
    */
   public void post(){
      SendmailThread sm = new SendmailThread(this.mailSource);
      sm.setSMTP(this.config.getSmtphost()
                 ,this.config.isSmtpauth()
                 ,this.config.getSmtpuser()
                 ,this.config.getSmtppasswd()
                 ,this.config.getTimeout());
      sm.setEncode(this.config.getEncode());
      Thread th = new Thread(sm);
      th.start();
   }
   /* [MiʎQƁj.
    * @see jp.sourceforge.mailagent.MailAgent#send()
    */
   public ResultMail send(){
      SendmailThread sm = new SendmailThread(this.mailSource);
      sm.setSMTP(this.config.getSmtphost()
            ,this.config.isSmtpauth()
            ,this.config.getSmtpuser()
            ,this.config.getSmtppasswd()
            ,this.config.getTimeout());
      sm.setEncode(this.config.getEncode());
      return sm.send();
   }
   //===========================================================================================
   /* TOFݒ.
    * @see jp.sourceforge.mailagent.MailAgent#setTO(java.lang.String[])
    */
   public void setTO(String[] toary){
      for(int i=0;i < toary.length;i++){
         this.mailSource.setTo(toary[i],null);
      }
   }
   /* TOFݒiGCAXwj
    * @see jp.sourceforge.mailagent.MailAgent#setTO(java.util.Map)
    */
   public void setTO(Map<String,String> tomap){
      for(Iterator<String> it=tomap.keySet().iterator();it.hasNext();){
         String key = it.next();
         this.mailSource.setTo(key,tomap.get(key));
      }
   }
   //===========================================================================================
   /* CCFݒ
    * @see jp.sourceforge.mailagent.MailAgent#setCC(java.lang.String[])
    */
   public void setCC(String[] ccary){
      for(int i=0;i < ccary.length;i++){
         this.mailSource.setCC(ccary[i],null);
      }
   }
   /* CCFݒiGCAXwj
    * @see jp.sourceforge.mailagent.MailAgent#setCC(java.util.Map)
    */
   public void setCC(Map<String,String> ccmap){
      for(Iterator<String> it=ccmap.keySet().iterator();it.hasNext();){
         String key = it.next();
         this.mailSource.setCC(key,ccmap.get(key));
      }
   }
   //===========================================================================================
   /* BCCFݒ
    * @see jp.sourceforge.mailagent.MailAgent#setBCC(java.lang.String[])
    */
   public void setBCC(String[] bccary){
      for(int i=0;i < bccary.length;i++){
         this.mailSource.setBCC(bccary[i],null);
      }
   }
   /* BCCFݒiGCAXwj
    * @see jp.sourceforge.mailagent.MailAgent#setBCC(java.util.Map)
    */
   public void setBCC(Map<String,String> bccmap){
      for(Iterator<String> it=bccmap.keySet().iterator();it.hasNext();){
         String key = it.next();
         this.mailSource.setBCC(key,bccmap.get(key));
      }
   }
   //===========================================================================================
   /* M҃AhXݒ
    * @see jp.sourceforge.mailagent.MailAgent#setFROM(java.lang.String)
    */
   public void setFROM(String from){
      this.mailSource.setFrom(from,null);
   }

   /* M҃AhXGCAXݒ
    * @see jp.sourceforge.mailagent.MailAgent#setFROM(java.lang.String, java.lang.String)
    */
   public void setFROM(String from,String alias){
      this.mailSource.setFrom(from,alias);
   }

   /* ԐMAhXݒ
    * @see jp.sourceforge.mailagent.MailAgent#setReplyTo(java.lang.String)
    */
   public void setReplyTo(String replyTo){
      this.mailSource.setReplyto(replyTo);
   }
   //===========================================================================================
   /* [Zbg
    * @see jp.sourceforge.mailagent.MailAgent#setSubject(java.lang.String)
    */
   public void setSubject(String subject){
      this.mailSource.setSubject(subject);
   }
   //===========================================================================================
   /* [{Zbgiev[gȂj
    * @see jp.sourceforge.mailagent.MailAgent#setBody(java.lang.String)
    */
   public void setBody(String body){
      if (body==null){ throw new IllegalArgumentException(" mail body is null"); }
      if (body.length()==0){ throw new IllegalArgumentException(" mail body length is 0"); }
      this.mailSource.setMessage(Encode.convProphibitCode(Encode.convCp932toJIS(body)));
   }
   /* [{Zbgiev[gwj
    * @see jp.sourceforge.mailagent.MailAgent#setBody(java.util.Map)
    */
   public void setBody(Map<String,Object> map){
      if (this.template==null){
         throw new NullPointerException(" template not Config");
      }
      this.mailbody = "";
      VelocityContext context = new VelocityContext();  // VelocityContext
      // uMapVelocityContextɃZbg
      if (map != null){
         Set<String> keySet = map.keySet();
         for (Iterator<String> it=keySet.iterator();it.hasNext();){
            String key = it.next();
            context.put(key,map.get(key));
         }
      }
      // [ev[gƃ}[W
      try{
      StringWriter sw = new StringWriter();
      this.template.merge(context,sw);
      sw.close();
      this.mailbody = Encode.convProphibitCode(Encode.convCp932toJIS(sw.toString()));
      }catch(ResourceNotFoundException e){
         throw e;
      }catch(ParseErrorException e){
         throw e;
      }catch(Exception e){
         throw new RuntimeException(" Exception :"+e.getMessage(),e);
      }finally{
         this.mailSource.setMessage(this.mailbody);
      }
   }
   //===========================================================================================
   /* Ytt@CZbg
    * @see jp.sourceforge.mailagent.MailAgent#setTempFiles(java.io.File[])
    */
   public void setTempFiles(File...temps){
      this.mailSource.setTemp(temps);
   }
   //===========================================================================================
   /* [Mׂ̈̈AMҁAbZ[WASĂNAB
    * @see jp.sourceforge.mailagent.MailAgent#clearAll()
    */
   public void clearAll(){
      this.mailSource.clearAll();
   }
   /* ZbgꂽATO,CC,BCCNAB
    * @see jp.sourceforge.mailagent.MailAgent#clearTo()
    */
   public void clearTo(){
      this.mailSource.clearTo();
   }
   //===========================================================================================
   /* ev[gō쐬ꂽ[{Q
    * @see jp.sourceforge.mailagent.MailAgent#getMessage()
    */
   public String getMessage(){
      return this.mailSource.getMessage();
   }
   //===========================================================================================
   /* [ݒ.
    * @see jp.sourceforge.mailagent.MailAgent#setMailConfig(jp.sourceforge.mailagent.MailConfig)
    */
   public void setMailConfig(MailConfig config){
      this.config = config;
      StringBuffer sb = new StringBuffer();
      sb.append(""+"\n");
      sb.append("\t\t"+" --------------- MailAgent init Config ---------------\n");
      sb.append("\t\t"+" SMTP_HOST    = "+this.config.getSmtphost()+"\n");
      sb.append("\t\t"+" TIMEOUT      = "+Integer.toString(this.config.getTimeout())+" sec"+"\n");
      sb.append("\t\t"+" SMTP_AUTH    = "+this.config.isSmtpauth()+"\n");
      sb.append("\t\t"+" SMTP_USER    = "+this.config.getSmtpuser()+"\n");
      sb.append("\t\t"+" SMTP_PASSWD  = "+this.config.getSmtppasswd()+"\n");
      sb.append("\t\t"+" MAIL_ENCODE  = "+this.config.getEncode()+"\n");
      this.logger.debug(sb.toString());
   }
   /* ev[gݒ
    * @see jp.sourceforge.mailagent.MailAgent#setTemplate(org.apache.velocity.Template)
    */
   public void setTemplate(Template template){
      this.template = template;
   }

}
