<?php
/*
 * Jeans CMS ver 0.7 (GPL license)
 * $Id: admin.php 148 2010-03-02 20:41:09Z kmorimatsu $
 */

class admin extends jeans{
	static public function init(){
		// Load the language file
		self::translate('_ADMIN_NAME');
	}
	static private $custom_admin_page=false;
	static public function register_page($array){
		if (is_array($array) && !self::$custom_admin_page) self::$custom_admin_page=$array;
	}
	static public function selector($skin=false){
		// Determine admin skin
		if (!$skin) $skin=member::setting('admin_skin');
		if ( !($skin && self::local_file_exists(_DIR_SKINS,$skin)) ) {
			$skin=_CONF_DEFAULT_ADMIN_SKIN;
			if (!self::local_file_exists(_DIR_SKINS,$skin)) $skin='/admin/skin.inc';
		}
		// TODO: check the authority here.
		$warning=self::translate('_ADMIN_NO_PERMISSION');
		$parent_skin=false;
		$data=false;
		if (isset($_GET['poption'])) {
			$page='poption';
		} elseif (isset($_GET['reactivate'])) {
			$page='reactivate';
		} else $page=isset($_GET['page'])?$_GET['page']:'main';
		switch($page){
			case 'main': case 'edititem': case 'itemlist': case 'subgrouplist': case 'groupsetting':
			case 'config': case 'db': case 'commentlist': case 'editcomment': case 'batch':
			case 'newgroup': case 'membersetting': case 'memberlist': case 'loginsetting':
			case 'plugin': case 'poption': case 'reactivate': case 'forgotpassword': case 'media':
			case 'log':
				$template=$page;
				break;
			default:
				if (isset(self::$custom_admin_page[$page])) {
					$template=self::$custom_admin_page[$page];
					break;
				}
				$template='main';
				error::note(_ADMIN_FEATURE_NOT_IMPLEMENTED);
		}
		switch($template){
			case 'main': case 'reactivate': case 'forgotpassword':
				break;
			case 'commentlist': case 'batch': case 'membersetting': case 'loginsetting':
				if (!member::logged_in()) error::quit($warning);
				break;
			default:
				if (substr($template,0,6)=='guest_') break;
				elseif (substr($template,0,7)=='member_' && member::logged_in()) break;
				// Only superadmin can go ahead
				if (!member::is_admin()) error::quit($warning);
		}
		view::parse_skin($skin,$parent_skin,$data,$template);
	}
	static public function item_from_post($row=array()){
		if (!count($_POST)) return false;
		$post=$_POST;
		unset($post['action']);
		unset($post['ticket']);
		foreach($post as $key=>$value){
			if (substr($key,-5)!='_text') continue;
			$row[substr($key,0,-5)]=$value;
			unset($post[$key]);
		}
		return array_merge($post,$row);
	}
	static public function tag_callback(&$data,$event){
		$args=func_get_args();
		array_shift($args); //&$data
		array_shift($args); //$event
		$arg=array('data'=>&$data);
		while (1<count($args)) {
			$key=array_shift($args);
			$value=array_shift($args);
			$arg[$key]=$value;
		}
		core::event($event,$arg,'admin');
	}
}