<?php
/*
 * Jeans CMS ver 0.7 (GPL license)
 * $Id: admin_item.php 148 2010-03-02 20:41:09Z kmorimatsu $
 */

class admin_item extends jeans{
	static public function init(){
		// Load the language file
		$warning=self::translate('_ADMIN_NO_PERMISSION');
		// Only superadmin can use this class
		if (!member::is_admin()) error::quit($warning);
	}
	static public function tag_edititemform(&$data,$skin=false){
		// TODO: show POSTed values in form when edititem is failed.
		if ($skin===false) $skin=$data['skin'];
		$itemid=(int)@$_GET['itemid'];
		if ($itemid==0) {
			$row=array('id'=>0);
			if (isset($_GET['sgid'])) $row['sgid']=$_GET['sgid'];
			$row['time']=gmdate('Y-m-d H:i:s', time());
			$row['author']=member::setting('id');
		} else {
			$query='SELECT * FROM jeans_item WHERE id=<%itemid%> LIMIT 1';
			$array=array('itemid'=>$itemid);
			$row=sql::query($query,$array)->fetch();
		}
		$post=self::item_from_post();
		if (isset($post['time'])) $post['time']=gmdate('Y-m-d H:i:s', strtotime($post['time']));
		if ($post) $row=array_merge($row,$post);
		view::show_using_array($data,array($row),$skin);
	}
	static public function tag_list(&$data,$skin,$limit=10){
		$gid=isset($_GET['gid'])?(int)$_GET['gid']:0;
		$offset=isset($_GET['offset'])?(int)$_GET['offset']:0;
		$sgid=isset($_GET['sgid'])?(int)$_GET['sgid']:0;
		$mid=isset($_GET['mid'])?(int)$_GET['mid']:0;
		$query='SELECT '.
			'i.id as id, '.
			'i.time as time, '.
			'i.author as author, '.
			'i.title as title, '.
			'i.body as body, '.
			'i.more as more, '.
			'i.gid as gid, '.
			'i.sgid as sgid, '.
			'i.gid as blogid, '.
			'i.sgid as catid, '.
			'g.name as gname, '.
			'g.desc as gdesc, '.
			's.name as sname, '.
			's.desc as sdesc, '.
			'm.name as aname '.
			'FROM jeans_item as i, jeans_group as g, jeans_group as s, jeans_member as m '.
			'WHERE i.author=m.id '.
			($mid ? 'AND i.author=<%mid%> ':'').
			($gid ? 'AND i.gid=<%gid%> ':'').
			($sgid ? 'AND i.sgid=<%sgid%> ':'').
			'AND i.gid=g.id '.
			'AND i.sgid=s.id '.
			'ORDER by time DESC '.
			'LIMIT <%limit%> OFFSET <%offset%>';
		$array=array('gid'=>$gid, 'sgid'=>$sgid, 'mid'=>$mid, 'limit'=>$limit, 'offset'=>$offset);
		$items=sql::count_query($query,$array);
		$data['libs']['page']=array('items'=>$items,'offset'=>$offset,'limit'=>$limit);
		view::show_using_query($data,$query,$array,$skin,array('blog','_blog_cb'));
	}
	static private $ribbon=array();
	static public function tag_addtoribbon(&$data,$name=false,$desc=false,$script=false,$type='text',$text='',$width=16,$height=16){
		if (!$name) {
			self::$ribbon=array();
			return;
		}
		if ($type=='img') $text=_CONF_URL_SKINS.substr(view::skinfile($data,$text),1);
		self::$ribbon[$name]=array(
			'name'=>$name,
			'desc'=>self::translate($desc),
			'script'=>$script,
			'type'=>$type,
			'text'=>$text,
			'width'=>$width,
			'height'=>$height);
	}
	static public function tag_ribbon(&$data,$skin){
		$ribbon=self::$ribbon;
		core::event('pre_parse_ribbon',array('data'=>&$data,'ribbon'=>&$ribbon),'admin');
		view::show_using_array($data,self::$ribbon,$skin);
		core::event('post_parse_ribbon',array('data'=>&$data),'admin');
	}
	static private function item_from_post() {
		if (empty($_POST['sgid'])) return false;
		$res=sql::query('SELECT gid FROM jeans_group WHERE id=<%sgid%>',$_POST);
		if (!$res) return false;
		$row=$res->fetch();
		if ($row['gid']==0) $row['gid']=$_POST['sgid'];
		return admin::item_from_post($row);
	}
	static public function action_post_edititem(){
		$post=self::item_from_post();
		if (!$post) {
			//sgid error
			return;
		}
		$post['time']=gmdate('Y-m-d H:i:s', strtotime($post['time']));
		if (!empty($_GET['itemid'])) $post['id']=$_GET['itemid'];
		$query='INSERT OR REPLACE INTO jeans_item (<%key:row%>) VALUES (<%row%>)';
		sql::query($query,array('row'=>$post));
		if (sql::pdo()->errorCode()=='00000') {
			core::set_cookie('note_text',_ADMIN_ITEM_SAVED,0);
			core::redirect_local(_CONF_SELF.'?page=itemlist&gid='.(int)$post['gid']);
		} else {
			// Insert error
		}
	}
}