<?php
/*
 * Jeans CMS ver 0.7 (GPL license)
 * $Id: admin_memberinfo.php 148 2010-03-02 20:41:09Z kmorimatsu $
 */

class admin_memberinfo extends jeans {
	static private $mid;
	static public function init(){
		// Load the language file
		$warning=self::translate('_ADMIN_NO_PERMISSION');
		// Superadmin can use this class
		// The member also can use this class, but only for own information.
		self::$mid=isset($_GET['mid'])?(int)$_GET['mid']:false;
		if (!member::is_admin()) {
			if (!member::login()) error::quit($warning);
			if (self::$mid!=member::setting('id')) error::quit($warning);
		}
	}
	static public function data($key,$mid=false){
		static $cache;
		if (!isset($cache)) {
			$cache=array();
			$query='SELECT * FROM jeans_member';
			$res=sql::query($query);
			while($row=$res->fetch()){
				$cache[$row['id']]=$row;
				sql::convert_xml($cache[$row['id']],'member');
			}
			$query='SELECT id, loginname, authority, email as loginemail FROM jeans_login';
			sql::select_pdo('member');
			$res=sql::query($query);
			while($row=$res->fetch()){
				$row['admin']=($row['authority'] & member::MEMBER_IS_ADMIN) ? 1:0;
				$row['canlogin']=($row['authority'] & member::MEMBER_CAN_LOGIN) ? 1:0;
				$cache[$row['id']]=array_merge($cache[$row['id']],$row);
			}
		}
		if ($key==false && $mid==false) return $cache;
		if ($mid==false) $mid=self::$mid;
		if (!isset($cache[$mid])) return false;
		if (!isset($cache[$mid][$key])) return false;
		return $cache[$mid][$key];
	}
	static public function tag_data(&$data,$key){
		self::p(self::data($key));
	}
	static public function tag_setting(&$data,$skin){
		$array=array();
		$array[]=array(
			'name'=>'name',
			'desc'=>self::translate('_ADMIN_MEMBERINFO_NAME'),
			'value'=>self::data('name'),
			'type'=>'text',
			'extra'=>'');
		$array[]=array(
			'name'=>'language',
			'desc'=>self::translate('_ADMIN_MEMBERINFO_LANGUAGE'),
			'value'=>self::data('language'),
			'type'=>'select',
			'extra'=>'languagelist');
		$res=sql::query('SELECT * FROM jeans_config_desc WHERE configtype="member" ORDER BY sequence ASC');
		while ($row=$res->fetch()) {
			// TODO: Remove properties that cannot be edited by non-admin member
			$row['value']=self::data($row['name']);
			$row['name'].='_text';
			$row['desc']=self::translate($row['desc']);
			$array[]=$row;
		}
		view::show_using_array($data,$array,$skin);
	}
	static public function tag_memberlist(&$data,$skin){
		$array=self::data(false);
		view::show_using_array($data,$array,$skin);
	}
	static public function action_post_membersetting(){
		// TODO: disable editing some member setting by non-admin member.
		$post=admin::item_from_post();
		$query='SELECT id FROM jeans_member WHERE name=<%name%> AND NOT id=<%id%> LIMIT 1';
		$array=array('name'=>$post['name'],'id'=>$_GET['mid']);
		if (sql::query($query,$array)->fetch()) {
			// The name is already used.
			error::note('The name `<%0%>` is already used.',$post['name']);
			return;
		}
		$xml=new SimpleXMLElement(_XML_BLANC);
		foreach($post as $key=>$value){
			if ($key=='name' || $key=='language') continue;
			$xml->$key=$value;
		}
		$query='UPDATE jeans_member SET name=<%name%>, language=<%language%>, xml=<%xml%> WHERE id=<%id%>';
		$array=array_merge($post,array('xml'=>$xml->asXML(),'id'=>$_GET['mid']));
		sql::query($query,$array);
		core::set_cookie('note_text',self::translate('_ADMIN_MEMBERINFO_MEMBERSETTING_SAVED'),0);
		if (member::is_admin()) {
			core::redirect_local(_CONF_SELF.'?page=memberlist');
		} else {
			core::redirect_local(_CONF_SELF);
		}
	}
	static public function action_post_loginsetting(){
		// Prepare data
		$post=admin::item_from_post();
		if ($post['password1']!=$post['password2']) {
			core::set_cookie('note_text',self::translate('_ADMIN_MEMBERINFO_PASSWORD_MISMATCH'),0);
			core::redirect_local(_CONF_SELF.'?page=membersetting&mid='.(int)$_GET['mid']);
		}
		if (0<strlen($post['password1']) && strlen($post['password1'])<6) {
			core::set_cookie('note_text',self::translate('_ADMIN_MEMBERINFO_PASSWORD_TOO_SHORT'),0);
			core::redirect_local(_CONF_SELF.'?page=membersetting&mid='.(int)$_GET['mid']);
		}
		// If password isn't set, show the confirm page.
		if (!isset($post['password'])) return;
		// Check is password is correct
		if (!member::try_login(member::setting('loginname'),$post['password'])){
			error::note('_ADMIN_MEMBERINFO_WRONG_PASSWORD');
			return;
		}
		// Prepare query and array
		// Note that loginname and authority columns should not be changed here.
		if (0<strlen($post['password1'])) {
			$query='UPDATE jeans_login SET password=<%password%>, email=<%email%> WHERE id=<%id%>';
		} else {
			$query='UPDATE jeans_login SET email=<%email%> WHERE id=<%id%>';
		}
		$array=array(
			'id'=>$_GET['mid'],
			'email'=>$post['email'],
			'password'=>hash('sha512',_HASH_SALT.$post['password1']));
		// Let's check the authority here again for security though it's checked in init() method.
		if (!member::logged_in()) error::quit(_ADMIN_NO_PERMISSION);
		if (member::setting('id')!=$_GET['id'] && !member::is_admin()) error::quit(_ADMIN_NO_PERMISSION);
		sql::select_pdo('member');
		$res=sql::query($query,$array);
		// Everything is done. Show the information.
		if ($res->rowCount()) $note=self::translate('_ADMIN_MEMBERINFO_LOGINSETTING_SAVED');
		else $note=self::translate('_ADMIN_MEMBERINFO_LOGINSETTING_NOT_SAVED');
		core::set_cookie('note_text',$note,0);
		if (member::is_admin()) {
			core::redirect_local(_CONF_SELF.'?page=memberlist');
		} else {
			core::redirect_local(_CONF_SELF);
		}
	}
}