<?php
/*
 * Jeans CMS ver 0.7 (GPL license)
 * $Id: error.php 148 2010-03-02 20:41:09Z kmorimatsu $
 */


class error extends jeans {
	static public function quit($text,$data=array()){
		self::show($text,$data,'quit');
		exit;
	}
	static public function show($text,$data=array(),$log='show'){
		if (preg_match('/^_([A-Z][A-Z0-9]*)_([A-Z0-9]*)(?:_[A-Z0-9]*)*$/',$text,$m)) $text=self::translate($text);
		core::log(self::fill_html($text,$data),__CLASS__,$log);
		if (!defined('_CONF_DEBUG_MODE')) {
			if (error_reporting() & E_WARNING) self::echo_html('<!--\'"--><%0%>',$text);
			return;
		}
		if (!is_array($data)) $data=array($data);
		self::echo_html('<!--\'"-->'.$text,$data);
		$db=debug_backtrace();
		self::echo_html('<!--');
		print_r($db);
		self::echo_html('-->');
		for ($i=0;$i<count($db);$i++) {
			if ($db[$i]['class']=='error') continue;
			$db=$db[$i-1];
			break;
		}
		$db['file']=@preg_replace('/^.*[\/\\\\]([a-z0-9_]+\.php)$/i','$1',$db['file']);
		self::echo_html("<br />\r\nError occured at line <%line%> in <%file%>",$db);
	}
	static private $note=array();
	static public function note($text,$data=false){
		if ($data===false) {
			self::$note[]=self::quote_html($text);
		} else {
			if (preg_match('/^_([A-Z][A-Z0-9]*)_([A-Z0-9]*)(?:_[A-Z0-9]*)*$/',$text)) $text=self::translate($text);
			self::$note[]=self::fill_html($text,$data);
		}
	}
	static public function fatal($text=false,$data=false){
		static $fatal=false;
		if ($text===false) return $fatal;
		$fatal=true;
		self::note($text,$data);
	}
	static public function get_note(){
		foreach (self::$note as $key=>$error) {
			if (preg_match('/^_([A-Z][A-Z0-9]*)_([A-Z0-9]*)(?:_[A-Z0-9]*)*$/',$error)) self::$note[$key]=self::translate($error);
		}
		return self::$note;
	}
	static public function tag_note(&$data,$skin){
		$array=array();
		foreach (self::get_note() as $error) {
			$array[]=array('error'=>$error);
		}
		view::show_using_array($data,$array,$skin);
	}
	// From view.php
	static public function compile_error($source,$compiled){
		if (defined('_CONF_DEBUG_MODE')) {
			$array=array(&$source,&$compiled);
			foreach($array as &$temp) {
				$temp=preg_split('/(\r\n|\r|\n)/',$temp);
				foreach($temp as $key=>$line) $temp[$key]=substr('  '.($key+1).':',-4).$line;
				$temp=implode("\n",$temp);
			}
			self::echo_html('<hr /><pre><%0%><hr /><%1%></pre><hr />',array($source,$compiled),'hsc');
		}
		return create_function('','return false;');
	}
	// From core.php
	static public function set_error($mode,$error,$array=array()){
		
	}
}