<?php
/*
 * Jeans CMS ver 0.7 (GPL license)
 * $Id: group.php 148 2010-03-02 20:41:09Z kmorimatsu $
 */

class group extends jeans {
	static private $groupid;
	static public function init(){
		if (isset($_GET['gid'])) self::$groupid=(int)$_GET['gid'];
		if (isset($_GET['sgid'])) {
			$query='SELECT id,gid,sgid FROM jeans_group WHERE id=<%subgroup%>';
			$array=array('subgroup'=>(int)$_GET['sgid']);
			$row=sql::query($query,$array)->fetch();
			if ($row) {
				if ($row['gid']) self::$groupid=(int)$row['gid'];
				elseif ($row['sgid']==0) self::$groupid=(int)$row['id'];
				else error::fatal('Such subgroup doesn`t exist.');
			} else error::fatal('Such subgroup doesn`t exist.');
		} elseif (isset($_GET['itemid'])) {
			$query='SELECT gid FROM jeans_item WHERE id=<%itemid%>';
			$array=array('itemid'=>(int)$_GET['itemid']);
			$row=sql::query($query,$array)->fetch();
			if ($row) self::$groupid=(int)$row['gid'];
			else error::fatal('Such item doesn`t exist.');
		}
		if (!isset(self::$groupid)) self::$groupid=(int)_CONF_DEFAULT_GROUP;
	}
	static public function set_id($id){
		if (!self::setting('id',$id)) return false;
		self::$groupid=$id;
		return true;
	}
	static public function setting($key,$groupid=false){
		static $cache;
		if (!isset($cache)) {
			$cache=$blogs=array();
			$query='SELECT * FROM jeans_group WHERE gid=0 AND sgid=0';
			$res=sql::query($query);
			while ($row=$res->fetch()) {
				sql::convert_xml($row,'group');
				$blogs[]=$row['id'];
				$cache[$row['id']]=$row;
			}
		}
		if (!$groupid) $groupid=self::$groupid;
		if (!isset($cache[$groupid])) return false;
		if (!isset($cache[$groupid][$key])) return false;
		return $cache[$groupid][$key];
	}
	static public function tag_setting(&$data,$key,$group=false){
		self::p(self::setting($key,$group));
	}
	static public function sgsetting($key,$sgid=false){
		static $cache=array();
		if (!$sgid) $sgid=isset($_GET['sgid'])?(int)$_GET['sgid']:0;
		if (!$sgid) return false;
		if (!isset($cache[$sgid])) {
			$query='SELECT * FROM jeans_group WHERE id=<%sgid%> LIMIT 1';
			$data=array('sgid'=>$sgid);
			$cache[$sgid]=sql::query($query,$data)->fetch();
			if (!$cache[$sgid]) $cache[$sgid]=array();
			sql::convert_xml($cache[$sgid],'subgroup');
		}
		if (!isset($cache[$sgid][$key])) return false;
		return $cache[$sgid][$key];
	}
	static public function tag_sgsetting(&$data,$key,$sgid=false){
		self::p(self::sgsetting($key,$sgid));
	}
	static public function all_subgroups($gid,$sgid){
		$query='SELECT * FROM jeans_group '.
			'WHERE (gid=<%gid%> AND NOT sgid=<%gid%>) '.
			'OR id=<%sgid%>';
		$array=array('gid'=>$gid, 'sgid'=>$sgid);
		$res=sql::query($query,$array);
		$groups=array();
		while ($row=$res->fetch()) {
			$row['childs']=array();
			$groups[$row['id']]=$row;
		}
		foreach ($groups as $key=>$row) {
			$groups[$row['sgid']]['childs'][]=&$groups[$key];
		}
		return self::all_subgroups_sub($groups[$sgid]);
	}
	static private function all_subgroups_sub($groups,&$found=null){
		$gid=$groups['id'];
		if (is_array($found)) {
			// Avoid infinite loop
			if (in_array($gid,$found)) return array();
		}
		$result=array($gid);
		foreach ($groups['childs'] as $child) {
			$result[]=$child['id'];
			$result=array_merge($result,all_subgroups_sub($child,$result));
		}
		return $result;
	}
	static public function tag_list(&$data,$skin){
		$query='SELECT * FROM jeans_group WHERE gid=0 AND sgid=0';
		$selected=isset($data['gid'])?$data['gid']:0;
		self::cb_tag_list($selected);// Initialize
		view::show_using_query($data,$query,array(),$skin,array('group','cb_tag_list'));
	}
	static public function cb_tag_list(&$row){
		static $selected=0;
		if (is_array($row)) {
			if ($row['id']==$selected) $row['selected']=true;
		} else $selected=$row;
	}
	static public function tag_tree(&$data,$skin,$restrict_group=false,$gid=false){
		$gid=self::setting('id',$gid);
		$query='SELECT id, name, desc, gid, sgid FROM jeans_group '.
			($restrict_group ? 'WHERE id=<%gid%> OR (gid=<%gid%> AND NOT sgid=0)':'');
		$res=sql::query($query,array('gid'=>$gid));
		$rows=array();
		while ($row=$res->fetch()) {
			$row['childs']=array();
			if (isset($data['sgid'])) {
				if ($data['sgid']==$row['id']) $row['selected']=true;
			}
			$rows[$row['id']]=$row;
		}
		foreach ($rows as $id=>$row) {
			if ($row['sgid']) {
				$rows[$row['sgid']]['childs'][$row['name'].' '.md5($row['id'])]=&$rows[$id];
				ksort($rows[$row['sgid']]['childs']);
			}
		}
		$array=array();
		foreach ($rows as $row) {
			if ($row['gid']==0 && $row['sgid']==0) $array[$row['name'].' '.md5($row['id'])]=$row;
		}
		ksort($array);
		$data['treedepth']=0;
		view::show_using_array($data,$array,$skin);
	}
	static public function tag_treesub(&$data,$skin=false){
		if ($skin===false) $skin=$data['skin'];
		if (100<$data['treedepth']) return; //avoid infinite loop
		foreach ($data['childs'] as $child){
			$temp_data=$data;
			$temp_data['treedepth']++;
			$temp_data['childs']=array();
			unset($temp_data['selected']);
			foreach($child as $key=>$value) $temp_data[$key]=$value;
			view::tag_template($temp_data,'body',$skin);
		}
	}
	static public function tag_treetab(&$data,$template,$skin=false){
		if ($skin===false) $skin=$data['skin'];
		for ($i=0;$i<$data['treedepth'];$i++) view::tag_template($data,$template,$skin);
	}
}