enum InputEventType {
	Keyboard,
	Point
}
enum Keytype {
	left,
	right,
	up,
	down,
	enter,
	esc
}
class InputEvent {
	type: InputEventType;
	param: any;

	constructor(type:InputEventType, param?:any) {
		this.type = type;
		this.param = param;
	}
}
class InputKeyboardEvent extends InputEvent {
	key: Keytype;
	constructor(key:Keytype, e:any) {
		super(InputEventType.Keyboard, e);
		this.key = key;
	}
}
class InputPointEvent extends InputEvent {
	x: number;
	y: number;
	point: CommonOffset;
	entity: E;

	constructor(e:any, entity:E, scale?:number) {
		super(InputEventType.Point, e);
		var entityOffset = entity.offset();
		this.entity = entity;
		this.point = {
			x: scale ? e.offsetX / scale : e.offsetX,
			y: scale ? e.offsetY / scale : e.offsetY
		}
		this.x = this.point.x - entityOffset.x;
		this.y = this.point.y - entityOffset.y;
	}
}