class Sprite extends E {
	image: any; // HTMLImageElement, HTMLVideoElement, HTMLCanvasElement
	sep:number;
	frame:number[];
	fno:number;

	constructor(width:number, height:number, image?:any) {
		super();
		this.x = 0;
		this.y = 0;
		this.width = width;
		this.height = height;
		this.image = image;
		this.sep = Math.floor(this.image.width / this.width);
		this.frame = [0];
		this.fno = 0;
	}

	draw(area:Area, context:CanvasRenderingContext2D) {
		context.drawImage(
			this.image,
			(this.frame[this.fno] % this.sep) * this.width,
			Math.floor(this.frame[this.fno] / this.sep) * this.height,
			this.width,
			this.height,
			0,//area.x + this.x,
			0,//area.y + this.y,
			this.width,
			this.height
		);
	}

	refresh() {
		if (this.image instanceof HTMLCanvasElement) {
			//多分壊れてるが、復旧方法不明
		}
	}
}