/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jindolf.archiver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jp.sourceforge.jindolf.archiver.Builder;
import jp.sourceforge.jindolf.archiver.FileArchive;
import jp.sourceforge.jindolf.archiver.PeriodResource;
import jp.sourceforge.jindolf.archiver.VillageData;
import jp.sourceforge.jindolf.archiver.XmlUtils;
import jp.sourceforge.jindolf.parser.DecodeException;
import jp.sourceforge.jindolf.parser.HtmlParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipUtils {
    public static List<VillageData> getVillageDataList(ZipFile zipFile) throws IOException {
        LinkedList<VillageData> result = new LinkedList<VillageData>();
        List<ZipEntry> logList = ZipUtils.getDownloadLogList(zipFile);
        for (ZipEntry entry : logList) {
            VillageData villageData = ZipUtils.getVillageDataFromLogEntry(zipFile, entry);
            result.add(villageData);
        }
        return result;
    }

    public static List<ZipEntry> getDownloadLogList(ZipFile file) {
        LinkedList<ZipEntry> result = new LinkedList<ZipEntry>();
        Enumeration<? extends ZipEntry> list = file.entries();
        while (list.hasMoreElements()) {
            ZipEntry entry = list.nextElement();
            String name = entry.getName();
            if (!name.endsWith("/download.log")) continue;
            result.add(entry);
        }
        return result;
    }

    public static VillageData getVillageDataFromLogEntry(ZipFile zipFile, ZipEntry logEntry) throws IOException {
        InputStream istream = zipFile.getInputStream(logEntry);
        List<PeriodResource> list = FileArchive.parseDownloadLog(istream);
        istream.close();
        String baseName = logEntry.getName().replaceAll("/[^/]+$", "/");
        for (PeriodResource resource : list) {
            ZipUtils.modifyResourceUrl(zipFile, baseName, resource);
        }
        VillageData villageData = new VillageData(list);
        return villageData;
    }

    public static PeriodResource modifyResourceUrl(ZipFile zipFile, String entryBase, PeriodResource resource) {
        URL zipResource;
        String fileName;
        try {
            URL resUrl = resource.getResourceUrl();
            URI resUri = resUrl.toURI();
            File file = new File(resUri);
            fileName = file.getName();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String zipUri = new File(zipFile.getName()).toURI().toString();
        String urlText = "jar:" + zipUri + "!/" + entryBase + fileName;
        try {
            zipResource = new URL(urlText);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        resource.setResourceUrl(zipResource);
        return resource;
    }

    public static VillageData getVillageData(ZipFile zipFile, int vid) throws IOException {
        ZipEntry entry = ZipUtils.getDownloadLogEntry(zipFile, vid);
        VillageData result = ZipUtils.getVillageDataFromLogEntry(zipFile, entry);
        return result;
    }

    public static ZipEntry getDownloadLogEntry(ZipFile file, int vid) {
        Pattern entryPattern = Pattern.compile("jin_[^_]+_([0-9]+)/download.log$");
        Enumeration<? extends ZipEntry> list = file.entries();
        while (list.hasMoreElements()) {
            String vnum;
            ZipEntry entry = list.nextElement();
            String name = entry.getName();
            Matcher matcher = entryPattern.matcher(name);
            if (!matcher.find() || vid != Integer.parseInt(vnum = matcher.group(1))) continue;
            return entry;
        }
        return null;
    }

    public static void dumpZipVid(ZipFile zipFile, int vid, Writer writer) throws IOException, DecodeException, HtmlParseException {
        VillageData data = ZipUtils.getVillageData(zipFile, vid);
        Builder.fillVillageData(data);
        XmlUtils.dumpVillageData(writer, data);
    }

    public static void dumpZipAll(ZipFile zipFile) throws IOException, DecodeException, HtmlParseException {
        List<VillageData> villageDataList = ZipUtils.getVillageDataList(zipFile);
        Iterator<VillageData> it = villageDataList.iterator();
        while (it.hasNext()) {
            VillageData villageData = it.next();
            Builder.fillVillageData(villageData);
            Writer writer = XmlUtils.createFileWriter(villageData);
            XmlUtils.dumpVillageData(writer, villageData);
            writer.close();
            it.remove();
        }
    }

    private ZipUtils() {
    }
}

