<?php
//-- アイコン変更コントローラー --//
final class IconEditController extends JinrouController {
  const URL = 'icon_view.php';

  protected static function Start() {
    if (Security::IsInvalidReferer(self::URL)) {
      self::OutputError(IconEditMessage::REFERER);
    }
  }

  protected static function Load() {
    Loader::LoadRequest('icon_edit');
  }

  protected static function EnableCommand() {
    return true;
  }

  protected static function RunCommand() {
    //入力データチェック
    extract(RQ::ToArray()); //引数を展開
    $url = sprintf('<a href="%s?icon_no=%d">%s</a>', self::URL, $icon_no, Message::BACK);

    if ($password != UserIconConfig::PASSWORD) { //パスワード照合
      self::OutputError(IconEditMessage::PASSWORD, $url);
    }

    if (false === Text::Exists($icon_name)) { //空文字チェック
      self::OutputError(IconEditMessage::NAME, $url);
    }

    //アイコン名の文字列長チェック
    $query = IconDB::GetQueryUpdate();
    $stack = [];
    foreach (UserIcon::ValidateText(IconEditMessage::TITLE, $url) as $key => $value) {
      if (true === is_null($value)) {
	$query->SetNull($key);
      } else {
	$stack[$key] = $value;
      }
    }

    if (true === Text::Exists($color)) { //色指定チェック
      $stack['color'] = UserIcon::ValidateColor($color, IconEditMessage::TITLE, $url);
    }

    //トランザクション開始
    DB::Connect();
    if (false === DB::Lock('icon')) {
      self::OutputError(IconEditMessage::LOCK . Message::DB_ERROR_LOAD, $url);
    }

    if (false === IconDB::Exists($icon_no)) { //存在チェック
      self::OutputError(sprintf(IconEditMessage::NOT_EXISTS, $icon_no), $url);
    }

    if (true === IconDB::Duplicate($icon_no, $icon_name)) { //アイコン名重複チェック
      self::OutputError(sprintf(IconEditMessage::DUPLICATE, $icon_name), $url);
    }

    if (true === IconDB::Using($icon_no)) { //編集制限チェック
      self::OutputError(IconEditMessage::USING, $url);
    }

    if (IconDB::Disable($icon_no) !== $disable) { //非表示フラグチェック
      $query->SetData('disable', $disable ? Query::ENABLE : Query::DISABLE);
    }
    $query->Set(array_keys($stack));

    if (count($stack) < 1) { //変更が無いなら終了
      //現状はここに入ることは事実上無い。精度を上げる場合はDBから引いて比較すること
      self::OutputError(IconEditMessage::NO_CHANGE, $url);
    }
    $list = array_merge(array_values($stack), [$icon_no]);
    //self::OutputError($query->p() . print_r($list, true), $url); //テスト用

    if (IconDB::Update($query, $list) && DB::Commit()) {
      $str = sprintf('%s?icon_no=%d', self::URL, $icon_no);
      HTML::OutputResult(IconEditMessage::TITLE, IconEditMessage::SUCCESS, $str);
    } else {
      self::OutputError(IconEditMessage::UPDATE . Message::DB_ERROR_LOAD, $url);
    }
  }

  //エラー出力
  private static function OutputError($str, $url = null) {
    if (false === is_null($url)) {
      $str = Text::Join($str, $url);
    }
    HTML::OutputResult(IconEditMessage::TITLE, $str);
  }
}
